var {__} = function() {}
if(typeof wp === "object" && wp.i18n == "object") {
    var {__} = wp.i18n;
}
let forms = [];                                                                                                         // All Forms
let datas = [];                                                                                                         // All Data contents
let afincluded = false;
let extraParms = undefined;
let execForm = undefined;
let terminbuchungslistener = 0;
let phoneInputElement;
let af2Styles = // The basic styling
        {
            "af2_answer":
                    [
                        {
                            "attribute": "width",
                            "value": "200px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "width",
                            "value": "100%",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "margin",
                            "value": "20px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "margin",
                            "value": "7px 15px",
                            "special_class": "af2_mobile"
                        },
                        /**{
                            "attribute": "max-width",
                            "value": "90%",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "min-width",
                            "value": "90%",
                            "special_class": "af2_mobile"
                        }**/
                    ],
            "af2_form_carousel":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 30px auto",
                        }
                    ],
                "af2_answer_card":
                    [
                        {
                            "attribute": "height",
                            "value": "150px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "min-height",
                            "value": "52px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "15px"
                        },
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "background-color",
                            "value": "rgba(0, 0, 0, 0)"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1"
                        }
                    ],
            "af2_form_heading_wrapper":
                    [
                        {
                            "attribute": "margin",
                            "value": "30px auto 30px auto"
                        },
                        {
                            "attribute": "width",
                            "value": "100%"
                        }
                    ],
            "af2_form_heading":
                    [
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "margin",
                            "value": "0 auto"
                        }
                    ],
            "af2_question_heading_wrapper":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 55px auto"
                        }
                    ],
            "af2_content_frage":
            [
                {
                    "attribute": "margin",
                    "value": "0 auto 0 auto"
                }
            ],
            "af2_dateiupload": [
                {
                    "attribute": "margin",
                    "value": "0 auto 0 auto"
                }
            ],
            "af2_dateiupload_inner": [
                {
                    "attribute": "border-radius",
                    "value": "10px"
                }
            ],
            "af2_ahref": [
                {
                    "attribute": "color",
                    "value": "rgba(157, 65, 221, 1) !important"
                }
            ],
            "af2_question_description":
                    [
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "font-size",
                            "value": "20px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "18px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": "",
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "margin-top",
                            "value": "15px !important",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "margin-top",
                            "value": "15px !important",
                            "special_class": "af2_mobile"
                        }
                    ],
            "af2_question_heading":
                    [
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "font-size",
                            "value": "32px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "24px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": "",
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        }
                    ],
            "af2_answer_image_wrapper":
                    [
                        {
                            "attribute": "padding",
                            "value": "0 7px"
                        },
                        {
                            "attribute": "width",
                            "value": "70px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "margin-right",
                            "value": "10px",
                            "special_class": "af2_mobile"
                        }
                    ],
            "af2_answer_text":
                    [
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "margin-left",
                            "value": "15px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-size",
                            "value": "16px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "line-height",
                            "value": "27px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "20px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-size",
                            "value": "17px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-weight",
                            "value": "",
                        }
                    ],
            "af2_form":
                    [
                        {
                            "attribute": "background-color",
                            "value": "rgba(255, 255, 255, 1)"
                        },
                        {
                            "attribute": "padding",
                            "value": "7px"
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "10px"
                        }
                    ],
            "af2_form_button":
                    [
                        {
                            "attribute": "background-color",
                            "value": ""
                        },
                        {
                            "attribute": "border-radius",
                            "value": "7px"
                        },
                        {
                            "attribute": "border",
                            "value": "none"
                        },
                        {
                            "attribute": "padding",
                            "value": "0 10px"
                        },
                        {
                            "attribute": "min-height",
                            "value": "50px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "color",
                            "value": "rgba(255, 255, 255, 1)"
                        },
                        {
                            "attribute": "fill",
                            "value": "rgba(255, 255, 255, 1)"
                        },
                        {
                            "attribute": "background-color",
                            "value": "#d7d7d7",
                            "special_class": "af2_disabled"
                        },
                        {
                            "attribute": "min-height",
                            "value": "40px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-size",
                            "value": "18px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "16px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-family",
                            "value": "Montserrat"
                        }
                    ],
            "af2_form_bottombar":
                    [
                        {
                            "attribute": "padding",
                            "value": "0 15px"
                        }
                    ],
            "af2_form_wrapper":
                    [
                        {
                            "attribute": "width",
                            "value": "100%"
                        },
                        {
                            "attribute": "max-width",
                            "value": "1250px"
                        }
                    ],
            "af2_textfeld_frage":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 50px auto !important"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "7px"
                        },
                        {
                            "attribute": "height",
                            "value": "50px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit",
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "border",
                            "value": "",
                            "special_state": "focus"
                        }
                    ],
            "af2_datum_frage":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 20px auto !important"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "7px"
                        },
                        {
                            "attribute": "height",
                            "value": "50px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "text-align",
                            "value": "center"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "border",
                            "value": "",
                            "special_state": "focus"
                        }
                    ],
            "af2_slider_frage_wrapper":
                    [

                    ],
            "af2_slider_frage_bullet":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 20px auto"
                        },
                        {
                            "attribute": "color",
                            "value": "#333"
                        },
                        {
                            "attribute": "font-weight",
                            "value": "600"
                        },
                        {
                            "attribute": "font-size",
                            "value": "32px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "20px",
                            "special_class": "af2_mobile"
                        }
                    ],
            "af2_slider_frage":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 15px auto !important"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "10px"
                        },
                        {
                            "attribute": "height",
                            "value": "15px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "background-color",
                            "value": "",
                        },
                        {
                            "attribute": "background-color",
                            "value": "#333",
                            "special_extra": "-webkit-slider-thumb"
                        },
                        {
                            "attribute": "background-color",
                            "value": "#333",
                            "special_extra": "-moz-range-thumb"
                        }
                    ],
                    "af2_slider_frage_val":
                    [
                        {
                            "attribute": "border",
                            "value": "",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "font-size",
                            "value": "17px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "16px",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": "500px"
                        }
                    ],
                    "af2_slider_frage_val_after":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "10px 0 0 10px"
                        }
                    ],
                    "af2_slider_frage_val_before":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "0 10px 10px 0"
                        }
                    ],
                    "af2_slider_frage_val_after.af2_rtl_layout":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "0 10px 10px 0"
                        }
                    ],
                    "af2_slider_frage_val_before.af2_rtl_layout":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "10px 0 0 10px "
                        }
                    ],
                    "select2-search__field":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "10px"
                        }
                    ],
            "af2_textbereich_frage":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 50px auto !important"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "7px"
                        },
                        {
                            "attribute": "height",
                            "value": "150px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "line-height",
                            "value": "",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "border",
                            "value": "",
                            "special_state": "focus"
                        }
                    ],
            "af2_question_wrapper":
                    [
                        {
                            "attribute": "width",
                            "value": "90%"
                        },
                        {
                            "attribute": "margin",
                            "value": "0 auto 25px !important"
                        },
                        {
                            "attribute": "color",
                            "value": ""
                        }
                    ],
            "af2_text_type":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "0 7px 7px 0"
                        },
                        {
                            "attribute": "height",
                            "value": "47px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "border",
                            "value": "1px solid",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit"
                        },
                        {
                            "attribute": "font-size",
                            "value": ""
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "padding",
                            "value": ""
                        },
                        {
                            "attribute": "max-width",
                            "value": "100%"
                        },
                        {
                            "attribute": "width",
                            "value": "100%"
                        },
                        {
                            "attribute": "color",
                            "value": ""
                        }
                    ],
            "af2_text_type.af2_rtl_layout":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "7px 0 0 7px"
                        }
                    ],
                    "af2_text_type_":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "7px 7px 7px 7px"
                        },
                        {
                            "attribute": "height",
                            "value": "47px"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "box-shadow",
                            "value": "5px 5px 15px 0 #e1e1e1",
                        },
                        {
                            "attribute": "border",
                            "value": "1px solid",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "font-family",
                            "value": "inherit"
                        },
                        {
                            "attribute": "font-size",
                            "value": ""
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "padding",
                            "value": ""
                        },
                        {
                            "attribute": "max-width",
                            "value": "100%"
                        },
                        {
                            "attribute": "width",
                            "value": "100%"
                        },
                        {
                            "attribute": "color",
                            "value": ""
                        }
                    ],
            "af2_checkbox_type":
                    [
                        {
                            "attribute": "margin-right",
                            "value": "15px"
                        }
                    ],
            "af2_answer.selected_item .af2_answer_card":
                    [
                        {
                            "attribute": "border",
                            "value": "5px 5px 15px 0 #e1e1e1"
                        }
                    ],
            "af2_form_progress_bar":
                    [
                        {
                            "attribute": "width",
                            "value": "100%"
                        },
                        {
                            "attribute": "height",
                            "value": "8px"
                        },
                        {
                            "attribute": "border-radius",
                            "value": "15px"
                        },
                        {
                            "attribute": "border",
                            "value": ""
                        },
                        {
                            "attribute": "background-color",
                            "value": "white"
                        },
                        {
                            "attribute": "margin",
                            "value": "21px"
                        }
                    ],
            "af2_form_progress_bar_wrapper":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 15px"
                        },
                        {
                            "attribute": "width",
                            "value": "100%"
                        }
                    ],
            "af2_form_progress":
                    [
                        {
                            "attribute": "border-radius",
                            "value": "15px"
                        },
                        {
                            "attribute": "background-color",
                            "value": ""
                        }
                    ],
            "af2_form_percentage":
                    [
                        {
                            "attribute": "width",
                            "value": "50px"
                        },
                        {
                            "attribute": "height",
                            "value": "25px"
                        },
                        {
                            "attribute": "background-color",
                            "value": ""
                        },
                        {
                            "attribute": "color",
                            "value": "#ffffff"
                        }
                    ],
            "af2_form_percentage_triangle":
                    [
                        {
                            "attribute": "border-color",
                            "value": ""
                        }
                    ],
            "af2_multiselect_style":
                    [
                        {
                            "attribute": "font-size",
                            "value": "24px",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "20px",
                            "special_class": "af2_mobile"
                        }
                    ],
            "af2_question_label":
                    [
                        {
                            "attribute": "font-size",
                            "value": "17",
                            "special_class": "desktop"
                        },
                        {
                            "attribute": "font-size",
                            "value": "15",
                            "special_class": "af2_mobile"
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "margin-bottom",
                            "value": "8px !important"
                        }
                    ],
                    "af2_question":
                    [
                        {
                            "attribute": "margin",
                            "value": "0 auto 0 auto"
                        }
                    ],
            "af2_submit_button":
                    [
                        {
                            "attribute": "font-size",
                            "value": ""
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        },
                        {
                            "attribute": "padding",
                            "value": ""
                        },
                        {
                            "attribute": "padding-left",
                            "value": ""
                        },
                        {
                            "attribute": "padding-right",
                            "value": ""
                        },
                        {
                            "attribute": "border-radius",
                            "value": ""
                        },
                        {
                            "attribute": "background-color",
                            "value": ""
                        },
                        {
                            "attribute": "outline",
                            "value": "none",
                            "special_state": "focus"
                        },
                        {
                            "attribute": "border",
                            "value": "none"
                        },
                        {
                            "attribute": "transition",
                            "value": "all 400ms ease-out"
                        },
                        {
                            "attribute": "color",
                            "value": ""
                        },
                        {
                            "attribute": "margin",
                            "value": "20px auto 0 auto !important"
                        },
                        {
                            "attribute": "white-space",
                            "value": 'normal'
                        },
                        {
                            "attribute": "width",
                            "value": "50%"
                        },
                        {
                            "attribute": "font-family",
                            "value": ""
                        },
                        {
                            "attribute": "--rgb",
                            "value": ""
                        },
                        {
                            "attribute": "--rgbcol",
                            "value": ""
                        },
                    ],
            "af2_question_cb_label":
                    [
                        {
                            "attribute": "font-size",
                            "value": ""
                        },
                        {
                            "attribute": "font-weight",
                            "value": ""
                        }
                    ],
            "af2_datepicker_header":
                    [
                        {
                            "attribute": "background-color",
                            "value": "",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-title"
                        },
                        {
                            "attribute": "color",
                            "value": "",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-title"
                        }
                    ],
            "ui-datepicker-title":
            [
                {
                    "attribute": "font-family",
                    "value": "Montserrat"
                },
            ],
            "desktop .ui-datepicker-title":
            [
                {
                    "attribute": "font-size",
                    "value": "17px"
                }
            ],
            "af2_mobile .ui-datepicker-title":
            [
                {
                    "attribute": "font-size",
                    "value": "15px"
                }
            ],
            "af2_datepicker_active":
                    [
                        {
                            "attribute": "background-color",
                            "value": "",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-current-day"
                        },
                        {
                            "attribute": "color",
                            "value": "",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-state-active"
                        }
                    ],
            "af2_datepicker_buttons":
                    [
                        {
                            "attribute": "background-color",
                            "value": "#fff",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-prev"
                        },
                        {
                            "attribute": "color",
                            "value": "#3a3a3a",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-prev"
                        },
                        {
                            "attribute": "background-color",
                            "value": "#fff",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-next"
                        },
                        {
                            "attribute": "color",
                            "value": "#3a3a3a",
                            "special_class": "af2_datepicker",
                            "sub_class": "ui-datepicker-next"
                        }
                ],
                "af2_form_html_content":
                [
                    {
                        "attribute": "font-family",
                        "value": "inherit"
                    },
                    {
                        "attribute": "font-size",
                        "value": ""
                    },
                    {
                        "attribute": "font-weight",
                        "value": ""
                    }
                ],
                "af2_radio_label": [
                    {
                        "attribute": "font-size",
                        "value": ""
                    },
                    {
                        "attribute": "font-weight",
                        "value": ""
                    },
                ],
                "af2_question_cf_text_type_icon": [
                    {
                        "attribute": "width",
                        "value": "70px"
                    },
                    {
                        "attribute": "height",
                        "value": "50px"
                    },
                    {
                        "attribute": "background-color",
                        "value": "rgba(157, 65, 221, 1)"
                    },
                    {
                        "attribute": "border-radius",
                        "value": "10px 0 0 10px"
                    }
                ],
                "af2_question_cf_text_type_icon.af2_rtl_layout": [
                    {
                        "attribute": "border-radius",
                        "value": "0 10px 10px 0"
                    }
                ],
                "af2_ad_trans":
                [
                    {
                        "attribute": "font-family",
                        "value": "inherit"
                    },
                    {
                        "attribute": "height",
                        "value": "50px"
                    },
                    {
                        "attribute": "border-radius",
                        "value": "10px"
                    },
                    {
                        "attribute": "border",
                        "value": "",
                        "special_state": "focus"
                    },
                    {
                        "attribute": "box-shadow",
                        "value": "",
                        "special_state": "focus"
                    },
                    {
                        "attribute": "box-shadow",
                        "value": ""
                    },
                    {
                        "attribute": "box-shadow",
                        "value": "5px 5px 15px 0 #e1e1e1"
                    },
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "15px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500",
                    }
                ],
                "af2_slider_input_wrap":
                [
                    {
                        "attribute": "height",
                        "value": "50px"
                    },
                ],
                "af2_address_field_":
                [
                    {
                        "attribute": "border-radius",
                        "value": "10px"
                    }
                ],
                "af2_form_loader":
                [
                    {
                        "attribute": "color",
                        "value": "rgba(0,0,0,1)"
                    }
                ],
                "af2_adress_map_input_wrapper":
                [
                    {
                        "attribute": "border-radius",
                        "value": "10px"
                    }
                ],
                "af2_html_content_summary":
                [
                    {
                        "attribute": "border-radius",
                        "value": "10px"
                    }
                ],
                "af2_ad_trans_tabel":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "16px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500",
                    },
                ],
                "af2_html_content_summary_object_title_":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "16px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "700",
                    },
                ],
                "af2_html_content_summary_object_answer_":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "16px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500",
                    },
                ],
                "alternate_text_wrap_span":
                [
                    {
                        "attribute": "background-color",
                        "value": "rgba(157, 65, 221, 1)"
                    },
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "16px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500"
                    }
                ],
                "alternate_text_wrap_span_after":
                [
                    {
                        "attribute": "border-radius",
                        "value": "0 10px 10px 0"
                    }
                ],
                "alternate_text_wrap_span_before":
                [
                    {
                        "attribute": "border-radius",
                        "value": "10px 0 0 10px"
                    }
                ],
                "alternate_text_wrap_span_after.af2_rtl_layout":
                [
                    {
                        "attribute": "border-radius",
                        "value": "10px 0 0 10px"
                    }
                ],
                "alternate_text_wrap_span_before.af2_rtl_layout":
                [
                    {
                        "attribute": "border-radius",
                        "value": "0 10px 10px 0"
                    }
                ],
                "range_text_box_label":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "16px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500"
                    }
                ],
                "af2_response_error":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500"
                    }
                ],
                "af2-select2-container input.select2-search__field":
                [
                    {
                        "attribute": "border",
                        "value": "",
                        "special_state": "focus",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "border-radius",
                        "value": "",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "box-shadow",
                        "value": "",
                        "special_state": "focus",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "box-shadow",
                        "value": "5px 5px 15px 0 #e1e1e1",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500px",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "font-family",
                        "value": "Montserrat",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.desktop input.select2-search__field":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.af2_mobile input.select2-search__field":
                [
                    {
                        "attribute": "font-size",
                        "value": "15px",
                        "special_class": "form_class"
                    }
                ],
                "select2-results__option.select2-results__option--selectable":
                [
                    {
                        "attribute": "font-weight",
                        "value": "500px",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "font-family",
                        "value": "Montserrat",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.desktop .select2-results__option.select2-results__option--selectable":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.af2_mobile .select2-results__option.select2-results__option--selectable":
                [
                    {
                        "attribute": "font-size",
                        "value": "15px",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.select2-selection.select2-selection--single":
                [
                    {
                        "attribute": "border",
                        "value": "",
                        "special_state": "focus",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "font-weight",
                        "value": "500px",
                        "special_class": "form_class"
                    },
                    {
                        "attribute": "font-family",
                        "value": "Montserrat",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.desktop.select2-selection.select2-selection--single":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container.af2_mobile.select2-selection.select2-selection--single":
                [
                    {
                        "attribute": "font-size",
                        "value": "15px",
                        "special_class": "form_class"
                    }
                ],
                "af2-select2-container .select2-results__option.select2-results__option--selectable.select2-results__option--highlighted":
                [
                    {
                        "attribute": "background-color",
                        "value": "",
                        "special_class": "form_class"
                    }
                ],
                "af2_terminbuchung_heading":
                [
                    {
                        "attribute": "font-size",
                        "value": "17px",
                        "special_class": "desktop"
                    },
                    {
                        "attribute": "font-size",
                        "value": "15px",
                        "special_class": "af2_mobile"
                    },
                    {
                        "attribute": "font-family",
                        "value": "inherit"
                    },
                    {
                        "attribute": "color",
                        "value": ""
                    }
                ],
                "af2_terminbuchung_time": [
                    {
                        "attribute": "--rgb",
                        "value": ""
                    },
                    {
                        "attribute": "--rgbcol",
                        "value": ""
                    }
                ],
                "af2_terminbuchung_duration": [
                    {
                        "attribute": "--rgb",
                        "value": ""
                    },
                    {
                        "attribute": "--rgbcol",
                        "value": ""
                    }
                ],
                "af2_notification": [
                    {
                        "attribute": "--rgb",
                        "value": ""
                    },
                    {
                        "attribute": "--rgbcol",
                        "value": ""
                    }
                ],
                "af2_terminbuchungs_wrap #select2-af2_zeitzone-container.select2-selection__rendered": [
                    {
                        "attribute": "--rgb",
                        "value": ""
                    }
                ],
                "af2_calender_wait--loading": [
                    {
                        "attribute": "--rgb",
                        "value": ""
                    }
                ],
                "af2_slider_image_icon_wrapper": [
                    {
                        "attribute": "color",
                        "value": ""
                    }
                ]
        };


/**
 * The Initialize Method
 */
const af2_init = ($) => {

    /** Filling the Forms with all Forms on the Screen **/
    $('.af2_form_wrapper').each((i, el) => {
        const id = $(el).data('did');
        const num = $(el).data('num');
        const preload = $(el).data('preload');
        const size = $(el).data('size');
        const errormail = $(el).data('errormail');
        const activateScrollToAnchor = $(el).data('activatescrolltoanchor');
        const showSuccessScreen = $(el).data('showsuccessscreen');
        const popup_by_delay = $(el).data('popup_by_delay');
        const popup_delay = $(el).data('popup_delay');
        const popup_by_click = $(el).data('popup_by_click');
        const popup_click_class = $(el).data('popup_click_class');

        if(popup_by_delay) {
            setTimeout(() => {
                af2_create_popup($, num, () => {
                    forms[num] = new Form($, id, num, preload, size, errormail, activateScrollToAnchor, true, showSuccessScreen);
                });
            }, popup_delay);
        }
        else if(popup_by_click) {
            const s = '.'+popup_click_class;
            $(document).on('click', s, (ev) => {
                
                $(document).off('click', s);

                af2_create_popup($, num, () => {
                    forms[num] = new Form($, id, num, preload, size, errormail, activateScrollToAnchor, true, showSuccessScreen);
                });

                $(document).on('click', s, (ev) => {
                    $('#afpbg_'+num).addClass('show');
                    $('body').addClass('af2_noscroll');
                    forms[num] = new Form($, id, num, preload, size, errormail, activateScrollToAnchor, true, showSuccessScreen);
                });
            });
        }
        else 
        {
            forms[num] = new Form($, id, num, preload, size, errormail, activateScrollToAnchor, false, showSuccessScreen);
        }

        
    });

};

const af2_create_popup = ($, num, cb) => {
    let mouseEnter = false;

    let cont = $($('#afpbg_'+num).parent()).html();
    $($('#afpbg_'+num).parent()).html("");
    $('body').append('<div>'+cont+'</div>');
    $('#afpbg_'+num).addClass('show');

    $('body').addClass('af2_noscroll');

    $(document).on('click', '#afpbg_'+num+' .af2_close_popup', (ev) => {
        const num = $(ev.currentTarget).data('num');
        $('#afpbg_'+num+' .af2_form_carousel').html('');
        
        $('#afpbg_'+num+'.af2_popup_background').removeClass('show');
        $('body').removeClass('af2_noscroll');
        
    });

    $(document).on('click', '#afpbg_'+num, (ev) => {
        if(!mouseEnter) {
            const id = $(ev.currentTarget).attr('id');
            $('#'+id+' .af2_form_carousel').html('');
            $('#'+id+'.af2_popup_background').removeClass('show');
            $('body').removeClass('af2_noscroll');
        }
    });

    $(document).on('mouseenter', '#afpbg_'+num+' .af2_popup_wrapper', (ev) => {
        mouseEnter = true;
    });
    $(document).on('mouseleave', '#afpbg_'+num+' .af2_popup_wrapper', (ev) => {
        mouseEnter = false;
    });

    cb();
}

/**
 * For multiple forms on the screen
 *
 * @param $
 * @param id
 * @param num
 * @param preload
 * @param size
 * @constructor
 */
function Form($, id, num, preload, size, errormail, activateScrollToAnchor, popup, showSuccessScreen) {
    this.errormail = errormail;
    this.activateScrollToAnchor = activateScrollToAnchor;
    this.$ = $;                                                                                                         // The jQuery operator
    this.id = id;                                                                                                       // Dataid
    this.num = num;                                                                                                     // Key of the element To call
    this.preload = preload;                                                                                             // Amount of preloads
    this.size = size;                                                                                                   // Max size (amount of sections)
    this.formSelector = '#af2_form_' + this.num;                                                                        // Selector for everything within this form
    this.actualSection = 0;                                                                                             // Section the Form is actually in
    this.actualContent = 0;                                                                                             // Content the Form is actually showing
    this.neededContent = undefined;                                                                                     // The neededContent to draw
    this.actualData = undefined;                                                                                        // The actual Dataid
    this.actualCarouselItem = 0;
    this.beforeSection = [];
    this.beforeContent = [];
    this.needsDraw = true;
    this.answers = [];
    this.set = false;
    this.af2_is_send_allowed = false;
    this.popup = popup;
    this.resizeListener_init = false;
    this.stor = {};
    this.attachment_ids = [];
    this.dsgvo = true;
    this.dsgvoid = null;
    this.rtl_layout = $(this.formSelector).data('rtl');

    this.contactFormAnswers = [];

    this.showSuccessScreen = showSuccessScreen;

    this.hasVerification = false;
    this.verifictationId = undefined;
    this.verifictationDataId = undefined;

    this.resendTimer = undefined;
    this.resendValue = 10;

    this.answerObject = [];
    this.firstQuestion = true;
    this.lastTerminbuchungsObject = {};
    this.lastTerminbuchungsTimeslotsMonday =        [[],[],[]];
    this.lastTerminbuchungsTimeslotsTuseday =       [[],[],[]];
    this.lastTerminbuchungsTimeslotsWednesday =     [[],[],[]];
    this.lastTerminbuchungsTimeslotsThursday =      [[],[],[]];
    this.lastTerminbuchungsTimeslotsFriday =        [[],[],[]];
    this.lastTerminbuchungsTimeslotsSaturday =      [[],[],[]];
    this.lastTerminbuchungsTimeslotsSunday =        [[],[],[]];

    this.lastTerminbuchungsTimeslotsSpecials = new Map();
    this.lastTerminbuchungsTimeslotsSpecialsDisabled = new Map();
    this.lastTerminbuchungsTimeslotsAllEvents = [];
    this.actualTerminMonth = af2_getTodayStandard().getMonth();
    this.actualTerminYear = af2_getTodayStandard().getFullYear();
    this.pufferTime = 0;
    this.vorlaufzeit = 0;
    //this.autocomplete = undefined;
    //this.autocomplete2 = undefined;
    //this.map = undefined;
    this.lastAdressObj = undefined;
    //this.markers = [];

    this.mapCount = 0;

    this.increaseMapCount = () => {
        this.mapCount++;
    }

    if (this.preload > this.size - 1)
        this.preload = this.size - 1;

    
    this.setLastAddrObject = (value) => {
        this.lastAdressObj = value;
    }

    this.$(this.formSelector).on('af2_loaded_font', (ev) => {
        this.setHeight();
    });


    /**
     * When Loaded the Content for the Form
     */
    this.$(this.formSelector).on('loadedData', (ev) => {
        af2CompareAttributeInArray(this.$, this.id, ev.dataids).done(() => {
            af2LoadStyling(this.$, this.id, this.formSelector, this.setHeight);
            this.loadContent();
        });
    });

    this.$(this.formSelector + ' .af2_form_carousel').on('loadedData', (ev) => {
        if (this.neededContent !== undefined)
        {
            af2CompareAttributeInArray(this.$, this.neededContent, ev.dataids).done(() => {
                this.initDraw();
            });
        }
    });

    

    /**
     * Verify and load the new Content
     */
    this.loadContent = (goBefore) => {
        const prom = $.Deferred();

        const redirectHelper = datas[this.id].sections[this.actualSection].contents[this.actualContent];
        this.neededContent = datas[this.id].sections[this.actualSection].contents[this.actualContent].data;
        /** Check the redirect **/
        if (this.neededContent.includes('redirect'))
        {
            if(typeof af2_doOwnExternalRedirectFunction === 'function')
            {
                af2_doOwnExternalRedirectFunction(this.$, this.answerObject).done((newval) => {
                        if(newval) {
                            this.af2GoNext(param).done((cont) => {
                                this.beforeSection.push(cont[0]);
                                this.beforeContent.push(cont[1]);

                                if(this.beforeSection.length > 0) {
                                    $(this.formSelector + ' .af2_form_back_button').removeClass('af2_disabled');
                                } else {
                                    $(this.formSelector + ' .af2_form_back_button').addClass('af2_disabled');
                                }
                            });
                        }
                        else {
                            //
                        }
                });
            }
            else {
                if(redirectHelper.newtab == 'true' || redirectHelper.newtab == true) {
                    $(this.formSelector + ' .af2_form .af2_form_heading_wrapper').remove();
                    $(this.formSelector + ' .af2_form .af2_form_carousel').remove();
                    $(this.formSelector + ' .af2_form .af2_form_bottombar').remove();
                    
                    let link = this.neededContent.substr(9);

                    try {
                        let objs = window.btoa(JSON.stringify(this.answerObject));
                        link = link.replace(af2_frontend_ajax.strings.antworten_tag, objs);
                    }
                    catch(e) {

                    }

                    window.open(link, '_blank');
                } else if(redirectHelper.newtab == 'false' || redirectHelper.newtab == false) {
                    let link = this.neededContent.substr(9);

                    try {
                        let objs = window.btoa(JSON.stringify(this.answerObject))
                        link = link.replace(af2_frontend_ajax.strings.antworten_tag, objs);
                    }
                    catch(e) {

                    }
                    
                    window.location.href = link;
                }else if(redirectHelper.newtab == null || redirectHelper.newtab == '') {
                    let link = this.neededContent.substr(9);

                    try {
                        let objs = window.btoa(JSON.stringify(this.answerObject));
                        link = link.replace(af2_frontend_ajax.strings.antworten_tag, objs);
                    }
                    catch(e) {

                    }

                    window.location.href = link;
                }
            }
            

            prom.reject();
        } else
        {
            this.iteratePreloads().done((dataids) => {
                if (dataids.length > 0)
                {
                    af2HandleRequest($, this.formSelector, '.af2_form_carousel', dataids, this);
                }
            });
            if (datas[this.neededContent] !== undefined && datas[this.neededContent] !== true)
            {
                this.initDraw(goBefore);
            }
            prom.resolve();
        }

        return prom.promise();
    };

    this.resizeListener = () => {
        if(!this.resizeListener_init) {
            this.$(window).resize(() => {
                const width = this.$(this.formSelector+' .af2_form_heading.desktop').css('display') == 'none' ? this.$(this.formSelector+' .af2_form_heading.af2_mobile').width() : this.$(this.formSelector+' .af2_form_heading.desktop').width();
                // RESIZE DO
                //this.$(this.formSelector+ ' .af2_form_carousel').css('max-width', width + 'px');
                //this.$(this.formSelector+ ' .af2_form_carousel').css('min-width', width + 'px');
                this.$(this.formSelector+ ' .af2_form_carousel').css('max-width', 'unset');
                this.$(this.formSelector+ ' .af2_form_carousel').css('min-width', 'unset');

                this.setHeight();
                
            });
            this.resizeListener_init = true;
        }
    }

    this.initDraw = (goBefore) => {
        if (this.needsDraw === true)
            af2DrawCarouselContent(this.$, this, this.neededContent, this.formSelector, this.actualCarouselItem, this.resizeListener);
        this.actualData = this.neededContent;
        this.neededContent = undefined;
        this.setHeight();
        this.setTriggers();

        if (datas[this.actualData].typ !== undefined &&
                (datas[this.actualData].typ === 'af2_slider' || datas[this.actualData].typ === 'af2_content' || datas[this.actualData].typ === 'af2_dropdown'))
        {
            //
            if(goBefore != true) $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
        } else if(datas[this.actualData].typ === 'af2_textfeld' || datas[this.actualData].typ === 'af2_textbereich_frage') {
            if (datas[this.actualData].type_specifics.mandatory == true) {
                //
                if(goBefore != true) $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
            } else {
                //
                if(goBefore != true) $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            }
        }
        else if(datas[this.actualData].typ === 'af2_dateiupload') {

        }
        else
        {
            //
            /*if(goBefore != true)*/ $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
        }

        if(goBefore === true) {
            if(datas[this.actualData].af2_type == 'frage') {
                if(datas[this.actualData].typ === 'af2_select')         $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_multiselect')    $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_textfeld')       $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_textbereich')    $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_content')        $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_datum')          $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_dateiupload')    $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_dropdown')       $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_slider')         $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                if(datas[this.actualData].typ === 'af2_adressfeld')     $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            }
        }


        $(this.formSelector + ' .af2_form_bottombar').css('opacity', 1);

        if (datas[this.actualData].typ === 'af2_content')
        {
            if (datas[this.actualData].type_specifics.content_button == true)
            {

                $(this.formSelector + ' .af2_form_bottombar').css('opacity', 0);

                getAllImagesDonePromise($, this.formSelector).done(() => {
                    this.setHeight();

                });
            }

            if (datas[this.actualData].type_specifics.content_wait_time !== undefined && $.isNumeric(datas[this.actualData].type_specifics.content_wait_time))
            {
                //blend out everything
                if (datas[this.actualData].type_specifics.content_button == true)
                {
                    $(this.formSelector + ' .af2_submit_wrapper input.af2_submit_button.no_send').css('opacity', 0);
                } else
                {
                    $(this.formSelector + ' .af2_form_bottombar').css('opacity', 0);
                }


                //timer
                setTimeout(() => {
                    if (datas[this.actualData].type_specifics.content_button == true)
                    {
                        $(this.formSelector + ' .af2_submit_wrapper input.af2_submit_button.no_send').css('opacity', 1);
                    } else
                    {
                        $(this.formSelector + ' .af2_form_bottombar').css('opacity', 1);
                    }
                    this.af2Move("", 'next');
                }, datas[this.actualData].type_specifics.content_wait_time);
            }
        }

        if (datas[this.actualData].show_bottombar !== undefined && (datas[this.actualData].show_bottombar == 'false' || datas[this.actualData].show_bottombar == false))
        {
            $(this.formSelector + ' .af2_form_bottombar').css('opacity', 0);
        }
        
        // set height for contact form
        if(datas[this.actualData].af2_type == 'kontaktformular'){
            setTimeout(this.setkontaktformularHeight,500);
        }


        // updating slide position for slow ajax requests
        var that = this;
        setTimeout(function() {
            $(that.formSelector + ' #' + (that.actualCarouselItem)).css('transform');
            direction = '-';
            if(that.rtl_layout == true) {
                direction = '';
            }
            let offset = 'translateX('+direction+''+((that.actualCarouselItem)*100)+'%)';
            $(that.formSelector + ' .af2_carousel_item').css('transform', offset);
        }, 300);

    };
    
    this.setkontaktformularHeight = () => {
        const height = $(this.formSelector + ' .af2_form_carousel #' + this.actualCarouselItem + ' .af2_carousel_content').height();
        $(this.formSelector+' .af2_form_carousel').css('height',height);
    }

    /**
     * Get all Needed preloads
     *
     * @returns {*}
     */
    this.iteratePreloads = () => {
        const prom = this.$.Deferred();
        let dataIds = [];

        /** Check neededContent first **/
        if (datas[this.neededContent] === undefined)
        {
            dataIds.push(this.neededContent);
            datas[this.neededContent] = true;
        }

        if (datas[this.id].sections[this.actualSection].contents[this.actualContent].connections !== undefined)
        {
            /** Iterate the first part **/
            $(datas[this.id].sections[this.actualSection].contents[this.actualContent].connections).each((i, el) => {
                const toSection = el.to_section;
                const toContent = el.to_content;

                /** Check the Data **/
                if (datas[el.to_dataid] === undefined && !el.to_dataid.includes('redirect'))
                {
                    dataIds.push(el.to_dataid);
                    datas[el.to_dataid] = true;

                    if (datas[this.id].sections[toSection].contents[toContent].connections !== undefined)
                    {
                        $.each(datas[this.id].sections[toSection].contents[toContent].connections, (j, e) => {

                            /** Check the Data **/
                            if (datas[e.to_dataid] === undefined && !e.to_dataid.includes('redirect')) {
                                dataIds.push(e.to_dataid);
                                datas[e.to_dataid] = true;
                            }
                        });
                    }
                }


                if (i === datas[this.id].sections[this.actualSection].contents[this.actualContent].connections.length - 1)
                {
                    prom.resolve(dataIds);
                }
            });

            if(datas[this.id].sections[this.actualSection].contents[this.actualContent].connections.length == 0) {
                prom.resolve(dataIds);
            }
        }

        return prom.promise();
    };

    /**
     * Setting all Triggers you need
     */
    this.setTriggers = () => {
        $(document).on('keypress', (ev) => {
            const keycode = (ev.keyCode ? ev.keyCode : ev.which);
            if (keycode == '13') {

                if (!$(this.formSelector + ' .af2_form_foward_button').hasClass('af2_disabled'))
                {
                    if (datas[this.actualData].typ === 'af2_multiselect')
                    {
                        let arr = [];
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer.selected_item').each((i, el) => {
                            arr.push($(el).attr('id'));
                        }).promise().done(() => {
                            this.af2Move(arr, 'next');
                        });
                    } else if (datas[this.actualData].typ === 'af2_textfeld') 
                    {
                        if (af2_isMobile()) {
                            this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage.af2_mobile').val(), 'next');
                        } else {
                            this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage').val(), 'next');
                        }
                    } else if (datas[this.actualData].typ === 'af2_datum')
                    {
                        if (af2_isMobile()) {
                            this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage.af2_mobile').val(), 'next');
                        } else {
                            this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage').val(), 'next');
                        }
                    } else if (datas[this.actualData].typ === 'af2_dateiupload') {
                        let fileupload_class = '.af2_dateiupload';
                        if (af2_isMobile()) {
                            fileupload_class = '.af2_dateiupload.af2_mobile';
                        } else {
                            fileupload_class = '.af2_dateiupload.desktop';
                        }

                        let arr = [];
                        if($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').length > 0){
                            $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').each((i, el) => {
                                arr.push($(el).data('attachment_id'));
                            }).promise().done(() => {
                                this.attachment_ids = this.attachment_ids.concat(arr);
                                this.af2Move(arr, 'next');
                            });
                        }else{
                            this.af2Move(0, 'next');
                        }
                    } else if (datas[this.actualData].typ === 'af2_adressfeld') {
                        this.af2Move(this.lastAdressObj, 'next');
                    }
                }
                else if (!$(this.formSelector + ' .af2_form_foward_button.desktop').hasClass('af2_disabled'))
                {
                    if (datas[this.actualData].typ === 'af2_adressfeld') {
                        this.af2Move(this.lastAdressObj, 'next');
                    }
                }
            }
        });

        this.$(document).on('mouseenter', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer', (ev) => {
            $(ev.currentTarget).addClass('hover');
        });
        this.$(document).on('mouseleave', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer', (ev) => {
            $(ev.currentTarget).removeClass('hover');
        });


        this.$(document).on('click', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer', (ev) => {
            if (datas[this.actualData].typ === 'af2_multiselect')
            {
                $(ev.currentTarget).toggleClass('selected_item');
                $(ev.currentTarget).removeClass('hover');

                const len = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer.selected_item').length;
                if (len > 0)
                {
                    $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');

                    const cond = datas[this.actualData].type_specifics.condition;
                    if (cond !== undefined && cond !== '' && $.isNumeric(cond) && cond > 1)
                    {
                        if (len >= cond)
                        {
                            let arr = [];
                            $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer.selected_item').each((i, el) => {
                                arr.push($(el).attr('id'));
                            }).promise().done(() => {
                                this.af2Move(arr, 'next');
                            });
                        }
                    }
                } else
                {
                    $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                }
            } else
            {
                const id = parseInt($(ev.currentTarget).attr('id'));
                this.af2Move(id, 'next');
            }
        });

        this.$(document).on('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage', (ev) => {  // MINLENGTH 1

            const text = $(ev.currentTarget).val();


            let text_only_text = $(ev.currentTarget).data("text_only_text");
            let text_only_numbers = $(ev.currentTarget).data("text_only_numbers");
            let text_birthday = $(ev.currentTarget).data("text_birthday");
            //let text_plz = $(ev.currentTarget).data("text_plz");
            let last_input_length = $(ev.currentTarget).data("lastInputLength") != undefined ? $(ev.currentTarget).data("lastInputLength") : 0;
            let actual_input_length = text.length;

            if(text_only_text) {
				const newText = text.replace(/[0-9]/g,'');
                 $(ev.currentTarget).val(newText);
            }
            if(text_only_numbers && !text_only_text) {
                const newText = text.replace(/[^0-9]/g,'');;
                 $(ev.currentTarget).val(newText);
            }
            if(text_birthday && !text_only_text && !text_only_numbers) {
                const lastLetter = text.substr(text.length - 1, 1);

                let key = ev.which || ev.keyCode || ev.charCode;

                if(actual_input_length > last_input_length) {
                    if(isNaN(lastLetter)) {
                        $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    }
                    else {
                        if(text.length == 2) $(ev.currentTarget).val(text + '.');
                        if(text.length == 5) $(ev.currentTarget).val(text + '.');
                    }
                }
                else {
                    if(text.length == 2) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    if(text.length == 5) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }

                /**if(isNaN(lastLetter)) {
                    if(key != 8) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    else if(text >= '') $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }
                else {
                    if(text.length == 2) $(ev.currentTarget).val(text + '.');
                    if(text.length == 5) $(ev.currentTarget).val(text + '.');
                }*/
            }



            let minlength = $(ev.currentTarget).data("minlength");
            let maxlength = $(ev.currentTarget).data("maxlength");

            /*if(text_plz && !text_birthday && !text_only_text && !text_only_numbers) {

            }*/

            if(minlength == null || minlength == undefined) minlength = 0;
            if(maxlength == null || maxlength == undefined) maxlength = 999999;

            if(text.length < minlength || text.length > maxlength) {
                if(text.length > maxlength) {
                    const lastLetter = text.substr(text.length - 1, 1);
                    //if(isNaN(lastLetter)) {
                        $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    //}
                }
                else $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
            }
            if(text.length >= minlength && text.length <= maxlength) {
                $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            }

            /*if ($(ev.currentTarget).val().trim() !== '' &&) {
                $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            } */
            if($(ev.currentTarget).val().trim() == '') {
                if ($(ev.currentTarget).data("mandatory") === true) {
                    $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                } else {
                    $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                }

            }

            if(text_birthday && !text_only_text && !text_only_numbers) {
                if(text.length == 10) {
                    let dateText = '';

                    dateTextSplit = text.split('.');

                    //dateText = dateTextSplit[1] + '.' + dateTextSplit[0] + '.' + dateTextSplit[2];

                    const year = dateTextSplit[2];
                    const month = dateTextSplit[1];
                    const day = dateTextSplit[0];

                    if(!(new Date(year, month, day) !== "Invalid Date" && !isNaN(new Date(year, month, day)))) $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                }
            }


            $(ev.currentTarget).data("lastInputLength", $(ev.currentTarget).val().length);
        });
        this.$(document).on('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage', (ev) => { // MINLENGTH 1

            const text = $(ev.currentTarget).val();

            let text_only_text = $(ev.currentTarget).data("text_only_text");
            let text_only_numbers = $(ev.currentTarget).data("text_only_numbers");
            let text_birthday = $(ev.currentTarget).data("text_birthday");
            let last_input_length = $(ev.currentTarget).data("lastInputLength") != undefined ? $(ev.currentTarget).data("lastInputLength") : 0;
            let actual_input_length = text.length;

            if(text_only_text) {
                const lastLetter = text.substr(text.length - 1, 1);
                if(!isNaN(lastLetter)) {
                    $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }
            }
            if(text_only_numbers && !text_only_text) {
                const lastLetter = text.substr(text.length - 1, 1);
                if(isNaN(lastLetter)) {
                    $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }
            }
            if(text_birthday && !text_only_text && !text_only_numbers) {
                const lastLetter = text.substr(text.length - 1, 1);

                let key = ev.which || ev.keyCode || ev.charCode;

                if(actual_input_length > last_input_length) {
                    if(isNaN(lastLetter)) {
                        $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    }
                    else {
                        if(text.length == 2) $(ev.currentTarget).val(text + '.');
                        if(text.length == 5) $(ev.currentTarget).val(text + '.');
                    }
                }
                else {
                    if(text.length == 2) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    if(text.length == 5) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }

                /**if(isNaN(lastLetter)) {
                    if(key != 8) $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    else if(text >= '') $(ev.currentTarget).val(text.substr(0, text.length - 1));
                }
                else {
                    if(text.length == 2) $(ev.currentTarget).val(text + '.');
                    if(text.length == 5) $(ev.currentTarget).val(text + '.');
                }*/
            }

            let minlength = $(ev.currentTarget).data("minlength");
            let maxlength = $(ev.currentTarget).data("maxlength");

            if(minlength == null || minlength == undefined) minlength = 0;
            if(maxlength == null || maxlength == undefined) maxlength = 999999;

            if(text.length < minlength || text.length > maxlength) {
                if(text.length > maxlength) {
                    const lastLetter = text.substr(text.length - 1, 1);
                    //if(isNaN(lastLetter)) {
                        $(ev.currentTarget).val(text.substr(0, text.length - 1));
                    //}
                }
                else $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
            }
            if(text.length >= minlength && text.length <= maxlength) {
                $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            }

            /*if ($(ev.currentTarget).val().trim() !== '' &&) {
                $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            } */
            if($(ev.currentTarget).val().trim() == '') {
                if ($(ev.currentTarget).data("mandatory") === true) {
                    $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                } else {
                    $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                }
            }

            if(text_birthday && !text_only_text && !text_only_numbers) {
                if(text.length == 10) {
                    let dateText = '';

                    dateTextSplit = text.split('.');

                    //dateText = dateTextSplit[1] + '.' + dateTextSplit[0] + '.' + dateTextSplit[2];

                    const year = dateTextSplit[2];
                    const month = dateTextSplit[1];
                    const day = dateTextSplit[0];

                    if(!(new Date(year, month, day) !== "Invalid Date" && !isNaN(new Date(year, month, day)))) $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                }
            }


            $(ev.currentTarget).data("lastInputLength", $(ev.currentTarget).val().length);
        });

        this.$(document).on('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage', (ev) => {

            if ($(ev.currentTarget).val().trim() !== '') {
                $(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            } else {
                $(this.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
            }

        });

        this.$(document).on('click', this.formSelector + ' .af2_form_back_button', (ev) => {
            if (!$(ev.currentTarget).hasClass('af2_disabled'))
            {
                this.set = false;

                const bSection = this.beforeSection[this.beforeSection.length-1];
                const bContent = this.beforeContent[this.beforeContent.length-1];
                const bId = datas[this.id].sections[bSection].contents[bContent].data;

                //const bRemove = function() {
                    $(this.formSelector + ' .af2_form_button').each((i, el) => {
                        $(el).addClass('af2_disabled');
                    });
                //}

                let removeNoHtml = true;

                if(datas[bId].af2_type == 'frage') {
                    /*if(datas[bId].typ === 'af2_select') bRemove();
                    if(datas[bId].typ === 'af2_multiselect') bRemove();
                    if(datas[bId].typ === 'af2_textfeld') ;//bRemove();
                    if(datas[bId].typ === 'af2_textbereich') ;//bRemove();
                    if(datas[bId].typ === 'af2_content') ;//bRemove();
                    if(datas[bId].typ === 'af2_datum'); //bRemove();
                    if(datas[bId].typ === 'af2_dateiupload'); //bRemove();
                    if(datas[bId].typ === 'af2_dropdown'); //bRemove();
                    if(datas[bId].typ === 'af2_slider'); //bRemove();
                    if(datas[bId].typ === 'af2_adressfeld'); //bRemove();*/
                    if(datas[bId].typ === 'af2_adressfeld') {
                        this.setLastAddrObject(this.answers[this.answers.length - 1]);
                    }
                    if(datas[bId].typ === 'af2_content') {
                        removeNoHtml = false;
                    }
                }


                this.af2Move(-1, 'before', removeNoHtml);
            }
        });

        this.$(document).on('click', this.formSelector + ' .af2_form_foward_button', (ev) => {

            if (!$(ev.currentTarget).hasClass('af2_disabled'))
            {

                if (datas[this.actualData].typ === 'af2_multiselect')
                {
                    let arr = [];
                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer.selected_item').each((i, el) => {
                        arr.push($(el).attr('id'));
                    }).promise().done(() => {
                        this.af2Move(arr, 'next');
                    });
                } else if (datas[this.actualData].typ === 'af2_textfeld') {
                    if (af2_isMobile()) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage').val(), 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_textbereich') {
                    if (af2_isMobile()) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage').val(), 'next');
                    }
                } else if (datas[this.actualData].typ === 'af2_datum') {
                    if (af2_isMobile()) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage').val(), 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_slider') {
                    this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage').val(), 'next');
                } else if (datas[this.actualData].typ === 'af2_content') {
                    this.af2Move("", 'next');
                } else if(datas[this.actualData].typ === 'af2_dateiupload') {
                    let fileupload_class = '.af2_dateiupload';
                    if (af2_isMobile()) {
                        fileupload_class = '.af2_dateiupload.af2_mobile';
                    } else {
                        fileupload_class = '.af2_dateiupload.desktop';
                    }

                    if($(this.formSelector).hasClass('af2_form-type-2')) {
                        fileupload_class = '.af2_dateiupload.desktop';
                    }

                    let arr = [];
                    if($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').length > 0){
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').each((i, el) => {
                            arr.push($(el).data('attachment_id'));
                        }).promise().done(() => {
                            this.attachment_ids = this.attachment_ids.concat(arr);
                            this.af2Move(arr, 'next');
                        });
                    }else{
                        this.af2Move(0, 'next');
                    }
                }else if(datas[this.actualData].typ === 'af2_dropdown') {
                    //TODO
                    const label = $(this.formSelector + ' #'+this.actualCarouselItem+'.af2_carousel_item .af2_dropdown_fragen').next().find('.select2-selection__rendered').html();
                    const value = $(this.formSelector + ' #'+this.actualCarouselItem+'.af2_carousel_item .af2_dropdown_fragen').val()
                    this.af2Move(value, 'next', label);
                } else if(datas[this.actualData].typ === 'af2_adressfeld') {
                    this.af2Move(this.lastAdressObj, 'next');
                }else if(datas[this.actualData].typ === 'af2_terminbuchung') {
                    this.af2Move(this.lastTerminbuchungsObject, 'next');
                }
            }
        });
        this.$(document).on('click', this.formSelector + ' .af2_submit_button.no_send', (ev) => {
            if (!$(ev.currentTarget).hasClass('af2_disabled'))
            {
                if (datas[this.actualData].typ === 'af2_multiselect')
                {
                    let arr = [];
                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer.selected_item').each((i, el) => {
                        arr.push($(el).attr('id'));
                    }).promise().done(() => {
                        this.af2Move(arr, 'next');
                    });
                } else if (datas[this.actualData].typ === 'af2_textfeld') {
                    if (af2_isMobile()) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage').val(), 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_textbereich') {
                    if (af2_isMobile() && !($(this.formSelector).hasClass('af2_form-type-2'))) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage').val(), 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_datum') {
                    if (af2_isMobile()) {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage.af2_mobile').val(), 'next');
                    } else {
                        this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage').val(), 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_slider') {
                    this.af2Move($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage').val(), 'next');
                } else if (datas[this.actualData].typ === 'af2_content') {
                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item video').each((i, el) => {
                        $(el).stop();
                    });
                    this.af2Move("", 'next');
                } else if (datas[this.actualData].typ === 'af2_dateiupload') {
                    let fileupload_class = '.af2_dateiupload';
                    if (af2_isMobile()) {
                        fileupload_class = '.af2_dateiupload.af2_mobile';
                    } else {
                        fileupload_class = '.af2_dateiupload.desktop';
                    }

                    if($(this.formSelector).hasClass('af2_form-type-2')) {
                        fileupload_class = '.af2_dateiupload.desktop';
                    }

                    let arr = [];
                    if($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').length > 0){
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item '+fileupload_class+' div[data-attachment_id]').each((i, el) => {
                            arr.push($(el).data('attachment_id'));
                        }).promise().done(() => {
                            this.attachment_ids = this.attachment_ids.concat(arr);
                            this.af2Move(arr, 'next');
                        });
                    }else{
                        this.af2Move(0, 'next');
                    }

                } else if (datas[this.actualData].typ === 'af2_dropdown') {
                    //TODO
                    const label = $(this.formSelector + ' #'+this.actualCarouselItem+'.af2_carousel_item .af2_dropdown_fragen').next().find('.select2-selection__rendered').html();
                    const value = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_dropdown_fragen').val();
                    this.af2Move(value, 'next', label);
                }
            }
        });


        this.$(document).on('click', this.formSelector + ' .af2_submit_button', (ev) => {
            if (this.af2_is_send_allowed)
            {

                if ($(ev.currentTarget).hasClass('no_send'))
                {

                }
                else if($(ev.currentTarget).hasClass('newVerification'))
                {
                    if(!$(ev.currentTarget).hasClass('waiting')) {
                        this.af2_is_send_allowed = false;
                        $(this.formSelector + ' .af2_response_success').each((i, el) => {
                            $(el).remove();
                        });
                        $(this.formSelector + ' .af2_response_error').each((i, el) => {
                            $(el).remove();
                        });
                        $(this.formSelector + ' .af2_loading_error').each((i, el) => {
                            $(el).remove();
                        });

                        this.sendNewVerification();
                    }

                }
                else
                {
                    this.af2_is_send_allowed = false;
                    $(this.formSelector + ' .af2_response_success').each((i, el) => {
                        $(el).remove();
                    });
                    $(this.formSelector + ' .af2_response_error').each((i, el) => {
                        $(el).remove();
                    });
                    $(this.formSelector + ' .af2_loading_error').each((i, el) => {
                        $(el).remove();
                    });

                    let arr = [];
                    let arr2 = [];
                    let doneRadios = {};

                    if($(ev.currentTarget).hasClass('real_send')) {
                        this.send_mail($(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_text_type_validate').val(),
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_text_type_validate').data('number'));
                    }
                    else {
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_question input').each((i, el) => {
                            if($(el).hasClass('filter_country')) return;

                            if ($(el).attr('type') === 'checkbox')
                            {
                                arr.push($(el).prop('checked'));
                                arr2.push({ value: $(el).prop('checked'), id: $(el).attr('data-uid') });
                            } else if($(el).attr('type') === 'radio')
                            {
                                /**console.log($(el).attr('name'));
                                console.log($(el).val());
                                console.log($(el).is(':checked'));
                                **/
                                const val = $("input[name="+$(el).attr('name')+"]:checked").val();
                                const name = $(el).attr('name');

                                let value = val === undefined ? 'keine Angabe' : val;

                                if(doneRadios[name] === undefined) {
                                    doneRadios[name] = true;
                                    arr.push(value);
                                    arr2.push({ value: value, id: $(el).attr('data-uid') });
                                }
                            } else
                            {
                                arr.push($(el).val());
                                arr2.push({ value: $(el).val(), id: $(el).attr('id') });
                            }
                        }).promise().done(() => {
                            if (this.set === true)
                            {
                                this.answers.pop();
                            }
                            this.answers.push(arr);
                            this.contactFormAnswers = arr2;

                            this.set = true;

                            // CHECK NOW IF VERIFYING SMS
                            if(this.hasVerification) {
                                $(document).on('click', '.af2_change_verify_number', (ev) => {
                                    $(document).off('click', '.af2_change_verify_number');

                                    this.actualCarouselItem--;

                                    $(document).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item', () => {
                                        $(document).off('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item');
                                        $(this.formSelector + ' #' + (this.actualCarouselItem + 1) + '.af2_carousel_item').remove();
                                    });

                                    $(this.formSelector + ' #' + (this.actualCarouselItem)).css('transform');
                                    // $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').removeClass('left_marg');

                                    direction = '-';
                                    if(this.rtl_layout == true) {
                                        direction = '';
                                    }
                                    let offset = 'translateX('+direction+''+((this.actualCarouselItem + 1)*100)+'%)';
                                    $(this.formSelector + ' .af2_carousel_item').css('transform', offset);

                                    this.setHeight();

                                });
                                this.sendVerification();
                            }
                            else {
                                this.send_mail();
                            }
                        });
                    }
                }
            }


        });

        this.sendNewVerification = () => {
            let af2_queryString = window.location.search.substr(1);
            let af2_url = window.location.href;

            $.ajax({
                url: af2_frontend_ajax.ajax_url,
                type: "POST",
                data: {
                    _ajax_nonce: af2_frontend_ajax.nonce,
                    action: 'af2_test_verification',
                    sec: this.actualSection,
                    cont: this.actualContent,
                    dataid: this.id,
                    answers: this.answers,
                    attachment_ids: this.attachment_ids,
                    af2_queryString: af2_queryString,
                    af2_url: af2_url,
                    verifictationDataId: this.verifictationDataId
                },
                success: (answer) => {
                    //console.log(answer);
                    //console.log(answer);
                    // Version - just to test extern
                    if (answer === 'ERROR' || answer === undefined)
                    {
                        this.af2_is_send_allowed = true;
                        af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);

                        this.setHeight();
                    } else
                    {
                        // kein fehler
                        if(answer != 'empty')
                        {
                            // JSON ANSWER
                            if(answer.substr(0, 1) === '{')
                            {
                                let serverAnswer = JSON.parse(answer);
                                if(serverAnswer.err !== undefined) { // FEHLER beim senden
                                    this.af2_is_send_allowed = true;
                                    af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured+' :'+serverAnswer.err);
                                    this.setHeight();
                                }else {
                                    this.af2_is_send_allowed = true;
                                    this.resendValue = 60;
                                    $(this.formSelector + ' #af_verif').html(this.resendValue);
                                    $(this.formSelector + ' #af_verif').addClass('waiting');
                                    this.resendTimer = setInterval(() => {
                                        this.resendValue--;
                                        $(this.formSelector + ' #af_verif').html(this.resendValue);

                                        if(this.resendValue == 0) {
                                            this.resendValue = false;
                                            $(this.formSelector + ' #af_verif').removeClass('waiting');
                                            $(this.formSelector + ' #af_verif').html(af2_frontend_ajax.strings.resend);
                                            clearInterval(this.resendTimer);
                                        }
                                    }, 1000);
                                }
                            }
                            // ERROR
                            else {
                                const code = $($.parseHTML(answer));
                                let error = code.filter('.af2_response_error')[0];

                                if (error !== undefined)
                                {
                                    this.af2_is_send_allowed = true;
                                    error = $(error);
                                    const sel = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_question .af2_question_wrapper')[error.data('id')];

                                    af2ThrowLoadingError(this.$, sel, error[0]);
                                    this.setHeight();
                                }
                            }
                        }
                        // Fehler
                        else
                        {
                            this.af2_is_send_allowed = true;
                            af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                            this.setHeight();
                        }
                    }
                },
                error: () => {
                    this.af2_is_send_allowed = true;
                    af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                    this.setHeight();
                }
            });
        }

        this.sendVerification = () => {
            let af2_queryString = window.location.search.substr(1);
            let af2_url = window.location.href;

            let submits = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button');
            $(submits).each((i, el) => {
                if($(el).hasClass('newVerification')){}
                else $(el).addClass('af2_submit_button--loading');
            });

            $.ajax({
                url: af2_frontend_ajax.ajax_url,
                type: "POST",
                data: {
                    _ajax_nonce: af2_frontend_ajax.nonce,
                    action: 'af2_test_verification',
                    sec: this.actualSection,
                    cont: this.actualContent,
                    dataid: this.id,
                    answers: this.answers,
                    attachment_ids: this.attachment_ids,
                    af2_queryString: af2_queryString,
                    af2_url: af2_url,
                    verifictationDataId: this.verifictationDataId
                },
                success: (answer) => {
                    //console.log(answer);
                    //console.log(answer);
                    // Version - just to test extern
                    if (answer === 'ERROR' || answer === undefined)
                    {
                        this.af2_is_send_allowed = true;
                        af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                        this.setHeight();
                    } else
                    {
                        // kein fehler
                        if(answer != 'empty')
                        {
                            // JSON ANSWER
                            if(answer.substr(0, 1) === '{')
                            {
                                let serverAnswer = JSON.parse(answer);
                                if(serverAnswer.err !== undefined) { // FEHLER beim senden
                                    this.send_mail(serverAnswer.code, serverAnswer.number);
                                    /*this.af2_is_send_allowed = true;
                                    af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), 'Es ist ein Fehler aufgetreten: '+serverAnswer.err);
                                    const height = $(this.formSelector + ' .af2_form_carousel #' + this.actualCarouselItem + ' .af2_carousel_content').height();
                                    $(this.formSelector + ' .af2_form_carousel').css('height');
                                    $(this.formSelector + ' .af2_form_carousel').css('height', height);*/
                                }else {
                                    /** Move to the next **/

                                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');

                                    let number = serverAnswer.number;

                                    this.af2_is_send_allowed = true;

                                    this.actualCarouselItem++;
                                    let newCont = this.af2_drawValidation(number);

                                    $(document).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem-1) + '.af2_carousel_item', () => {
                                        $(document).off('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem-1) + '.af2_carousel_item');
                                        $(this.formSelector + ' #' + (this.actualCarouselItem + 1) + '.af2_carousel_item').remove();
                                        $(this.formSelector + ' .af2_text_type.af2_text_type_validate').focus();
                                    });

                                    $(this.formSelector + ' .af2_form_carousel').append(newCont);

                                    if(this.resendValue != false) {
                                        $(this.formSelector + ' #af_verif').html(this.resendValue);
                                        $(this.formSelector + ' #af_verif').addClass('waiting');
                                        this.resendTimer = setInterval(() => {
                                            this.resendValue--;
                                            $(this.formSelector + ' #af_verif').html(this.resendValue);

                                            if(this.resendValue == 0) {
                                                this.resendValue = false;
                                                $(this.formSelector + ' #af_verif').removeClass('waiting');
                                                $(this.formSelector + ' #af_verif').html(af2_frontend_ajax.strings.resend);
                                                clearInterval(this.resendTimer);
                                            }
                                        }, 1000);
                                    }

                                    $(this.formSelector + ' #' + (this.actualCarouselItem - 1)).css('transform');
                                    // $(this.formSelector + ' #' + (this.actualCarouselItem - 1) + '.af2_carousel_item').addClass('left_marg');
                                    direction = '-';
                                    if(this.rtl_layout == true) {
                                        direction = '';
                                    }
                                    let offset = 'translateX('+direction+''+((this.actualCarouselItem + 1)*100)+'%)';
                                    $(this.formSelector + ' .af2_carousel_item').css('transform', offset);

                                    $(this.formSelector + ' .af2_form_bottombar').remove();

                                    this.setHeight();
                                }
                            }
                            // ERROR
                            else {
                                const code = $($.parseHTML(answer));
                                let error = code.filter('.af2_response_error')[0];

                                if (error !== undefined)
                                {
                                    this.af2_is_send_allowed = true;
                                    error = $(error);
                                    const sel = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_question .af2_question_wrapper')[error.data('id')];

                                    af2ThrowLoadingError(this.$, sel, error[0]);
                                    this.setHeight();
                                }
                            }
                        }
                        // Fehler
                        else
                        {
                            this.af2_is_send_allowed = true;
                            af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                            this.setHeight();
                        }
                    }

                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');

                },
                error: () => {
                    this.af2_is_send_allowed = true;
                    af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                    this.setHeight();


                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                }
            });
        }

        this.af2_drawValidation = (number) => {
            let af2_val_heading = af2_frontend_ajax.strings.sms;
            let af2_val_description = af2_frontend_ajax.strings.sms_sent+' '+number+'.';
            af2_val_description += '<br><span class="af2_change_verify_number af2_ahref">'+af2_frontend_ajax.strings.sms_change+'</span>'

            let cont = '';

            cont += '<div id="'+(this.actualCarouselItem)+'" class="af2_carousel_item">';
            cont += '<div class="af2_carousel_content">';

            cont += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + af2_val_heading + '</div><div class="af2_question_description desktop">' + af2_val_description + '</div></div>';
            cont += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + af2_val_heading + '</div><div class="af2_question_description af2_mobile">' + af2_val_description + '</div></div>';

            cont += '<div class="af2_question af2_verify">';
            cont += '<div class="af2_question_text_type_wrapper af2_question_wrapper af2_verification">';
            cont += '<div class="af2_question_cf_text_type_wrapper af2_verification" style="">';
            cont += '<div class="af2_question_cf_text_type_icon">';
            cont += '<i class="fas fa-mobile-alt"></i>';
            cont += '</div>';
            cont += '<input maxlength="6" type="tel" value="" data-number="'+number+'" name="validate" id="validate" autocomplete="one-time-code" class="af2_text_type af2_text_type_validate" placeholder="123456">';
            cont += '</div>';
            cont += '<button id="af_verif" class="af2_submit_button newVerification af_marg">'+af2_frontend_ajax.strings.sms_repeat+'</button>'
            cont += '</div>';
            cont += '</div>';

            cont += '<div class="af2_question_wrapper">';
            cont += '<div class="af2_submit_wrapper">';
            cont += '<button type="button" class="af2_submit_button real_send">';
            cont += '<span class="af2_submit_button__text">'+af2_frontend_ajax.strings.sms_verify+'</span>';
            cont += '</button>'
            cont += '</div>';
            cont += '</div>';

            cont += '</div>';
            cont += '</div>';


            return cont;
        }

        this.send_mail = (value, number) => {
            let af2_queryString = window.location.search.substr(1);
            let af2_url = window.location.href;

            let verVal = '';
            let verNum = '';

            if(value) verVal = value;
            if(number) verNum = number;

            let submits = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button');
            $(submits).each((i, el) => {
                if($(el).hasClass('newVerification')){}
                else $(el).addClass('af2_submit_button--loading');
            });
            $.ajax({
                url: af2_frontend_ajax.ajax_url,
                type: "POST",
                data: {
                    _ajax_nonce: af2_frontend_ajax.nonce,
                    action: 'af2_send_mail',
                    sec: this.actualSection,
                    cont: this.actualContent,
                    dataid: this.id,
                    answers: this.answers,
                    attachment_ids: this.attachment_ids,
                    af2_queryString: af2_queryString,
                    af2_url: af2_url,
                    verificationSMS: [verVal, verNum],
                    terminbuchungsobjekt: this.lastTerminbuchungsObject,
                    contactFormAnswers: this.contactFormAnswers,
                    dsgvoid: this.dsgvoid,
                },
                success: (answer) => {
                    //console.log(answer);
                    // Version - just to test extern
                    if (answer === 'ERROR' || answer === undefined)
                    {
                        this.af2_is_send_allowed = true;
                        af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                        this.setHeight();


                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                    }
                    else if(answer === 'NOT VALIDATED') {
                        this.af2_is_send_allowed = true;
                        const sel = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_question .af2_question_wrapper')[0];
                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_verify').append('<div style="text-align: center;" class="af2_response_error">Der Code ist entweder falsch, oder abgelaufen.</div>');

                        this.setHeight();


                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                    }
                    else
                    {
                        const code = $($.parseHTML(answer));
                        let error = code.filter('.af2_response_error')[0];

                        if (error !== undefined)
                        {
                            this.af2_is_send_allowed = true;
                            error = $(error);
                            const sel = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_question .af2_question_wrapper')[error.data('id')];

                            af2ThrowLoadingError(this.$, sel, error[0]);
                            this.setHeight();


                            $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                        } else
                        {
                            const success = $(code.filter('.af2_response_success')[0]);

                            /**af2ThrowLoadingSuccess(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_wrapper'), success[0]);
                            const height = $(this.formSelector + ' .af2_form_carousel #' + this.actualCarouselItem + ' .af2_carousel_content').height();
                            $(this.formSelector + ' .af2_form_carousel').css('height');
                            $(this.formSelector + ' .af2_form_carousel').css('height', height); **/


                            //TODO
                            if(this.showSuccessScreen != false && this.showSuccessScreen != null && this.showSuccessScreen != undefined) {
                                $(this.formSelector + ' .af2_form .af2_form_heading_wrapper').remove();
                                $(this.formSelector + ' .af2_form .af2_form_carousel').remove();
                                $(this.formSelector + ' .af2_form .af2_form_bottombar').remove();
                                $(this.formSelector + ' .af2_form .af2_success_message_screen').addClass('show');
                            }

                            const tracking_after = atob(success.data('tracking-after')).replaceAll('<script>','').replaceAll('</script>');
                            eval(tracking_after);

                            const theFormElement = this;

                            setTimeout(function() {

                            $(theFormElement.formSelector + ' #' + theFormElement.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                            $(theFormElement.formSelector + ' #' + theFormElement.actualCarouselItem + '.af2_carousel_item .af2_submit_button span').html(af2_frontend_ajax.strings.form_sent);
                            if (success.data('redirect') !== "" && success.data('redirect') !== false)
                                {
                                    if(typeof af2_doOwnExternalRedirectFunction === 'function')
                                    {
                                        af2_doOwnExternalRedirectFunction(theFormElement.answerObject, success.data('bl'));
                                    }
                                    else {
                                        let blank = success.data('bl');
                                        if(blank == true)
                                            window.open(success.data('redirect').substr(9), '_blank');
                                        else
                                            window.location.href = success.data('redirect').substr(9);
                                    }
                                }
                            }, 2000);
                        }
                    }

                },
                error: () => {
                    this.af2_is_send_allowed = true;
                    af2ThrowError(this.$, $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button'), af2_frontend_ajax.strings.erroroccured);
                    this.setHeight();
                    $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_submit_button.af2_submit_button--loading').removeClass('af2_submit_button--loading');
                }
            });
        }

        this.$(document).on('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage', (ev) => {
            const sliderSelector = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage');
            const sliderBulletSelector = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage_bullet');
            af2AdjustSliderBullet(sliderSelector, sliderBulletSelector, datas[this.actualData], this.$);

            if(datas[this.actualData].type_specifics.manual == true){
                $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage_val').val(sliderSelector.val());
                $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
            }
        });

        this.$(document).on('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage_val', (ev) => {

            const sliderSelector = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage');
            const sliderBulletSelector = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage_bullet');
            const sliderMin = parseInt(datas[this.actualData].type_specifics.min);
            const sliderMax = parseInt(datas[this.actualData].type_specifics.max);
            const sliderVal = parseInt($(ev.currentTarget).val());
            if(sliderVal >= sliderMin && sliderVal <= sliderMax){
                $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                sliderSelector.val(sliderVal);
                af2AdjustSliderBullet(sliderSelector, sliderBulletSelector, datas[this.actualData], this.$);
            }else{
                if(!isNaN(sliderVal)){
                    $(this.formSelector + ' .af2_form_foward_button').addClass("af2_disabled");
                }

            }

        });
    };

    /**
     * Removing all Triggers
     */
    this.removeTriggers = () => {
        $(document).off('keypress');

        this.$(document).off('mouseenter', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer');
        this.$(document).off('mouseleave', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer');

        this.$(document).off('click', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer');
        this.$(document).off('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage');
        this.$(document).off('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage');
        this.$(document).off('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_datum_frage');
        this.$(document).off('input', this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_slider_frage');


        this.$(document).off('click', this.formSelector + ' .af2_form_back_button');
        this.$(document).off('click', this.formSelector + ' .af2_form_foward_button');
        this.$(document).off('click', this.formSelector + ' .af2_submit_button.no_send');

        this.$(document).off('click', this.formSelector + ' .af2_submit_button');
    };

    this.af2_addAhrefs = () => {
        this.$(this.formSelector+' a').each((i, el) => {
            if($(el).hasClass('af2_ahref')) {}
            else if($(el).hasClass('ui-state-default')) {}
            else $(el).addClass('af2_ahref');
        });
    };

    /**
     * Moves the Carousel
     *
     * @param connectionFrom
     * @param type
     */
    this.af2Move = (connectionFrom, type, dropdownInput) => {
        /** Remove all Hooks**/
        this.removeTriggers();

        this.scroll_to_anchor(this.formSelector, this.$);

        if (type === 'next')
        {
            $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_answer').each((i, el) => {
                $(el).removeClass('selected_item');
                $(el).removeClass('hover');
            });

            this.answers.push(connectionFrom);

            // CATH BY TYPE

            let answerObjectAnswer = connectionFrom;

            let doAnswerObject = true;

            switch(datas[this.actualData].typ) {
                case 'af2_select': {
                    answerObjectAnswer = datas[this.actualData].type_specifics.answers[connectionFrom].text;
                    break;
                }
                case 'af2_multiselect': {
                    answerObjectAnswer = '';
                    connectionFrom.forEach((el, i) => {
                        answerObjectAnswer += datas[this.actualData].type_specifics.answers[el].text;
                        if(i < connectionFrom.length - 1) answerObjectAnswer += ', ';
                    });
                    break;
                }
                case 'af2_textfeld': {
                    break;
                }
                case 'af2_textbereich': {
                    break;
                }
                case 'af2_datum': {
                    break;
                }
                case 'af2_dropdown': {
                    answerObjectAnswer = dropdownInput;
                    break;
                }
                case 'af2_slider': {
                    break;
                }
                case 'af2_adressfeld': {
                    break;
                }
                case 'af2_content': {
                    doAnswerObject = false;
                    break;
                }
                case 'af2_dateiupload': {
                    answerObjectAnswer = '';
                    let dateienNamen = 'Dateien';
                    let wurdenNamen = 'wurden';
                    let fromlength = connectionFrom.length;
                    if(connectionFrom.length == 1 ) dateienNamen = 'Datei';
                    if(connectionFrom.length == 1 ) wurdenNamen = 'wurde';
                    if(connectionFrom.length == undefined) fromlength = connectionFrom
                    answerObjectAnswer = 'Es '+wurdenNamen+' '+fromlength+' '+dateienNamen+' hochgeladen.';
                    break;
                }
            }

            if(doAnswerObject)
                this.answerObject.push({ id: this.actualData, title: datas[this.actualData].frontend_name, answer: answerObjectAnswer });


            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'af2NextSlide',
                'id': this.actualData,
                'title': datas[this.actualData].frontend_name,
                'answer': answerObjectAnswer
            });

            this.needsDraw = true;

            let param = connectionFrom;

            if(datas[this.actualData].typ === 'af2_dropdown') {
                let options = datas[this.actualData].type_specifics.dropdown_options;
                $.each(options,function(i,t){
                    if(t.label == dropdownInput){
                        param = i;
                    }
                });
                this.answers.pop();
                this.answers.push(param);
            }

            if(typeof af2_doOwnExternalRedirectFunctionBetween === 'function')
            {
                af2_doOwnExternalRedirectFunctionBetween().done((newval) => {
                    if(newval) {
                        this.af2GoNext(param).done((cont) => {
                            this.beforeSection.push(cont[0]);
                            this.beforeContent.push(cont[1]);

                            if (this.beforeSection.length > 0)
                            {
                                $(this.formSelector + ' .af2_form_back_button').removeClass('af2_disabled');
                            } else
                            {
                                $(this.formSelector + ' .af2_form_back_button').addClass('af2_disabled');
                            }
                        });
                    } else {
                        //
                    }
                });
            }
            else {
                this.af2GoNext(param).done((cont) => {
                    this.beforeSection.push(cont[0]);
                    this.beforeContent.push(cont[1]);

                    if (this.beforeSection.length > 0)
                    {
                        $(this.formSelector + ' .af2_form_back_button').removeClass('af2_disabled');
                    } else
                    {
                        $(this.formSelector + ' .af2_form_back_button').addClass('af2_disabled');
                    }
                });
            }
        } else if (type === 'before')
        {
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'af2PrevSlide',
            });

            // IF
            if(dropdownInput == true) {
                this.answers.pop();
                this.answerObject.pop();
            }

            this.needsDraw = false;
            this.af2GoBefore().done(() => {
                this.beforeSection.pop();
                this.beforeContent.pop();

                if (this.beforeSection.length > 0)
                {
                    $(this.formSelector + ' .af2_form_back_button').removeClass('af2_disabled');
                } else
                {
                    $(this.formSelector + ' .af2_form_back_button').addClass('af2_disabled');
                }
            });
        }
    };

    this.scroll_to_anchor = (anchor_id, $) => {
        if(this.activateScrollToAnchor) {
            if (af2_isMobile())
            {
                var tag = $(anchor_id + " .af2_form_heading.af2_mobile");
                $('html,body').animate({scrollTop: tag.offset().top});
            }
        }
    }




    /**
     * Going to the one before
     */
    this.af2GoBefore = () => {

        // if its a contact form then store value in local store
        if(datas[this.actualData].af2_type == 'kontaktformular'){
            var data = [];
            $(".af2_carousel_item#"+this.actualCarouselItem+" .af2_question").each(function(i,t){
                if($(t).find("input[type='text']").length > 0){
                    var id = $(t).attr("id");
                    data[id] = $(t).find("input[type='text']").val();
                }
            })
            this.stor.af2_form_values = JSON.stringify(data);
        }

        const prom = this.$.Deferred();

        this.actualSection = this.beforeSection[this.beforeSection.length - 1];
        this.actualContent = this.beforeContent[this.beforeContent.length - 1];

        this.actualCarouselItem--;

        /** Loading Content **/
        this.loadContent(true).done(() => {
            /** Move to the next **/

            $(document).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item', () => {
                $(document).off('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item');
                $(this.formSelector + ' #' + (this.actualCarouselItem + 1) + '.af2_carousel_item').remove();
                if (datas[this.actualData].typ === 'af2_textfeld' || datas[this.actualData].typ === 'af2_textbereich') {
                    if (datas[this.actualData].type_specifics.mandatory !== true) {
                        $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                    }
                }else if (datas[this.actualData].typ === 'af2_dateiupload') {

                    if (datas[this.actualData].type_specifics.mandatory === true) {
                        let uploaded_files = 0;
                        if (af2_isMobile()) {
                            uploaded_files = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_dateiupload.af2_mobile div[data-attachment_id]').length;
                        } else {
                             uploaded_files = $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_dateiupload.desktop div[data-attachment_id]').length;
                        }
                        if(uploaded_files > 0){
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        }
                    }else{
                        $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                    }
                }
                prom.resolve();
            });
            $(this.formSelector + ' #' + (this.actualCarouselItem)).css('transform');
            // $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').removeClass('left_marg');

            direction = '-';
            if(this.rtl_layout == true) {
                direction = '';
            }
            let offset = 'translateX('+direction+''+((this.actualCarouselItem)*100)+'%)';
            $(this.formSelector + ' .af2_carousel_item').css('transform', offset);

            const newPercent = (this.actualSection / (this.size - 1)) * 100;
            $(this.formSelector + ' .af2_form_progress').css('width');
            $(this.formSelector + ' .af2_form_progress').css('width', newPercent + '%');

            //this.af2SetPercentage(parseInt($(this.formSelector + ' .af2_form_percentage').html()), newPercent, 500, 'down');

        });

        return prom.promise();
    };

    /**
     * Going to the next one
     */
    this.af2GoNext = (connectionFrom) => {
        const prom = this.$.Deferred();

        /** Set new Content **/
        /**if(datas[this.actualData].typ === 'af2_dropdown'){
            let options = datas[this.actualData].type_specifics.dropdown_options;
            $.each(options,function(i,t){
                if(t.value == connectionFrom || t.label == connectionFrom){
                    connectionFrom = i;
                }
            });
        }**/

        const buffer = af2FindNew(this.$, datas[this.id].sections[this.actualSection].contents[this.actualContent].connections, connectionFrom);

        const sec = this.actualSection;
        const cont = this.actualContent;

        this.actualSection = buffer[0];
        this.actualContent = buffer[1];

        this.actualCarouselItem++;

        /** Loading Content **/
        this.loadContent().done(() => { // MINLENGTH 1
            $(document).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',
                    this.formSelector + ' #' + (this.actualCarouselItem - 1) + '.af2_carousel_item', (ev) => {

                if($(ev.target).hasClass('af2_carousel_item'))
                {
                    $(document).off('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd',
                        this.formSelector + ' #' + (this.actualCarouselItem - 1) + '.af2_carousel_item');

                    if (datas[this.actualData].typ === 'af2_textfeld')
                    {
                        let is_mandatory = datas[this.actualData].type_specifics.mandatory;
                        let min_length = datas[this.actualData].type_specifics.min_length;
                        if (is_mandatory !== true) {
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        }

                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textfeld_frage').each((i, el) => {
                            if ($(el).css('display') === 'none')
                            {

                            } else
                            {
                                $(el).focus();
                            }
                        });
                    }

                    if (datas[this.actualData].typ === 'af2_textbereich')
                    {
                        let is_mandatory = datas[this.actualData].type_specifics.mandatory;
                        if (is_mandatory !== true) {
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        }

                        $(this.formSelector + ' #' + this.actualCarouselItem + '.af2_carousel_item .af2_textbereich_frage').each((i, el) => {
                            if ($(el).css('display') === 'none')
                            {

                            } else
                            {
                                $(el).focus();
                            }
                        });
                    }

                    if (datas[this.actualData].typ === 'af2_dateiupload')
                    {
                        let is_mandatory = datas[this.actualData].type_specifics.mandatory;
                        if (is_mandatory !== true) {
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        }
                    }
                    if (datas[this.actualData].typ === 'af2_adressfeld')
                    {
                        let is_mandatory = datas[this.actualData].type_specifics.mapmandatory;
                        if (is_mandatory != undefined && is_mandatory == false) {
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        } else {
                            $(this.formSelector + ' .af2_form_foward_button').addClass("af2_disabled");
                        }
                    }
                    if (datas[this.actualData].typ === 'af2_datum')
                    {
                        let is_mandatory = datas[this.actualData].type_specifics.datemandatory;
                        if (is_mandatory != undefined && is_mandatory == false) {
                            $(this.formSelector + ' .af2_form_foward_button').removeClass("af2_disabled");
                        } else {
                            $(this.formSelector + ' .af2_form_foward_button').addClass("af2_disabled");
                        }
                    }
                    if (datas[this.actualData].typ === 'af2_terminbuchung')
                    {
                        $(this.formSelector + ' .af2_form_foward_button').addClass("af2_disabled");
                    }
                }
            });

            prom.resolve([sec, cont]);

            /** Move to the next **/
            // $(this.formSelector + ' #' + (this.actualCarouselItem - 1)).css('transform');
            // $(this.formSelector + ' #' + (this.actualCarouselItem - 1) + '.af2_carousel_item').addClass('left_marg');
            direction = '-';
            if(this.rtl_layout == true) {
                direction = '';
            }
            let offset = 'translateX('+direction+''+((this.actualCarouselItem)*100)+'%)';
            let offset2 = 'translateX('+direction+''+((this.actualCarouselItem-1)*100)+'%)';

            let saveTrans = $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').css('transition');
            $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').css('transition', '');
            $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').css('transform', offset2);
            setTimeout(()=> {
                $(this.formSelector + ' .af2_carousel_item').css('transform', offset);
            }, 300);
            $(this.formSelector + ' #' + (this.actualCarouselItem) + '.af2_carousel_item').css('transition', saveTrans);

            const newPercent = (this.actualSection / (this.size - 1)) * 100;
            $(this.formSelector + ' .af2_form_progress').css('width');
            $(this.formSelector + ' .af2_form_progress').css('width', newPercent + '%');


//            if(datas[this.actualData].typ === 'af2_textbereich')

            //this.af2SetPercentage(parseInt($(this.formSelector + ' .af2_form_percentage').html()), newPercent, 500, 'up');

            // if its a contact form then store value in local store
            if(datas[this.actualData].af2_type == 'kontaktformular'){
                if (this.stor.af2_form_values !== null && this.stor.af2_form_values !== undefined) {

                    let optionValues = JSON.parse(this.stor.af2_form_values);
                    $(".af2_carousel_item#"+this.actualCarouselItem+" .af2_question").each(function(i,t){
                        var id = $(t).attr("id");
                        if(typeof optionValues[id] !== undefined){
                            $(t).find("input[type='text']").val(optionValues[i]);
                        }
                    })
                }
            }

        });

        if(this.dsgvo == true) {
            $.ajax({
                url: af2_frontend_ajax.ajax_url,
                method: "POST",
                data: {
                    action: 'af2_send_actual_post',
                    _ajax_nonce: af2_frontend_ajax.nonce,
                    id: this.id,
                    content: this.answers,
                    dsgvoid: this.dsgvoid,
                },
                success: (response) => {
                    if(response == 'false') this.dsgvo = false;
                    else this.dsgvoid = response;
                },
                error:function() {

                }
            });
        }

        return prom.promise();
    };

    this.af2SetPercentage = (oldPercentage, newPercentage, interv, way) => {

        let difference = newPercentage - oldPercentage;
        let actPercentage = oldPercentage + 1;

        if (way === 'down')
        {
            difference = oldPercentage - newPercentage;
            actPercentage = oldPercentage - 1;
        }


        if (difference === 0)
        {
            return null;
        }

        let interval = interv / difference;

        setTimeout(() => {
            $(this.formSelector + ' .af2_form_percentage').html(actPercentage + '%');
            this.af2SetPercentage(actPercentage, newPercentage, interv - interval, way);
        }, interval);

    };



    this.af2_initAdress = () => {
        let map = GMap($, this.neededContent, this.actualData, this.formSelector, this.setHeight, this);
        /**
        //$(this.formSelector + ' .af2_form_carousel #' + this.actualCarouselItem + ' .af2_carousel_content').css('height', '500px');

        const fact = this.neededContent == undefined ? this.actualData : this.neededContent;

        const zoomlevel = datas[fact].type_specifics.zoomlevel == undefined ? 8 : parseInt(datas[fact].type_specifics.zoomlevel);
        const center = datas[fact].type_specifics.center == undefined ? { lat: -34.397, lng: 150.644 } : datas[fact].type_specifics.center;

        this.map = new extraParms.maps.Map(this.$(this.formSelector + ' #af2_adress_field')[0], {
            center: center,
            zoom: zoomlevel,
            mapTypeId: "roadmap",
            mapTypeControlOptions: { mapTypeIds: [] },
            disableDefaultUI: true,
        });
        //console.log($(this.formSelector + ' input#af2_adress_street')[0]);

        this.autocomplete = new extraParms.maps.places.Autocomplete(
            $(this.formSelector + ' input#af2_adress_street')[0], {types: ["geocode"]}
        );
        this.autocomplete2 = new extraParms.maps.places.Autocomplete(
            $(this.formSelector + ' input#af2_adress_street_')[0], {types: ["geocode"]}
        );

        setTimeout(() => {
            this.autocomplete.setFields(["address_component", "geometry"]);
            this.autocomplete.addListener("place_changed", this.fillInAdress);
            this.autocomplete2.setFields(["address_component", "geometry"]);
            this.autocomplete2.addListener("place_changed", this.fillInAdress2);
        }, 1000);

        this.setHeight();

        this.triggersDesktop();
        this.triggersMobile();**/
    };/** *
    this.triggersDesktop = () => {
        $(this.formSelector + ' #af2_adress_streetnum').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum').val();
            const street = $(this.formSelector + ' #af2_adress_street').val();
            const plz = $(this.formSelector + ' #af2_adress_plz').val();
            const city = $(this.formSelector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_street').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum').val();
            const street = $(this.formSelector + ' #af2_adress_street').val();
            const plz = $(this.formSelector + ' #af2_adress_plz').val();
            const city = $(this.formSelector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_plz').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum').val();
            const street = $(this.formSelector + ' #af2_adress_street').val();
            const plz = $(this.formSelector + ' #af2_adress_plz').val();
            const city = $(this.formSelector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_city').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum').val();
            const street = $(this.formSelector + ' #af2_adress_street').val();
            const plz = $(this.formSelector + ' #af2_adress_plz').val();
            const city = $(this.formSelector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
    }

    this.triggersMobile = () => {
        $(this.formSelector + ' #af2_adress_streetnum_').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum_').val();
            const street = $(this.formSelector + ' #af2_adress_street_').val();
            const plz = $(this.formSelector + ' #af2_adress_plz_').val();
            const city = $(this.formSelector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_street_').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum_').val();
            const street = $(this.formSelector + ' #af2_adress_street_').val();
            const plz = $(this.formSelector + ' #af2_adress_plz_').val();
            const city = $(this.formSelector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_plz_').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum_').val();
            const street = $(this.formSelector + ' #af2_adress_street_').val();
            const plz = $(this.formSelector + ' #af2_adress_plz_').val();
            const city = $(this.formSelector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
        $(this.formSelector + ' #af2_adress_city_').on('input', (ev) => {
            const streetnum = $(this.formSelector + ' #af2_adress_streetnum_').val();
            const street = $(this.formSelector + ' #af2_adress_street_').val();
            const plz = $(this.formSelector + ' #af2_adress_plz_').val();
            const city = $(this.formSelector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'red');
                this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.lastAdressObj = street + ' ' + streetnum + ', ' + plz + ' ' + city;
        });
    }

    /**
    this.fillInAdress = () => {
        const place = this.autocomplete.getPlace();
        let street_number = '';
        let route = '';
        let postal_code = '';
        let locality = '';
        $(this.formSelector + ' #af2_adress_streetnum').val('');
        $(this.formSelector + ' #af2_adress_street').val('');
        $(this.formSelector + ' #af2_adress_plz').val('');
        $(this.formSelector + ' #af2_adress_city').val('');
        place.address_components.forEach((el) => {
            const adressType = el.types[0];
            const val = el.long_name;
            switch(adressType) {
                case 'street_number': {
                    $(this.formSelector + ' #af2_adress_streetnum').val(val);
                    street_number = val;
                    break;
                }
                case 'route': {
                    $(this.formSelector + ' #af2_adress_street').val(val);
                    route = val;
                    break;
                }
                case 'postal_code': {
                    $(this.formSelector + ' #af2_adress_plz').val(val);
                    postal_code = val;
                    break;
                }
                case 'locality': {
                    $(this.formSelector + ' #af2_adress_city').val(val);
                    locality = val;
                    break;
                }
                default: break;
            }
            //console.log(adressType + ' - ' + val);
        });
        let clean = true;
        if(street_number == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'red');
            this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
        if(route == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
        if(postal_code == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
        if(locality == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
        if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');

        this.markers.forEach((marker) => {
            marker.setMap(null);
        });
        this.markers = [];

        const icon = {
            url: place.icon,
            size: new extraParms.maps.Size(71, 71),
            origin: new extraParms.maps.Point(0, 0),
            anchor: new extraParms.maps.Point(17, 34),
            scaledSize: new extraParms.maps.Size(25, 25),
        };


        let mark = new extraParms.maps.Marker({
            title: place.name, position: place.geometry.location,
        });
        mark.setMap(this.map);
        this.markers.push(mark);

        this.map.setCenter(place.geometry.location);
        this.map.setZoom(16);

        this.lastAdressObj = route + ' ' + street_number + ', ' + postal_code + ' ' + locality;
    }**

    this.fillInAdress2 = () => {
        const place = this.autocomplete2.getPlace();
        let street_number = '';
        let route = '';
        let postal_code = '';
        let locality = '';
        $(this.formSelector + ' #af2_adress_streetnum_').val('');
        $(this.formSelector + ' #af2_adress_street_').val('');
        $(this.formSelector + ' #af2_adress_plz_').val('');
        $(this.formSelector + ' #af2_adress_city_').val('');
        place.address_components.forEach((el) => {
            const adressType = el.types[0];
            const val = el.long_name;
            switch(adressType) {
                case 'street_number': {
                    $(this.formSelector + ' #af2_adress_streetnum_').val(val);
                    street_number = val;
                    break;
                }
                case 'route': {
                    $(this.formSelector + ' #af2_adress_street_').val(val);
                    route = val;
                    break;
                }
                case 'postal_code': {
                    $(this.formSelector + ' #af2_adress_plz_').val(val);
                    postal_code = val;
                    break;
                }
                case 'locality': {
                    $(this.formSelector + ' #af2_adress_city_').val(val);
                    locality = val;
                    break;
                }
                default: break;
            }
            //console.log(adressType + ' - ' + val);
        });
        let clean = true;
        if(street_number == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'red');
            this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
        if(route == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
        if(postal_code == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
        if(locality == '') {
            clean = false;
            this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'red');
             this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.formSelector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
        if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');

        this.markers.forEach((marker) => {
            marker.setMap(null);
        });
        this.markers = [];

        const icon = {
            url: place.icon,
            size: new extraParms.maps.Size(71, 71),
            origin: new extraParms.maps.Point(0, 0),
            anchor: new extraParms.maps.Point(17, 34),
            scaledSize: new extraParms.maps.Size(25, 25),
        };


        let mark = new extraParms.maps.Marker({
            title: place.name, position: place.geometry.location,
        });
        mark.setMap(this.map);
        this.markers.push(mark);

        this.map.setCenter(place.geometry.location);
        this.map.setZoom(16);

        this.lastAdressObj = route + ' ' + street_number + ', ' + postal_code + ' ' + locality;
    }*/

    this.setHeight = () => {
        const height = $(this.formSelector + ' .af2_form_carousel #' + this.actualCarouselItem + ' .af2_carousel_content').height();
        $(this.formSelector + ' .af2_form_carousel').css('height', height);

        const width = $(this.formSelector).width();
        if(width > 780) {
            $(this.formSelector).removeClass('af2_nm_mobile_view');
            $(this.formSelector).removeClass('af2_nm_ipad_view');
            $(this.formSelector).addClass('af2_nm_desktop_view');
        }
        else if (width <= 480) {
            $(this.formSelector).addClass('af2_nm_mobile_view');
            $(this.formSelector).removeClass('af2_nm_ipad_view');
            $(this.formSelector).removeClass('af2_nm_desktop_view');
        }
        else {
            $(this.formSelector).removeClass('af2_nm_mobile_view');
            $(this.formSelector).addClass('af2_nm_ipad_view');
            $(this.formSelector).removeClass('af2_nm_desktop_view');
        }
    }

    /** Load the Form's Content **/
    if (datas[id] === undefined) // When Dataid is not already set
    {
        datas[id] = true;

        af2HandleRequest($, this.formSelector, '.af2_form_wrapper', [this.id], this);
    }
    else if(this.popup) {
        af2LoadStyling(this.$, this.id, this.formSelector, this.setHeight);
        this.loadContent();
    }
}

const getAllImagesDonePromise = ($, formSelector) => {
    // A jQuery-style promise we'll resolve
    var d = $.Deferred();

    // Get all images to start with (even complete ones)
    var imgs = $(formSelector + " img");

    // Add a one-time event handler for the load and error events on them
    imgs.one("load.allimages error.allimages", function () {
        // This one completed, remove it
        imgs = imgs.not(this);
        if (imgs.length == 0) {
            // It was the last, resolve
            d.resolve();
        }
    });

    // Find the completed ones
    var complete = imgs.filter(function () {
        return this.complete;
    });

    // Remove our handler from completed ones, remove them from our list
    complete.off(".allimages");
    imgs = imgs.not(complete);
    complete = undefined; // Don't need it anymore

    // If none left, resolve; otherwise wait for events
    if (imgs.length == 0) {
        d.resolve();
    }

    // Return the promise for our deferred
    return d.promise();
}

const af2AdjustSliderBullet = (sliderSelector, sliderBulletSelector, json, $) => {
    let val = sliderSelector.val();
    const min = sliderSelector.attr('min');
    const max = sliderSelector.attr('max');
    const width = sliderSelector.width();
    const thumbWidth = 25;
    const offset = 19;

    let cont = val;

    let bulletPercentage = ((val - min) / (max - min));
    let bulletPosition = bulletPercentage * (width - thumbWidth) - offset;

    putInThousands(json, cont, $).done((ret) => {
        cont = ret;

        let labelBefore = json.type_specifics.labelBefore;

        const label = json.type_specifics.label;
        if (label !== undefined && label !== null && label.trim() !== '')
        {
            if (labelBefore == false || labelBefore === undefined)
            {
                cont += ' ' + label;
            } else if (labelBefore == true)
            {
                cont = label +' ' + cont;
            }
        }

        //sliderBulletSelector.css('left', bulletPosition + 'px');
        sliderBulletSelector.each((i, el) => {
            $(el).html(cont);
        });
    });
};

/**
 * Finding new contents
 *
 * @param $
 * @param iterator
 * @param from
 */
const af2FindNew = ($, iterator, from) => {
    let newSection = undefined;
    let newContent = undefined;
    let found = false;
    $.each(iterator, (i, el) => {
        if (el.operator == null || el.operator == '')
        {
            if (newSection != null || found === false)
            {
                if (el.from === -1) {
                    if (found === false)
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                } else if (el.from === from) {
                    newSection = el.to_section;
                    newContent = el.to_content;
                    found = true;
                }
            }
        } else
        {
            switch (el.operator)
            {
                case '<':
                {
                    if (parseInt(from) < parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
                case '<=':
                {
                    if (parseInt(from) <= parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
                case '>':
                {
                    if (parseInt(from) > parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
                case '>=':
                {
                    if (parseInt(from) >= parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
                case '=':
                {
                    if (parseInt(from) == parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
                case '!=':
                {
                    if (parseInt(from) != parseInt(el.number))
                    {
                        newSection = el.to_section;
                        newContent = el.to_content;
                    }
                    break;
                }
            }
        }
    });

    return [newSection, newContent];
};

/**
 * Finding new contents
 *
 * @param $
 * @param iterator
 * @param from
 *
 const af2FindNew = ($, iterator, from) => {
 let newSection = undefined;
 let newContent = undefined;

 let found = false;
 $.each(iterator, (i, el) => {
 if(el.from === -1)
 {
 if(found === false)
 {
 newSection = el.to_section;
 newContent = el.to_content;
 }
 }
 else if(el.from === from)
 {
 newSection = el.to_section;
 newContent = el.to_content;
 found = true;
 }
 });

 return [newSection, newContent];
 };*/

/**
 * Draws out the content into the carousel
 *
 * @param $
 * @param dataid
 * @param formSelector
 * @param carouselNum
 */
const af2DrawCarouselContent = ($, form, dataid, formSelector, carouselNum, resize_listener_add) => {

    if ($(formSelector + ' .af2_form_carousel').width() !== 0)
    {
        // RESIZE DO
        $(formSelector + ' .af2_form_carousel').css('max-width', $(formSelector + ' .af2_form_carousel').width());
        $(formSelector + ' .af2_form_carousel').css('min-width', $(formSelector + ' .af2_form_carousel').width());
    }

    /** Check out which type it is **/
    const type = datas[dataid].af2_type;                                                                                // The type of the Content to draw
    let content = '';

    /** Build wrapper **/
    content += '<div id="' + carouselNum + '" class="af2_carousel_item">';

    let json = undefined;
    let inp = '';
    /** Validate the type **/
    if (type === 'frage')
    {
        inp = af2DrawFrage($, datas[dataid], formSelector, form);
        json = datas[dataid];
    } else if (type === 'kontaktformular')
    {
        inp = af2DrawKontaktformular($, datas[dataid], form);
        form.af2_is_send_allowed = true;
        setTimeout(function() { initiateIntlTelInput($, form.rtl_layout); }, 200);
    }

    let c = 'af2_carousel_content';
    if (json !== undefined && json.typ === 'af2_adressfeld') {
        c += ' af2_address'
    }
    content += '<div class="'+c+'">';
    content += inp;

    /** Close wrapper **/
    content += '</div>';
    content += '</div>';

    /** Print out **/
    $(formSelector + ' .af2_loading_overlay').css('opacity', 0);
    $(formSelector + ' .af2_loading_overlay').css('width', '0px');
    $(formSelector + ' .af2_loading_overlay').css('height', '0px');
    $(formSelector + ' .af2_form').css('display', 'block');


    $(formSelector + ' .af2_form_carousel').append(content);

    // THROW EVENT

    $(formSelector + ' .af2_form_carousel').trigger('af2_drawed_content');

    form.af2_addAhrefs();

    resize_listener_add();

    adjustTargetBlanks($, formSelector);

    if (json !== undefined && json.typ === 'af2_slider')
    {
        const af2SliderFrageSelector = $(formSelector + ' #' + carouselNum + '.af2_carousel_item .af2_slider_frage');
        const af2SliderFrageBulletSelector = $(formSelector + ' #' + carouselNum + '.af2_carousel_item .af2_slider_frage_bullet');
        af2AdjustSliderBullet(af2SliderFrageSelector, af2SliderFrageBulletSelector, json, $);
    }

    // initalize datepicker
    if (json !== undefined && json.typ === 'af2_datum') {

        let ele = $(formSelector + ' #' + carouselNum + ' div[data-fragen="date"]');
        let date_input = $(formSelector + ' #' + carouselNum + ' input.af2_datum_frage');
        let format = (ele.data("format") != 'undefined' && typeof ele.data("format") != 'undefined') ? ele.data("format") : 'dd.mm.yy';

        let datemandatory = true;
        if(json.type_specifics.datemandatory != undefined && json.type_specifics.datemandatory == false) datemandatory = false;

        if(datemandatory == false) $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');

        ele.datepicker({
            dateFormat: format,
            onSelect: (date) => {
                $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                date_input.val(date);
            },
            firstDay: 1,
            dayNames: [
                af2_frontend_ajax.strings.date.sonntag,
                af2_frontend_ajax.strings.date.montag,
                af2_frontend_ajax.strings.date.dienstag,
                af2_frontend_ajax.strings.date.mittwoch,
                af2_frontend_ajax.strings.date.donnerstag,
                af2_frontend_ajax.strings.date.freitag,
                af2_frontend_ajax.strings.date.samstag,
            ],
            dayNamesShort: [
                af2_frontend_ajax.strings.date.so,
                af2_frontend_ajax.strings.date.mo,
                af2_frontend_ajax.strings.date.di,
                af2_frontend_ajax.strings.date.mi,
                af2_frontend_ajax.strings.date.do,
                af2_frontend_ajax.strings.date.fr,
                af2_frontend_ajax.strings.date.sa,
            ],
            dayNamesMin: [
                af2_frontend_ajax.strings.date.so,
                af2_frontend_ajax.strings.date.mo,
                af2_frontend_ajax.strings.date.di,
                af2_frontend_ajax.strings.date.mi,
                af2_frontend_ajax.strings.date.do,
                af2_frontend_ajax.strings.date.fr,
                af2_frontend_ajax.strings.date.sa,
            ],
            monthNames: [
                af2_frontend_ajax.strings.date.januar,
                af2_frontend_ajax.strings.date.februar,
                af2_frontend_ajax.strings.date.marz,
                af2_frontend_ajax.strings.date.april,
                af2_frontend_ajax.strings.date.mai,
                af2_frontend_ajax.strings.date.juni,
                af2_frontend_ajax.strings.date.juli,
                af2_frontend_ajax.strings.date.august,
                af2_frontend_ajax.strings.date.september,
                af2_frontend_ajax.strings.date.oktober,
                af2_frontend_ajax.strings.date.november,
                af2_frontend_ajax.strings.date.dezember,
            ],
            monthNamesShort: [
                af2_frontend_ajax.strings.date.jan,
                af2_frontend_ajax.strings.date.feb,
                af2_frontend_ajax.strings.date.mar,
                af2_frontend_ajax.strings.date.apr,
                af2_frontend_ajax.strings.date.mai,
                af2_frontend_ajax.strings.date.jun,
                af2_frontend_ajax.strings.date.jul,
                af2_frontend_ajax.strings.date.aug,
                af2_frontend_ajax.strings.date.sep,
                af2_frontend_ajax.strings.date.okt,
                af2_frontend_ajax.strings.date.nov,
                af2_frontend_ajax.strings.date.dez,
            ]
        });
    }

    // initialize Terminbuchungsstuff
    if(json !== undefined && json.typ === 'af2_terminbuchung') {
        $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
        form.lastTerminbuchungsObject.id = dataid;
        // FETCH DATA
        $.ajax({
            url: af2_frontend_ajax.ajax_url,
            method: "GET",
            data: {
                action: 'af2_get_terminbuchungs_data',
                _ajax_nonce: af2_frontend_ajax.nonce,
                id: dataid
            },
            success:function(response){

                if(response == null) {return;};

                const masterObj = JSON.parse(response);

                form.lastTerminbuchungsTimeslotsAllEvents = masterObj.lastTerminbuchungsTimeslotsAllEvents;

                form.lastTerminbuchungsTimeslotsAllEvents.forEach((el, i) => {
                    if(el.start.dateTime != null && el.start.date == null) {
                        let normedStart = af2_convertTZ(new Date(el.start.dateTime), 'Europe/Amsterdam');
                        let normedEnd = af2_convertTZ(new Date(el.end.dateTime), 'Europe/Amsterdam');

                        let convertedStart = af2_convertTZ(normedStart, form.lastTerminbuchungsObject.chosenTimeZone);
                        let convertedEnd = af2_convertTZ(normedEnd, form.lastTerminbuchungsObject.chosenTimeZone);
                    }
                });

                const dateobj = getTerminbuchungsDatepickerStuff(json, form);

                let jsDatePicker = $(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').datepicker(dateobj).val();
                //$(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').datepicker("setDate", null); // this unsets the datepicker's internal selected date; it still shows a highlight on today's date that looks like a selected date though
                //$(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-datepicker-current-day").removeClass("ui-datepicker-current-day"); // this actually removes the highlight
                //$(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-state-active").removeClass("ui-state-active"); // this actually removes the highlight

                // find lowest selectable day
                let lowestDayTd = $(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker tr td:not(".ui-datepicker-unselectable")');
                let lowestDayString = (lowestDayTd.data('month')+1) + "/" + lowestDayTd.find("a").data('date') + "/" + lowestDayTd.data('year');
                $(formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').datepicker().datepicker("setDate", lowestDayString);


                form.setHeight();

                form.lastTerminbuchungsObject.date = jsDatePicker;
                form.lastTerminbuchungsObject.time = undefined;

                $(formSelector + ' .af2_calender_wait--loading').removeClass('af2_calender_wait--loading');

                $(formSelector + ' .af2_terminbuchung_times').css('max-height', '0px');
                const wishHeight = $(formSelector + ' .af2_datewrapper.af2_terminbuchungs_wrap').height();
                const sub1 = $(formSelector + ' .af2_terminbuchung_dur_wrap').height();
                const sub2 = $(formSelector + ' .af2_terminbuchung_dur_wrap').css('margin-bottom').replace('px', '');
                const sub3 = $(formSelector + ' .af2_terminbuchung_heading').height();
                const sub4 = $(formSelector + ' .af2_terminbuchung_heading').css('margin-bottom').replace('px', '');

                const newHeight = wishHeight - sub1 - sub2 - sub3 - sub4;

                $(formSelector + ' .af2_terminbuchung_times').css('max-height', newHeight + 'px');
                $(formSelector + ' .af2_terminbuchung_times').css('min-height', newHeight + 'px');

                form.$(form.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');

                af2_drawTerminbuchungTimes(json, form);
            },
            error:function() {

            }
        });



        $(document).on('click', formSelector + ' .af2_terminbuchung_time', (ev) => {
            $(form.formSelector + ' .af2_form_carousel #' + form.actualCarouselItem + ' .af2_carousel_content .af2_terminbuchung_time').each((i, el) => {
                $(el).removeClass('af2_time_selected');
            });
            $(ev.currentTarget).addClass('af2_time_selected');
            form.lastTerminbuchungsObject.time = $(ev.currentTarget).data('originalvalue');
            if(form.lastTerminbuchungsObject.time != undefined && form.lastTerminbuchungsObject.date != undefined && form.lastTerminbuchungsObject.duration != undefined) {
                $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            }

            const durations = $(form.formSelector + ' .af2_terminbuchung_duration');
            if(durations.length == 1) {
                // only autoslide to next chart if there is one duration available
                $(form.formSelector + ' .af2_form_foward_button').trigger("click");
            }
        });

        $(document).on('click', '.af2_terminbuchung_duration', (ev) => {
            $(form.formSelector + ' .af2_form_carousel #' + form.actualCarouselItem + ' .af2_carousel_content .af2_terminbuchung_duration').each((i, el) => {
                $(el).removeClass('af2_duration_selected');
            });
            $(ev.currentTarget).addClass('af2_duration_selected');
            form.lastTerminbuchungsObject.duration = $(ev.currentTarget).html();
            form.lastTerminbuchungsObject.duration_std = $(ev.currentTarget).data('std');
            form.lastTerminbuchungsObject.duration_min = $(ev.currentTarget).data('min');
            form.lastTerminbuchungsObject.duration_itemc = $(ev.currentTarget).data('itemc');

            form.lastTerminbuchungsObject.time = undefined;
            af2_drawTerminbuchungTimes(json, form);
            $(formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
        });


        /*$('.af2_tb_select_timezone').select2();
        $('.af2_tb_select_timezone').on("change", function(e) {
            form.lastTerminbuchungsObject.chosenTimeZone = $('.af2_tb_select_timezone').find(':selected').attr('value');
            af2_adjustTerminbuchungsTimesByTimezone($, form);
            // CHANGE TIMEZONE
        });

        $('.af2_tb_select_timezone').val(form.lastTerminbuchungsObject.chosenTimeZone); // Select the option with a value of '1'
        $('.af2_tb_select_timezone').trigger('change'); // Notify any JS components that the value changed
*/
    };

    if (json !== undefined && json.typ === 'af2_dateiupload'){
        let ele = $(formSelector + ' #' + carouselNum + ' div[data-fragen="fileupload"]');
        let main_color = '';
        $.each(af2Styles.af2_form_progress,function(i,t){
            if(t.attribute == 'background-color'){
                main_color = t.value;
            }
        });

        let size_limit = json.type_specifics.max_size;
        // if specified file size is greate then server limit
        if(parseInt(json.type_specifics.max_size) > parseInt(af2_frontend_ajax.server_max_size)){
            size_limit = af2_frontend_ajax.server_max_size;
        }

        let supportedFileTypes = af2_frontend_ajax.supported_file_types.split(',');

        supportedFileTypes = supportedFileTypes.filter(function(el) {
            return !json.type_specifics.restricted_types.includes(el);
        });

        supportedFileTypes = supportedFileTypes.toString();

        ele.dropzone({
            paramName:'af2_file',
            url: af2_frontend_ajax.ajax_url,
            addRemoveLinks:true,
            dictCancelUpload:af2_frontend_ajax.strings.dropzone.remove,
            dictRemoveFile:af2_frontend_ajax.strings.dropzone.remove,
            maxFiles:json.type_specifics.max_count,
            maxFilesize:size_limit,
            timeout: 180000,
            acceptedFiles:supportedFileTypes,
            previewTemplate:'<div class="dz-preview dz-file-preview">\n  <div class="dz-image"><img data-dz-thumbnail /></div>\n  <div class="dz-details">\n    <div class="dz-size"><span data-dz-size></span></div>\n    <div class="dz-filename"><span data-dz-name></span></div>\n  </div>\n  <div class="dz-progress"><span style="background:'+main_color+'" class="dz-upload" data-dz-uploadprogress></span></div>\n  <div class="dz-error-message"><span data-dz-errormessage></span></div>\n  <div class="dz-success-mark">\n    <svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n      <title>Check</title>\n      <g stroke="none" stroke-width="1" fill="'+main_color+'" fill-rule="evenodd">\n        <path style="fill:'+main_color+'" d="M23.5,31.8431458 L17.5852419,25.9283877 C16.0248253,24.3679711 13.4910294,24.366835 11.9289322,25.9289322 C10.3700136,27.4878508 10.3665912,30.0234455 11.9283877,31.5852419 L20.4147581,40.0716123 C20.5133999,40.1702541 20.6159315,40.2626649 20.7218615,40.3488435 C22.2835669,41.8725651 24.794234,41.8626202 26.3461564,40.3106978 L43.3106978,23.3461564 C44.8771021,21.7797521 44.8758057,19.2483887 43.3137085,17.6862915 C41.7547899,16.1273729 39.2176035,16.1255422 37.6538436,17.6893022 L23.5,31.8431458 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z" stroke-opacity="0.198794158" stroke="#747474" fill-opacity="0.816519475" fill="#FFFFFF"></path>\n      </g>\n    </svg>\n  </div>\n  <div class="dz-error-mark">\n    <svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n      <title>Error</title>\n      <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\n        <g stroke="#747474" stroke-opacity="0.198794158" fill="#ff694c" fill-opacity="0.816519475">\n          <path d="M32.6568542,29 L38.3106978,23.3461564 C39.8771021,21.7797521 39.8758057,19.2483887 38.3137085,17.6862915 C36.7547899,16.1273729 34.2176035,16.1255422 32.6538436,17.6893022 L27,23.3431458 L21.3461564,17.6893022 C19.7823965,16.1255422 17.2452101,16.1273729 15.6862915,17.6862915 C14.1241943,19.2483887 14.1228979,21.7797521 15.6893022,23.3461564 L21.3431458,29 L15.6893022,34.6538436 C14.1228979,36.2202479 14.1241943,38.7516113 15.6862915,40.3137085 C17.2452101,41.8726271 19.7823965,41.8744578 21.3461564,40.3106978 L27,34.6568542 L32.6538436,40.3106978 C34.2176035,41.8744578 36.7547899,41.8726271 38.3137085,40.3137085 C39.8758057,38.7516113 39.8771021,36.2202479 38.3106978,34.6538436 L32.6568542,29 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z"></path>\n        </g>\n      </g>\n    </svg>\n  </div>\n</div>',
            dictMaxFilesExceeded:af2_frontend_ajax.strings.dropzone.max_uploads,
            dictFileTooBig:af2_frontend_ajax.strings.dropzone.max_uploads_size,
            dictInvalidFileType:af2_frontend_ajax.strings.dropzone.wrong_filetype,
            init: function() {
                if(json.type_specifics.mandatory === true){
                    $(formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                } else {
                    $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                }

                this.on("sending", function(file, xhr, formData) {
                    formData.append("action", "af2_handel_file_upload");
                    formData.append("_ajax_nonce",af2_frontend_ajax.nonce);
                });

                this.on("addedfile", function(file) {
                    $(formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                    const height = $(formSelector + ' .af2_form_carousel #' + carouselNum + ' .af2_carousel_content').height();
                    $(".af2_form_carousel").css("height",height);
                });
            },
            thumbnail:function(){
                // adjust container height on thumb generation
                const height = $(formSelector + ' .af2_form_carousel #' + carouselNum + ' .af2_carousel_content').height();
                $(".af2_form_carousel").css("height",height);
            },
            success:function(file,resp){
                resp = JSON.parse(resp);
                if(resp.success){
                   file.attachment_id =  resp.media_id;
                   $(file.previewElement).attr("data-attachment_id",resp.media_id);
                   $(file.previewElement).data("data-attachment_id",resp.media_id);
                }
                return file.previewElement.classList.add("dz-success");
            },
            error: function(file,errorMessage){
                $(file.previewElement).find(".dz-error-message span").html(errorMessage);
                return file.previewElement.classList.add("dz-error");
            },
            removedfile:function(file){
                $.ajax({
                    url: af2_frontend_ajax.ajax_url,
                    method: "POST",
                    data: {
                        action: 'af2_handel_file_remove',
                        _ajax_nonce: af2_frontend_ajax.nonce,
                        attachment_id: file.attachment_id
                    },
                    success:function(){
                        file.previewElement.remove();
                        const height = $(formSelector + ' .af2_form_carousel #' + carouselNum + ' .af2_carousel_content').height();
                        $(".af2_form_carousel").css("height",height);
                        if(json.type_specifics.mandatory === true){
                            let uploaded_files = $(formSelector + ' #' + carouselNum + '.af2_carousel_item .af2_dateiupload div[data-attachment_id]').length;
                            if(uploaded_files > 0){
                                $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                            }else{
                                $(formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
                            }
                        } else {
                            $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                        }
                    }
                })
            },
            complete:function(file){
                return file.previewElement.classList.add("dz-complete");
            },
            queuecomplete:function() {
                let succ = true;
                this.files.forEach(el => {
                    if(el.status != 'success') succ = false;
                });
                if(succ === true) {
                    $(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
                }
                const height = $(formSelector + ' .af2_form_carousel #' + carouselNum + ' .af2_carousel_content').height();
                $(".af2_form_carousel").css("height",height);
            }
        });
    }

    // initalize select2
    if (json !== undefined && json.typ === 'af2_dropdown') {
        let ele = $(formSelector + ' #' + carouselNum + ' select.af2_dropdown_fragen');
        let width = '84%';
        let special = formSelector.replace('#', '') + ' af2-select2-container desktop';
        if (af2_isMobile()) {
            width = '84%';
            special = formSelector.replace('#', '') + ' af2-select2-container af2_mobile'
        }
        ele.select2({
            selectionCssClass:special,
            //dropdownCssClass:special,
            width: width
        });

        ele.on("select2:open",function(){
            let font_family = $(formSelector + ' .af2_form').css('font-family');
            $('.af2-select2-container').css('font-family',font_family);
        })

    }

    // initialize Adress Field
    if( json !== undefined && json.typ === 'af2_adressfeld' ) {
        if(!afincluded) {
            afincluded = true;

            let script = document.createElement('script');
            script.src = 'https://maps.googleapis.com/maps/api/js?key='+af2_frontend_ajax.supported_server_size+'&callback=af2_initAdresss&libraries=places';
            script.async = true;
            execForm = form;
            document.head.appendChild(script);
        }
        else {
            form.af2_initAdress();
        }

    }
};
window.af2_initAdresss = function() {
    extraParms = google;
    execForm.af2_initAdress();
}

const af2_drawTerminbuchungTimes = (json, form) => {

    //form.$(form.formSelector+' .af2_terminbuchung_times').html('');


    if(form.lastTerminbuchungsObject.date == undefined) {form.$(form.formSelector+' .af2_terminbuchung_times').html(''); return; }

    let date = new Date(form.lastTerminbuchungsObject.date);
    let day = date.getDay();

    let varToUse = null;
    let durationToUse = form.lastTerminbuchungsObject.duration_itemc;
    let val = date.getDate() + '-' + date.getMonth() + '-' + date.getFullYear();
    if(form.lastTerminbuchungsTimeslotsSpecials.get(val) != undefined) varToUse = form.lastTerminbuchungsTimeslotsSpecials.get(val);
    else if(day == 1)        varToUse = form.lastTerminbuchungsTimeslotsMonday;
    else if(day == 2)   varToUse = form.lastTerminbuchungsTimeslotsTuseday;
    else if(day == 3)   varToUse = form.lastTerminbuchungsTimeslotsWednesday;
    else if(day == 4)   varToUse = form.lastTerminbuchungsTimeslotsThursday;
    else if(day == 5)   varToUse = form.lastTerminbuchungsTimeslotsFriday;
    else if(day == 6)   varToUse = form.lastTerminbuchungsTimeslotsSaturday;
    else if(day == 0)   varToUse = form.lastTerminbuchungsTimeslotsSunday;

    let c = '';

    let arr = varToUse[durationToUse].filter(dur => dur.allowed == true);
    arr.forEach((el, i) => {
        const originaltime = el.time;
        let drawingTime = el.time;

        //const chosenTimeZone = form.lastTerminbuchungsObject.chosenTimeZone;

        //let date = new Date();
        //af2_convertTZ()

        c += '<div class="af2_terminbuchung_time" data-originalvalue="'+originaltime+'">'+drawingTime+'</div>';
    });

    if(arr.length < 1) {
        c += '<div class="af2_notification">'+af2_frontend_ajax.strings.noappointments+'</div>';
    }

    form.$(form.formSelector+' .af2_terminbuchung_times').html(c);
}

const getTerminbuchungsDatepickerStuff = (json, form) => {
    // ÜBERARBEITEN!!!
    let today = af2_getTodayStandard();
    const dd = String(today.getDate());
    const mm = String(today.getMonth() + 1); //January is 0!
    const yyyy = today.getFullYear();

    today = mm + '/' + dd + '/' + yyyy;

    const json_tcont = json.type_specifics.termineventcontent;

    const puffer = json_tcont.puffer;

    form.pufferTime = 0;

    form.vorlaufzeit = parseInt(json_tcont.vorlaufzeit);

    switch(puffer) {
        case 'pufer_0': {
            form.pufferTime = 0;
            break;
        }
        case 'puffer_5': {
            form.pufferTime = 5;
            break;
        }
        case 'puffer_10': {
            form.pufferTime = 10;
            break;
        }
        case 'puffer_15': {
            form.pufferTime = 15;
            break;
        }
        case 'puffer_30': {
            form.pufferTime = 30;
            break;
        }
        case 'puffer_60': {
            form.pufferTime = 60;
            break;
        }
    }

    // Initialize Dateobj
    let dateobj = {
        firstDay: 1,
        dayNames: [
            af2_frontend_ajax.strings.date.sonntag,
            af2_frontend_ajax.strings.date.montag,
            af2_frontend_ajax.strings.date.dienstag,
            af2_frontend_ajax.strings.date.mittwoch,
            af2_frontend_ajax.strings.date.donnerstag,
            af2_frontend_ajax.strings.date.freitag,
            af2_frontend_ajax.strings.date.samstag,
        ],
        dayNamesShort: [
            af2_frontend_ajax.strings.date.so,
            af2_frontend_ajax.strings.date.mo,
            af2_frontend_ajax.strings.date.di,
            af2_frontend_ajax.strings.date.mi,
            af2_frontend_ajax.strings.date.do,
            af2_frontend_ajax.strings.date.fr,
            af2_frontend_ajax.strings.date.sa,
        ],
        dayNamesMin: [
            af2_frontend_ajax.strings.date.so,
            af2_frontend_ajax.strings.date.mo,
            af2_frontend_ajax.strings.date.di,
            af2_frontend_ajax.strings.date.mi,
            af2_frontend_ajax.strings.date.do,
            af2_frontend_ajax.strings.date.fr,
            af2_frontend_ajax.strings.date.sa,
        ],
        monthNames: [
            af2_frontend_ajax.strings.date.januar,
            af2_frontend_ajax.strings.date.februar,
            af2_frontend_ajax.strings.date.marz,
            af2_frontend_ajax.strings.date.april,
            af2_frontend_ajax.strings.date.mai,
            af2_frontend_ajax.strings.date.juni,
            af2_frontend_ajax.strings.date.juli,
            af2_frontend_ajax.strings.date.august,
            af2_frontend_ajax.strings.date.september,
            af2_frontend_ajax.strings.date.oktober,
            af2_frontend_ajax.strings.date.november,
            af2_frontend_ajax.strings.date.dezember,
        ],
        monthNamesShort: [
            af2_frontend_ajax.strings.date.jan,
            af2_frontend_ajax.strings.date.feb,
            af2_frontend_ajax.strings.date.mar,
            af2_frontend_ajax.strings.date.apr,
            af2_frontend_ajax.strings.date.mai,
            af2_frontend_ajax.strings.date.jun,
            af2_frontend_ajax.strings.date.jul,
            af2_frontend_ajax.strings.date.aug,
            af2_frontend_ajax.strings.date.sep,
            af2_frontend_ajax.strings.date.okt,
            af2_frontend_ajax.strings.date.nov,
            af2_frontend_ajax.strings.date.dez,
        ],
        onSelect: (date) => {
            //$(formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
            form.lastTerminbuchungsObject.date = date;
            form.lastTerminbuchungsObject.time = undefined;
            form.$(form.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');

            af2_drawTerminbuchungTimes(json, form);
        },
        onChangeMonthYear: (year, month, inst) => {
           form.actualTerminMonth = month-1;
           form.actualTerminYear = year;

           //form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').datepicker("setDate", null); // this unsets the datepicker's internal selected date; it still shows a highlight on today's date that looks like a selected date though
           form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-datepicker-current-day").removeClass("ui-datepicker-current-day"); // this actually removes the highlight
           form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-state-active").removeClass("ui-state-active"); // this actually removes the highlight

           form.lastTerminbuchungsObject.time = undefined;
           form.$(form.formSelector + ' .af2_form_foward_button').addClass('af2_disabled');
           form.lastTerminbuchungsObject.date = undefined;

           setTimeout(() => { form.setHeight(); }, 500);
           setTimeout(() => {
            form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-datepicker-current-day").removeClass("ui-datepicker-current-day"); // this actually removes the highlight
            form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-state-active").removeClass("ui-state-active"); // this actually removes the highlight

            }, 100);
           setTimeout(() => {
            form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-datepicker-current-day").removeClass("ui-datepicker-current-day"); // this actually removes the highlight
            form.$(form.formSelector + ' .af2_terminbuchung_datewrapper.af2_datepicker').find(".ui-state-active").removeClass("ui-state-active"); // this actually removes the highlight

            form.setHeight();

            form.$(form.formSelector + ' .af2_terminbuchung_times').css('max-height', '0px');
            const wishHeight = form.$(form.formSelector + ' .af2_datewrapper.af2_terminbuchungs_wrap').height();
            const sub1 = form.$(form.formSelector + ' .af2_terminbuchung_dur_wrap').height();
            const sub2 = form.$(form.formSelector + ' .af2_terminbuchung_dur_wrap').css('margin-bottom').replace('px', '');
            const sub3 = form.$(form.formSelector + ' .af2_terminbuchung_heading').height();
            const sub4 = form.$(form.formSelector + ' .af2_terminbuchung_heading').css('margin-bottom').replace('px', '');

            const newHeight = wishHeight - sub1 - sub2 - sub3 - sub4;

            form.$(form.formSelector + ' .af2_terminbuchung_times').css('max-height', newHeight + 'px');
            form.$(form.formSelector + ' .af2_terminbuchung_times').css('min-height', newHeight + 'px');
           }, 500);

           af2_drawTerminbuchungTimes(json, form);

           adjustTheNewTerminbuchungDates(json_tcont, form);
        }
    }

    // af2_terminbuchung_duration af2_duration_selected
    // af2_terminbuchung_time

    // Datumsbereich //
    if(json_tcont.datumsbereich == 'daterange_unlimited') {
        let date = new Date(today);
        if(form.vorlaufzeit < 10) {
            date.setHours(date.getHours() + (form.vorlaufzeit * 24));
        }

        dateobj.minDate = date;

        date = new Date(today);
        dateobj.maxDate = `+6m`;
    }
    if(json_tcont.datumsbereich == 'daterange_future') {
        let shortenerMaxDate = 'w';
        let shortenerMaxDateNumber = json_tcont.daterange_future_number.toString();
        if(json_tcont.daterange_future_unit == 'day') shortenerMaxDate = 'd';
        if(json_tcont.daterange_future_unit == 'week') shortenerMaxDate = 'w';
        if(json_tcont.daterange_future_unit == 'month') shortenerMaxDate = 'm';
        if(json_tcont.daterange_future_unit == 'year') shortenerMaxDate = 'y';

        let date = new Date(today);
        if(form.vorlaufzeit < 10) {
            date.setHours(date.getHours() + (form.vorlaufzeit * 24));
        }
        dateobj.minDate = date;
        dateobj.maxDate = `+${shortenerMaxDateNumber}${shortenerMaxDate}`;
    }
    if(json_tcont.datumsbereich == 'daterange_daterange') {
        const daterangeToday = new Date(today);
        const daterangeStart= new Date(json_tcont.daterange_daterange_start);
        const daterangeEnd = new Date(json_tcont.daterange_daterange_end);

        let v1 = parseInt(daterangeToday.getFullYear + '' + daterangeToday.getMonth + '' + daterangeToday.getDate());
        let v2 = parseInt(daterangeStart.getFullYear + '' + daterangeStart.getMonth + '' + daterangeStart.getDate());

        if( v1 >= v2)
        {
            let date = daterangeToday;
            if(form.vorlaufzeit < 10) {
                date.setHours(date.getHours() + (form.vorlaufzeit * 24));
            }
            dateobj.minDate = date;
        }
        else {
            let date = daterangeStart;
            if(form.vorlaufzeit < 10) {
                if(v2 - v1 <= form.vorlaufzeit) {
                    date = daterangeToday;
                    date.setHours(date.getHours() + (form.vorlaufzeit * 24));
                }
            }
            dateobj.minDate = date;
        }

        dateobj.maxDate = daterangeEnd;
    }

    let period = json_tcont.anfangszeit;
    let verf = json_tcont.verfuegbarkeit;

    /*let dateForOffset_ = new Date();
    let timeZoneOffset_ = dateForOffset_.getTimezoneOffset();
    let timeZoneOffsetString_ = af2_convertMinutesToHoursAndMinutes(timeZoneOffset_);

    commaValue = af2_parseTZToFloat(timeZoneOffsetString_);
    let factor = commaValue - 2;
    let finalfactor = af2_parseFloatToTZ(factor);

    console.log(commaValue);
    console.log(factor);
    console.log(finalfactor);*/

    let dateObject = af2_getTodayStandard();
    dateObject.setMinutes(0);
    dateObject.setHours(0);

    form.lastTerminbuchungsTimeslotsMonday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsTuseday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsWednesday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsThursday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsFriday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsSaturday = [[],[],[]];
    form.lastTerminbuchungsTimeslotsSunday = [[],[],[]];

    form.lastTerminbuchungsTimeslotsMonday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsMonday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsMonday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsTuseday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsTuseday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsTuseday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsWednesday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsWednesday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsWednesday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsThursday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsThursday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsThursday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsFriday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsFriday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsFriday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSaturday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSaturday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSaturday[2].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSunday[0].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSunday[1].push({ time: '00:00', allowed: false });
    form.lastTerminbuchungsTimeslotsSunday[2].push({ time: '00:00', allowed: false });

    dateObject.setMinutes(0+period);

    let utcdate = null;

    if(period != 'meeting_duration') {
        period = parseInt(period);

        while(utcdate == dateObject.getDate() || utcdate == null) {

            let minutes = (dateObject.getMinutes() < 10 ? '0' : '') + dateObject.getMinutes();
            let hours = (dateObject.getHours() < 10 ? '0' : '') + dateObject.getHours();

            form.lastTerminbuchungsTimeslotsMonday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsMonday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsMonday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsTuseday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsTuseday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsTuseday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsWednesday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsWednesday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsWednesday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsThursday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsThursday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsThursday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsFriday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsFriday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsFriday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSaturday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSaturday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSaturday[2].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSunday[0].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSunday[1].push({ time: hours+':'+minutes, allowed: false });
            form.lastTerminbuchungsTimeslotsSunday[2].push({ time: hours+':'+minutes, allowed: false });

            if(utcdate == null) utcdate = dateObject.getDate();

            dateObject.setMinutes(parseInt(minutes)+period);
        }

        json_tcont.dauer.forEach((a, y) => {
            verf.forEach(el => {
                if(el.days == 'daily') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsMonday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsTuseday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsWednesday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsThursday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsFriday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSaturday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSunday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'workday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsMonday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsTuseday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsWednesday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsThursday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsFriday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'weekend') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSaturday', y, json_tcont.dauer, time1, time2);
                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSunday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'monday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsMonday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'tuseday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsTuseday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'wednesday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsWednesday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'thursday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];


                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsThursday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'friday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];


                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsFriday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'saturday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];


                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSaturday', y, json_tcont.dauer, time1, time2);
                }
                if(el.days == 'sunday') {
                    const time1 = el.from.split('-')[0]+''+el.from.split('-')[1];
                    const time2 = el.to.split('-')[0]+''+el.to.split('-')[1];

                    doBasicTimeSlotsAf2(form, 'lastTerminbuchungsTimeslotsSunday', y, json_tcont.dauer, time1, time2);
                }
            });
        });
    }
    else {

    }

    //form.lastTerminbuchungsTimeslotsAllEvents;
    //form.lastTerminbuchungsTimeslotsSpecials = [];

    form.lastTerminbuchungsTimeslotsSpecials = new Map();
    form.lastTerminbuchungsTimeslotsSpecialsDisabled = new Map();

    // Actual Month zuküntig anpassen!
    const actualMonth = form.actualTerminMonth;
    const actualYear = form.actualTerminYear;

    let allFullDays = form.lastTerminbuchungsTimeslotsAllEvents.filter(ev => {return ev.start.date != null && ev.end.date != null && new Date(ev.start.date).getMonth() == actualMonth && new Date(ev.start.date).getFullYear() == actualYear});
    allFullDays.forEach((el, i) => {
        let dates = af2getDatesInBetween(new Date(el.start.date), new Date(el.end.date));

        dates.forEach((x, y) => {
            const date = new Date(x);
            const val = date.getDate() + '-' + date.getMonth() + '-' + date.getFullYear();
            form.lastTerminbuchungsTimeslotsSpecialsDisabled.set(val, true);
        });
    });

    let allNotfullDays = form.lastTerminbuchungsTimeslotsAllEvents.filter(ev => {return ev.start.date == null && ev.end.date == null  && new Date(ev.start.dateTime).getMonth() == actualMonth && new Date(ev.start.dateTime).getFullYear() == actualYear});
    allNotfullDays.forEach((el, i) => {
        const dayNum = new Date(el.start.dateTime).getDay();
        const startDay = new Date(el.start.dateTime).getDate();
        const startMonth = new Date(el.start.dateTime).getMonth();
        const startYear = new Date(el.start.dateTime).getFullYear();
        const endDay = new Date(el.end.dateTime).getDate();
        const endMonth = new Date(el.end.dateTime).getMonth();
        const endYear = new Date(el.end.dateTime).getFullYear();


        const pufferObject = getStartEndTimesWithPuffer(el.start.dateTime, el.end.dateTime, form);

        const startHours = pufferObject[0];
        const startMinutes = pufferObject[1];
        const endHours = pufferObject[2];
        const endMinutes = pufferObject[3];
/*
        const startHours = (new Date(el.start.dateTime).getHours() < 10 ? '0' : '') + new Date(el.start.dateTime).getHours();
        const startMinutes = (new Date(el.start.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.start.dateTime).getMinutes();
        const endHours = (new Date(el.end.dateTime).getHours() < 10 ? '0' : '') + new Date(el.end.dateTime).getHours();
        const endMinutes = (new Date(el.end.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.end.dateTime).getMinutes();
*/

        const startTime = startHours + '' + startMinutes;
        const endTime = endHours + '' + endMinutes;

        if(startDay == endDay && startMonth == endMonth && startYear == endYear) {
            let x = undefined;
            if(dayNum == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNum == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNum == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNum == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNum == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNum == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNum == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, x);
            }

            let editArray = form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear);


            json_tcont.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.start.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if((t2 > startTime  || startDay != newDateOb.getDate()) && t1 < endTime) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });

            form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, editArray);
        }
        else {
            let dates = af2getDatesInBetween(new Date(el.start.date), new Date(el.end.date));

            dates.forEach((x, y) => {
                if(i > 0) {
                    const date = new Date(x);
                    const val = date.getDate() + '-' + date.getMonth() + '-' + date.getFullYear();
                    form.lastTerminbuchungsTimeslotsSpecialsDisabled.set(val, true);
                }
            });


            const pufferObject = getStartEndTimesWithPuffer(el.start.dateTime, el.end.dateTime, form);

            const dayNumStart = new Date(el.start.dateTime).getDay();
            const dayNumEnd = new Date(el.end.dateTime).getDay();

            const startDay = new Date(el.start.dateTime).getDate();
            const startMonth = new Date(el.start.dateTime).getMonth();
            const startYear = new Date(el.start.dateTime).getFullYear();

            const endDay = new Date(el.end.dateTime).getDate();
            const endMonth = new Date(el.end.dateTime).getMonth();
            const endYear = new Date(el.end.dateTime).getFullYear();

            const startHours = pufferObject[0];
            const startMinutes = pufferObject[1];
            const endHours = pufferObject[2];
            const endMinutes = pufferObject[3];

            /*
            const startHours = (new Date(el.start.dateTime).getHours() < 10 ? '0' : '') + new Date(el.start.dateTime).getHours();
            const startMinutes = (new Date(el.start.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.start.dateTime).getMinutes();

            const endHours = (new Date(el.end.dateTime).getHours() < 10 ? '0' : '') + new Date(el.end.dateTime).getHours();
            const endMinutes = (new Date(el.end.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.end.dateTime).getMinutes();
            */
            const startTime = startHours + '' + startMinutes;
            const endTime = endHours + '' + endMinutes;

            // START
            let x = undefined;
            if(dayNumStart == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNumStart == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNumStart == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNumStart == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNumStart == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNumStart == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNumStart == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, x);
            }

            let editArray = form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear);

            json_tcont.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.start.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if(t2 > startTime || startDay != newDateOb.getDate()) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });
            form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, editArray);


            // END
            x = undefined;
            if(dayNumEnd == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNumEnd == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNumEnd == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNumEnd == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNumEnd == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNumEnd == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNumEnd == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(endDay + '-'+endMonth+'-'+endYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(endDay + '-'+endMonth+'-'+endYear, x);
            }

            editArray = form.lastTerminbuchungsTimeslotsSpecials.get(endDay + '-'+endMonth+'-'+endYear);

            json_tcont.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.end.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if(t1 < endTime) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });
            form.lastTerminbuchungsTimeslotsSpecials.set(endDay + '-'+endMonth+'-'+endYear, editArray);
        }
    });

    // setting the next possible day

    let todayy = af2_getTodayStandard();
    const dayNumStart = todayy.getDay();
    const todayDay = todayy.getDate();
    const todayMonth = todayy.getMonth();
    const todayYear = todayy.getFullYear();
    const todayHours = todayy.getHours();
    const todayMinutes = todayy.getMinutes();

     // START
     let x = undefined;
     if(dayNumStart == 1) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
     }
     else if(dayNumStart == 2) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
     }
     else if(dayNumStart == 3) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
     }
     else if(dayNumStart == 4) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
     }
     else if(dayNumStart == 5) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
     }
     else if(dayNumStart == 6) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
     }
     else if(dayNumStart == 0) {
         x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
     }
     if(form.lastTerminbuchungsTimeslotsSpecials.get(todayDay + '-'+todayMonth+'-'+todayYear) == undefined) {
         form.lastTerminbuchungsTimeslotsSpecials.set(todayDay + '-'+todayMonth+'-'+todayYear, x);
     }

     let editArray = form.lastTerminbuchungsTimeslotsSpecials.get(todayDay + '-'+todayMonth+'-'+todayYear);

     json_tcont.dauer.forEach((elem, abi) => {
         editArray[abi].forEach((eleme, aby) => {

            const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
            let newDateOb = af2_getTodayStandard();
            newDateOb.setHours(eleme.time.split(':')[0]);
            newDateOb.setMinutes(eleme.time.split(':')[1]);

            let minutes = newDateOb.getMinutes();
            let hours = newDateOb.getHours();

            if(hours > todayHours || (hours == todayHours && minutes > todayMinutes )) {
                newDateOb.setMinutes(minutes - form.vorlaufzeit);
                minutes = newDateOb.getMinutes();
                hours = newDateOb.getHours();
                if(hours > todayHours || (hours == todayHours && minutes > todayMinutes )) {
                }
                else {
                    editArray[abi][aby].allowed = false;
                }
            }
            else {
                editArray[abi][aby].allowed = false;
            }
         });
     });
     form.lastTerminbuchungsTimeslotsSpecials.set(todayDay + '-'+todayMonth+'-'+todayYear, editArray);


    dateobj.beforeShowDay = function(dayy) {
        const pos = form.lastTerminbuchungsObject.duration_itemc;
        var day = dayy.getDay();
        const dayNum = dayy.getDate();
        const month = dayy.getMonth();
        const year = dayy.getFullYear();
        const name = dayNum + '-'+month+'-'+year;
        if(1 == 2) {}
        else if(day == 1) {
            if(form.lastTerminbuchungsTimeslotsMonday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 2) {
            if(form.lastTerminbuchungsTimeslotsTuseday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 3) {
            if(form.lastTerminbuchungsTimeslotsWednesday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 4) {
            if(form.lastTerminbuchungsTimeslotsThursday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 5) {
            if(form.lastTerminbuchungsTimeslotsFriday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 6) {
            if(form.lastTerminbuchungsTimeslotsSaturday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }
        else if(day == 0) {
            if(form.lastTerminbuchungsTimeslotsSunday[pos].filter(slot => slot.allowed == true).length <= 0) return [false, ''];
        }

        if(form.lastTerminbuchungsTimeslotsSpecialsDisabled.get(name) == true) return [false, ''];

        return [true, ''];
    };

    return dateobj;
};

const getStartEndTimesWithPuffer = (startDateTime, endDateTime, form) => {

    const startTime = af2_convertTZ(new Date(startDateTime), 'Europe/Amsterdam');
    const endTime = af2_convertTZ(new Date(endDateTime), 'Europe/Amsterdam');

    let startHours = startTime.getHours();
    let startMinutes = startTime.getMinutes();
    let endHours = endTime.getHours();
    let endMinutes = endTime.getMinutes();

    let startWithPuffer = af2_convertTZ(new Date(startDateTime), 'Europe/Amsterdam');
    let endWithPuffer = af2_convertTZ(new Date(endDateTime), 'Europe/Amsterdam');

    startWithPuffer.setMinutes(startMinutes - (2*form.pufferTime));
    endWithPuffer.setMinutes(endMinutes + (2*form.pufferTime));

    startHours = startWithPuffer.getHours();
    startMinutes = startWithPuffer.getMinutes();
    endHours = endWithPuffer.getHours();
    endMinutes = endWithPuffer.getMinutes();

    const rStartHours = (startHours < 10 ? '0' : '') + startHours;
    const rStartMinutes = (startMinutes < 10 ? '0' : '') + startMinutes;
    const rEndHours = (endHours < 10 ? '0' : '') + endHours;
    const rEndMinutes = (endMinutes < 10 ? '0' : '') + endMinutes;

    return [rStartHours, rStartMinutes, rEndHours, rEndMinutes];
}

const adjustTheNewTerminbuchungDates = (json ,form) => {
    // Actual Month zuküntig anpassen!
    const actualMonth = form.actualTerminMonth;
    const actualYear = form.actualTerminYear;

    let allFullDays = form.lastTerminbuchungsTimeslotsAllEvents.filter(ev => {return ev.start.date != null && ev.end.date != null && new Date(ev.start.date).getMonth() == actualMonth && new Date(ev.start.date).getFullYear() == actualYear});
    allFullDays.forEach((el, i) => {
        let dates = af2getDatesInBetween(new Date(el.start.date), new Date(el.end.date));

        dates.forEach((x, y) => {
            const date = new Date(x);
            const val = date.getDate() + '-' + date.getMonth() + '-' + date.getFullYear();
            form.lastTerminbuchungsTimeslotsSpecialsDisabled.set(val, true);
        });
    });

    let allNotfullDays = form.lastTerminbuchungsTimeslotsAllEvents.filter(ev => {return ev.start.date == null && ev.end.date == null  && new Date(ev.start.dateTime).getMonth() == actualMonth && new Date(ev.start.dateTime).getFullYear() == actualYear});
    allNotfullDays.forEach((el, i) => {
        const dayNum = new Date(el.start.dateTime).getDay();
        const startDay = new Date(el.start.dateTime).getDate();
        const startMonth = new Date(el.start.dateTime).getMonth();
        const startYear = new Date(el.start.dateTime).getFullYear();
        const endDay = new Date(el.end.dateTime).getDate();
        const endMonth = new Date(el.end.dateTime).getMonth();
        const endYear = new Date(el.end.dateTime).getFullYear();

        const pufferObject = getStartEndTimesWithPuffer(el.start.dateTime, el.end.dateTime, form);

        const startHours = pufferObject[0];
        const startMinutes = pufferObject[1];
        const endHours = pufferObject[2];
        const endMinutes = pufferObject[3];

/*
        const startHours = (new Date(el.start.dateTime).getHours() < 10 ? '0' : '') + new Date(el.start.dateTime).getHours();
        const startMinutes = (new Date(el.start.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.start.dateTime).getMinutes();
        const endHours = (new Date(el.end.dateTime).getHours() < 10 ? '0' : '') + new Date(el.end.dateTime).getHours();
        const endMinutes = (new Date(el.end.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.end.dateTime).getMinutes();
*/
        const startTime = startHours + '' + startMinutes;
        const endTime = endHours + '' + endMinutes;

        if(startDay == endDay && startMonth == endMonth && startYear == endYear) {
            let x = undefined;
            if(dayNum == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNum == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNum == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNum == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNum == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNum == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNum == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, x);
            }

            let editArray = form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear);


            json.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.start.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if((t2 > startTime || startDay != newDateOb.getDate()) && t1 < endTime) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });

            form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, editArray);
        }
        else {
            let dates = af2getDatesInBetween(new Date(el.start.date), new Date(el.end.date));

            dates.forEach((x, y) => {
                if(i > 0) {
                    const date = new Date(x);
                    const val = date.getDate() + '-' + date.getMonth() + '-' + date.getFullYear();
                    form.lastTerminbuchungsTimeslotsSpecialsDisabled.set(val, true);
                }
            });

            const dayNumStart = new Date(el.start.dateTime).getDay();
            const dayNumEnd = new Date(el.end.dateTime).getDay();

            const startDay = new Date(el.start.dateTime).getDate();
            const startMonth = new Date(el.start.dateTime).getMonth();
            const startYear = new Date(el.start.dateTime).getFullYear();

            const endDay = new Date(el.end.dateTime).getDate();
            const endMonth = new Date(el.end.dateTime).getMonth();
            const endYear = new Date(el.end.dateTime).getFullYear();

            const pufferObject = getStartEndTimesWithPuffer(el.start.dateTime, el.end.dateTime, form);

            const startHours = pufferObject[0];
            const startMinutes = pufferObject[1];
            const endHours = pufferObject[2];
            const endMinutes = pufferObject[3];

/*
            const startHours = (new Date(el.start.dateTime).getHours() < 10 ? '0' : '') + new Date(el.start.dateTime).getHours();
            const startMinutes = (new Date(el.start.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.start.dateTime).getMinutes();

            const endHours = (new Date(el.end.dateTime).getHours() < 10 ? '0' : '') + new Date(el.end.dateTime).getHours();
            const endMinutes = (new Date(el.end.dateTime).getMinutes() < 10 ? '0' : '') + new Date(el.end.dateTime).getMinutes();
*/
            const startTime = startHours + '' + startMinutes;
            const endTime = endHours + '' + endMinutes;

            // START
            let x = undefined;
            if(dayNumStart == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNumStart == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNumStart == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNumStart == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNumStart == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNumStart == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNumStart == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, x);
            }

            let editArray = form.lastTerminbuchungsTimeslotsSpecials.get(startDay + '-'+startMonth+'-'+startYear);

            json.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.start.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if(t2 > startTime || startDay != newDateOb.getDate()) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });
            form.lastTerminbuchungsTimeslotsSpecials.set(startDay + '-'+startMonth+'-'+startYear, editArray);


            // END
            x = undefined;
            if(dayNumEnd == 1) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsMonday);
            }
            else if(dayNumEnd == 2) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsTuseday);
            }
            else if(dayNumEnd == 3) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsWednesday);
            }
            else if(dayNumEnd == 4) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsThursday);
            }
            else if(dayNumEnd == 5) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsFriday);
            }
            else if(dayNumEnd == 6) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSaturday);
            }
            else if(dayNumEnd == 0) {
                x = af2_deepCopyArray(form.lastTerminbuchungsTimeslotsSunday);
            }
            if(form.lastTerminbuchungsTimeslotsSpecials.get(endDay + '-'+endMonth+'-'+endYear) == undefined) {
                form.lastTerminbuchungsTimeslotsSpecials.set(endDay + '-'+endMonth+'-'+endYear, x);
            }

            editArray = form.lastTerminbuchungsTimeslotsSpecials.get(endDay + '-'+endMonth+'-'+endYear);

            json.dauer.forEach((elem, abi) => {
                editArray[abi].forEach((eleme, aby) => {
                    const t1 = eleme.time.split(':')[0]+''+eleme.time.split(':')[1];
                    let newDateOb = new Date(el.end.dateTime);
                    newDateOb.setHours(eleme.time.split(':')[0]);
                    newDateOb.setMinutes(eleme.time.split(':')[1]);

                    newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(elem.min));
                    newDateOb.setHours(newDateOb.getHours()+parseInt(elem.std));

                    let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes();
                    let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
                    const t2 = hours+''+minutes;

                    //if(t1 >= startTime && t1 < endTime) {
                    //    console.log('Case 1');
                    //    console.log(t1 + ' - ' + t2);
                    //    console.log(startTime + ' - ' + endTime);
                    //    editArray[abi][aby].allowed = false; // Start währen des Events
                    //}
                    if(t1 < endTime) {
                        //console.log('Case 2');
                        //console.log(t1 + ' - ' + t2);
                        //console.log(startTime + ' - ' + endTime);
                        editArray[abi][aby].allowed = false;// Läuft ins Event oder Über das Event hinaus
                    }
                });
            });
            form.lastTerminbuchungsTimeslotsSpecials.set(endDay + '-'+endMonth+'-'+endYear, editArray);
        }
    });
}

function af2addDays (datex, days) {
    var date = new Date(datex.valueOf());
    date.setDate(date.getDate() + days);
    return date;
}

function af2getDatesInBetween(startDate, stopDate) {
    var dateArray = new Array();
    var currentDate = startDate;
    while (currentDate < stopDate) {
        dateArray.push(new Date (currentDate));
        currentDate = af2addDays(currentDate, 1);
    }
    return dateArray;
}

const doBasicTimeSlotsAf2 = (form, val, duration, dauer, time1, time2) => {
    form[val][duration].forEach((ele, i) => {
        const t1 = ele.time.split(':')[0]+''+ele.time.split(':')[1];
        let newDateOb = af2_getTodayStandard();
        newDateOb.setHours(ele.time.split(':')[0]);
        newDateOb.setMinutes(ele.time.split(':')[1]);
        let day = newDateOb.getDay();
        newDateOb.setMinutes(newDateOb.getMinutes()+parseInt(dauer[duration].min));
        newDateOb.setHours(newDateOb.getHours()+parseInt(dauer[duration].std));
        let minutes = (newDateOb.getMinutes() < 10 ? '0' : '') + newDateOb.getMinutes()
        let hours = (newDateOb.getHours() < 10 ? '0' : '') + newDateOb.getHours();
        const t2 = hours+''+minutes;
        if(t1 >= time1 && t1 < time2 && t2 > time1 && t2 <= time2 && day == newDateOb.getDay() ) form[val][duration][i].allowed = true;
    });
}

const adjustTargetBlanks = ($, formSelector) => {
    $(formSelector + ' .af2_question a').each((i, el) => {
        $(el).attr('target', '_blank');
    });
};

/**
 * Draws the content of a question
 *
 * @param $
 * @param json
 * @returns {string}
 */
const af2DrawFrage = ($, json, formSelector, form) => {

    let content = '';
    let bonusClass = '';
    if(form.firstQuestion === true) bonusClass = 'af2_start';

    let tracking = json.tracking;
    if(tracking != undefined && tracking != '')
        content += '<div style="display: none;">'+tracking+'</div>';

    /** Validate Questiontype **/
    if (json.typ === 'af2_select')
    {
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_answer_container af2_mobile_'+json.type_specifics.mobile_layout+' af2_desktop_'+json.type_specifics.desktop_layout+'">';
        content += af2ProcessAnswers($, bonusClass, json.type_specifics.answers,json.type_specifics.desktop_layout,json.type_specifics.mobile_layout);
        content += '<div>';
    } else if (json.typ === 'af2_multiselect')
    {
        /**let cond = '(Mehrfachauswahl möglich)';
         if(json.type_specifics.condition !== '' && $.isNumeric(json.type_specifics.condition) && json.type_specifics.condition > 1)
         {
         cond = '(Bis zu '+json.type_specifics.condition+' Antworten möglich)';
         }**/
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_answer_container af2_mobile_'+json.type_specifics.mobile_layout+' af2_desktop_'+json.type_specifics.desktop_layout+'">';
        content += af2ProcessAnswers($, bonusClass, json.type_specifics.answers,json.type_specifics.desktop_layout,json.type_specifics.mobile_layout);
        content += '<div>';
    } else if (json.typ === 'af2_textfeld')
    {
        let minlength = json.type_specifics.min_length != null ? 'data-minlength="'+json.type_specifics.min_length+'"' : '';
        let maxlength = json.type_specifics.max_length != null ? 'data-maxlength="'+json.type_specifics.max_length+'"' : '';

        let text_only_text = json.type_specifics.text_only_text != null ? 'data-text_only_text="'+json.type_specifics.text_only_text+'"' : '';
        let text_only_numbers = json.type_specifics.text_only_numbers != null ? 'data-text_only_numbers="'+json.type_specifics.text_only_numbers+'"' : '';
        let text_birthday = json.type_specifics.text_birthday != null ? 'data-text_birthday="'+json.type_specifics.text_birthday+'"' : '';

        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        content += '<input type="text" '+minlength+' '+maxlength+' '+text_only_text+' '+text_only_numbers+' '+text_birthday+' class="af2_textfeld_frage '+bonusClass+' desktop" data-mandatory="' + json.type_specifics.mandatory + '" placeholder="' + json.type_specifics.placeholder + '">';
        content += '<input type="text" '+minlength+' '+maxlength+' '+text_only_text+' '+text_only_numbers+' '+text_birthday+' class="af2_textfeld_frage '+bonusClass+' af2_mobile" data-mandatory="' + json.type_specifics.mandatory + '" placeholder="' + json.type_specifics.placeholder + '">';
    } else if (json.typ === 'af2_textbereich')
    {
        let minlength = json.type_specifics.min_length != null ? 'data-minlength="'+json.type_specifics.min_length+'"' : '';
        let maxlength = json.type_specifics.max_length != null ? 'data-maxlength="'+json.type_specifics.max_length+'"' : '';


        let text_only_text = json.type_specifics.text_only_text != null ? 'data-text_only_text="'+json.type_specifics.text_only_text+'"' : '';
        let text_only_numbers = json.type_specifics.text_only_numbers != null ? 'data-text_only_numbers="'+json.type_specifics.text_only_numbers+'"' : '';
        let text_birthday = json.type_specifics.text_birthday != null ? 'data-text_birthday="'+json.type_specifics.text_birthday+'"' : '';

        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        content += '<textarea  '+minlength+' '+maxlength+' '+text_only_text+' '+text_only_numbers+' '+text_birthday+' class="af2_textbereich_frage '+bonusClass+' desktop" data-mandatory="' + json.type_specifics.mandatory + '"  placeholder="' + json.type_specifics.placeholder + '"></textarea>';
        content += '<textarea  '+minlength+' '+maxlength+' '+text_only_text+' '+text_only_numbers+' '+text_birthday+' class="af2_textbereich_frage '+bonusClass+' af2_mobile" data-mandatory="' + json.type_specifics.mandatory + '"  placeholder="' + json.type_specifics.placeholder + '"></textarea>';
    } else if (json.typ === 'af2_datum')
    {
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        content += '<input type="text" class="af2_datum_frage desktop" placeholder="' + json.type_specifics.placeholder + '">';
        content += '<input type="text" class="af2_datum_frage af2_mobile" placeholder="' + json.type_specifics.placeholder + '">';
        content += '<div class="af2-datepicker af2_datepicker desktop" data-fragen="date" data-format="' + json.type_specifics.format + '"></div>';
        content += '<div class="af2-datepicker af2_datepicker af2_mobile" data-fragen="date" data-format="' + json.type_specifics.format + '"></div>';
    } else if (json.typ === 'af2_content')
    {
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';
        let new_html_content = json.type_specifics.content;
        if(new_html_content.includes(af2_frontend_ajax.strings.antworten_tag)) {
            let antwortenContentDesktop = '';
            let antwortenContentMobile = '';

            antwortenContentDesktop += '<div class="af2_html_content_summary desktop">';
            antwortenContentMobile += '<div class="af2_html_content_summary af2_mobile">';

            form.answerObject.forEach((el, i) => {
                antwortenContentDesktop += '<div class="af2_html_content_summary_object desktop">';
                let bottomborderclass = 'af2_bottom_border';
                if(i >= form.answerObject.length - 1) bottomborderclass = '';
                antwortenContentMobile += '<div class="af2_html_content_summary_object af2_mobile '+bottomborderclass+'">';

                    antwortenContentDesktop += '<div class="af2_html_content_summary_object_title desktop">';
                    antwortenContentMobile += '<div class="af2_html_content_summary_object_title af2_mobile">';
                        antwortenContentDesktop += '<p class="af2_html_content_summary_object_title_ desktop">'+el.title+'</p>';
                        antwortenContentMobile += '<p class="af2_html_content_summary_object_title_ af2_mobile">'+el.title+'</p>';
                    antwortenContentDesktop += '</div>';
                    antwortenContentMobile += '</div>';

                    antwortenContentDesktop += '<div class="af2_html_content_summary_object_answer desktop">';
                    antwortenContentMobile += '<div class="af2_html_content_summary_object_answer af2_mobile">';
                        antwortenContentDesktop += '<p class="af2_html_content_summary_object_answer_ desktop">'+el.answer+'</p>';
                        antwortenContentMobile += '<p class="af2_html_content_summary_object_answer_ af2_mobile">'+el.answer+'</p>';
                    antwortenContentDesktop += '</div>';
                    antwortenContentMobile += '</div>';

                antwortenContentDesktop += '</div>';
                antwortenContentMobile += '</div>';
            });

            antwortenContentDesktop += '</div>';
            antwortenContentMobile += '</div>';

            new_html_content = new_html_content.replace(af2_frontend_ajax.strings.antworten_tag, antwortenContentDesktop+antwortenContentMobile);
        }
        content += '<div class="af2_content_frage desktop">' + new_html_content + '</div>';
        content += '<div class="af2_content_frage af2_mobile">' + new_html_content + '</div>';

        if (json.type_specifics.content_button == true)
        {
            content += '<div class="af2_submit_wrapper"><input class="af2_submit_button no_send" value="' + json.type_specifics.content_button_text + '" type="submit"></div>';
        }
    } else if (json.typ === 'af2_slider')
    {
        $(formSelector + ' .af2_form_bottombar').css('opacity', 1);

        let min = json.type_specifics.min;
        let max = json.type_specifics.max;
        let label = json.type_specifics.label;
        let labelBefore = json.type_specifics.labelBefore;

        putInThousands(json, min, $).done((ret) => {
            min = ret;

            putInThousands(json, max, $).done((ret) => {
                max = ret;

                if (label !== undefined && label !== null && label.trim() !== '')
                {

                    if (labelBefore == false || labelBefore === undefined)
                    {
                        min += ' ' +label;
                        max += ' ' +label;
                    } else if (labelBefore == true)
                    {
                        min = label +' '+ min;
                        max = label +' '+ max;
                    }
                }

                let val = '';

                if (json.type_specifics.start !== undefined)
                {
                    val = 'value="' + parseInt(json.type_specifics.start) + '"';
                }

                let slider_frage_val_class = 'af2_slider_frage_val';
                let alternate_text_wrap_span_class = 'alternate_text_wrap_span';

                let rtl_type_class = form.rtl_layout == true ? 'af2_rtl_layout' : '';

                if(labelBefore == false || labelBefore === undefined)
                {
                    slider_frage_val_class += ' af2_slider_frage_val_after '+rtl_type_class;
                    alternate_text_wrap_span_class += ' alternate_text_wrap_span_after '+rtl_type_class;
                } else if(labelBefore == true)
                {
                    slider_frage_val_class += ' af2_slider_frage_val_before '+rtl_type_class;
                    alternate_text_wrap_span_class += ' alternate_text_wrap_span_before '+rtl_type_class;
                }

                let slider_input_wrap_i =  '<input type="number" class="'+slider_frage_val_class+' desktop" min="' + json.type_specifics.min + '" max="' + json.type_specifics.max + '">';
                    slider_input_wrap_i += '<input type="number" class="'+slider_frage_val_class+' af2_mobile" min="' + json.type_specifics.min + '" max="' + json.type_specifics.max + '">';

                let slider_input_wrap_text_span =  '<span class="'+alternate_text_wrap_span_class+' desktop">'+json.type_specifics.label+'</span>';
                    slider_input_wrap_text_span += '<span class="'+alternate_text_wrap_span_class+' af2_mobile">'+json.type_specifics.label+'</span>';

                if(labelBefore == false || labelBefore === undefined)
                {
                    slider_input_wrap_i += slider_input_wrap_text_span;
                } else if(labelBefore == true)
                {
                    slider_input_wrap_i = slider_input_wrap_text_span + slider_input_wrap_i;
                }

                // HERE COMES MORE CONTENT

                let drawImage = json.type_specifics.image;
                let drawwidth = '15%';
                if(json.type_specifics.image == "" || json.type_specifics.image == undefined) {
                    drawImage = 'none';
                    drawwidth  = '0%';
                }

                content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
                content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';

                content += '<div class="af2_slider_frage_wrapper">';
                //content += '<div class="af2_slider_image_icon_wrapper af2_mobile" style="margin: 0 auto; width: '+drawwidth+'; height: 120px; background: '+drawImage+ '; background-size: contain; background-repeat: no-repeat; background-position: center">';
                if(json.type_specifics.image != "" && json.type_specifics.image != undefined) content += '<div class="af2_slider_image_icon_wrapper af2_mobile" style="margin: 0 auto; width: 90px; height: 90px;"><img style="max-width: 100%; max-height: 100%;" src="'+drawImage+'"></div>';
                if(json.type_specifics.icon != "" && json.type_specifics.icon != undefined) content += '<div class="af2_slider_image_icon_wrapper af2_mobile" style="margin-bottom:20px;"><i style="font-size: 80px" class="'+json.type_specifics.icon+'"></i></div>';
                //if(( json.type_specifics.image != "" && json.type_specifics.image != undefined ) || ( json.type_specifics.icon != "" && json.type_specifics.icon != undefined))
                    //content += '<div style="width: 84%; max-width: 84%; min-width: 84%; margin: auto; display: flex; justify-content: center; align-items: center;">';
                    content += '<div style="width: 100%;">';
                //else content += '<div style="width: 84%; max-width: 84%; min-width: 84%;">';
                content += '<div class="af2_slider_frage_bullet desktop"></div>';
                content += '<div class="af2_slider_frage_bullet af2_mobile"></div>';
                content += '<input class="af2_slider_frage" ' + val + ' type="range" min="' + json.type_specifics.min + '" max="' + json.type_specifics.max + '" step="' + json.type_specifics.step + '">';
                content += '<div class="af2_slider_frage_minmax"><p>' + min + '</p><p>' + max + '</p></div>';
                if(json.type_specifics.manual == true){
                    content += '<div class="af2_slider_alternate_text_wrap">';
                        content += '<label class="range_text_box_label af2_mobile">' + json.type_specifics.text_manual + '</label>';
                        content += '<label class="range_text_box_label desktop">' + json.type_specifics.text_manual + '</label>';
                        content += '<div class="af2_slider_input_wrap '+rtl_type_class+'">';
                            content += slider_input_wrap_i;
                        content += '</div>';
                    content +='</div>'
                }
                content += '</div>';

                if(json.type_specifics.image != "" && json.type_specifics.image != undefined) content += '<div class="af2_slider_image_icon_wrapper desktop" style="margin: 0 auto 15px 30px; width: 120px; height: 120px; position: relative; padding: 15px;"><img style="max-width: 100%; max-height: 100%; min-width: 120px; width: 120px; min-height: 120px; height: 120px; object-fit: contain;" src="'+drawImage+'">';
                if(json.type_specifics.icon != "" && json.type_specifics.icon != undefined) content += '<div style="width: 15%; margin-left: 30px; padding: 15px;"class="af2_slider_image_icon_wrapper desktop"><i style="font-size: 90px" class="'+json.type_specifics.icon+'"></i>';


                content += '</div>';
                content += '</div>';
//
                content += '</div>';
            });
        });

    }
    else if(json.typ === 'af2_dateiupload')
    {
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">'+json.frontend_name+'</div><div class="af2_question_description desktop">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">'+json.frontend_name+'</div><div class="af2_question_description af2_mobile">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_dateiupload desktop"><div class="af2_dateiupload_inner" data-fragen="fileupload" data-mandatory="'+json.type_specifics.mandatory+'" data-max_count="'+json.type_specifics.max_count+'" data-max_size="'+json.type_specifics.max_size+'"><i class="fa fa-cloud-upload-alt"></i><div class="af2_dateiupload_desc">'+json.type_specifics.description+'</div></div></div>';
        content += '<div class="af2_dateiupload af2_mobile"><div class="af2_dateiupload_inner" data-fragen="fileupload" data-mandatory="'+json.type_specifics.mandatory+'" data-max_count="'+json.type_specifics.max_count+'" data-max_size="'+json.type_specifics.max_size+'"><i class="fa fa-cloud-upload-alt"></i><div class="af2_dateiupload_desc">'+json.type_specifics.description+'</div></div></div>';
    }
    else if(json.typ === 'af2_dropdown')
    {
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">'+json.frontend_name+'</div><div class="af2_question_description desktop">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">'+json.frontend_name+'</div><div class="af2_question_description af2_mobile">'+json.frontend_description+'</div></div>';
        content += '<select class="af2_dropdown_fragen custom-select custom-select-sm">';
        $.each(json.type_specifics.dropdown_options,function(i,t){
            if($.trim(t.value) == ''){
                content += '<option value="'+t.label+'">'+t.label+'</option>';
            }else{
                content += '<option value="'+t.value+'">'+t.label+'</option>';
            }
        })
        content += '</select>';
    }
    else if(json.typ === 'af2_adressfeld')
    {
        let mandatory = true;
        if(json.type_specifics.mapmandatory != undefined && json.type_specifics.mapmandatory == false) mandatory = false;
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">'+json.frontend_name+'</div><div class="af2_question_description desktop">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">'+json.frontend_name+'</div><div class="af2_question_description af2_mobile">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_adress_mapp_wrapper af2_mw_'+form.mapCount+'" data-mandatory="'+mandatory+'">';
            content += '<div class="af2_adress_map_input_wrapper">';
                content += '<div class="af2_adress_map_input_wrapper_wrap bl">';
                    content += '<div class="af2_adress_input_wrap size8 desktop"><label class="af2_ad_trans_tabel desktop">'+af2_frontend_ajax.strings.street+'</label><input class="af2_ad_trans desktop" style="width: 100%;" placeholder="" id="af2_adress_street" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size8 af2_mobile"><label class="af2_ad_trans_tabel af2_mobile">'+af2_frontend_ajax.strings.street+'</label><input class="af2_ad_trans af2_mobile" style="width: 100%;" placeholder="" id="af2_adress_street_" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size2 desktop"><label class="af2_ad_trans_tabel desktop">'+af2_frontend_ajax.strings.no+'</label><input class="af2_ad_trans desktop" style="width: 100%;" id="af2_adress_streetnum" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size2 af2_mobile"><label class="af2_ad_trans_tabel af2_mobile"">'+af2_frontend_ajax.strings.no+'</label><input class="af2_ad_trans af2_mobile" style="width: 100%;" id="af2_adress_streetnum_" type="text" autocomplete="off"/></div>';
                content += '</div>'
                content += '<div class="af2_adress_map_input_wrapper_wrap">';
                    content += '<div class="af2_adress_input_wrap size4 desktop"><label class="af2_ad_trans_tabel desktop">'+af2_frontend_ajax.strings.postcode+'</label><input class="af2_ad_trans desktop" style="width: 100%;" id="af2_adress_plz" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size4 af2_mobile"><label class="af2_ad_trans_tabel af2_mobile">'+af2_frontend_ajax.strings.postcode+'</label><input class="af2_ad_trans af2_mobile" style="width: 100%;" id="af2_adress_plz_" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size6 desktop"><label class="af2_ad_trans_tabel desktop">'+af2_frontend_ajax.strings.city+'</label><input class="af2_ad_trans desktop" style="width: 100%;" id="af2_adress_city" type="text" autocomplete="off"/></div>';
                    content += '<div class="af2_adress_input_wrap size6 af2_mobile"><label class="af2_ad_trans_tabel af2_mobile"">'+af2_frontend_ajax.strings.city+'</label><input class="af2_ad_trans af2_mobile" style="width: 100%;" id="af2_adress_city_" type="text" autocomplete="off"/></div>';
                content += '</div>'
            content += '</div>';
            content += '<div id="af2_adress_field" class="af2_address_field_"></div>';
        content += '</div>';
        form.increaseMapCount();
    }
    else if(json.typ === 'af2_terminbuchung') {
        if(json.type_specifics.termineventcontent == null) ;// SKIP!!!!!!!!
        content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">'+json.frontend_name+'</div><div class="af2_question_description desktop">'+json.frontend_description+'</div></div>';
        content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">'+json.frontend_name+'</div><div class="af2_question_description af2_mobile">'+json.frontend_description+'</div></div>';

        let c = '';
        c += '<div class="af2_terminbuchungs_wrapper">';
            c += '<div class="af2_datewrapper af2_terminbuchungs_wrap">';
                c += '<div class="af2_terminbuchung_datewrapper af2_datepicker af2_calender_wait--loading"></div>';
            c += '</div>';
            c += '<div class="af2_terminbuchungs_wrap">';
                c += '<div class="af2_terminbuchung_dur_wrap">';
                    c += '<h4 class="af2_terminbuchung_heading desktop">'+af2_frontend_ajax.strings.choosedurdot+'</h4>';
                    c += '<h4 class="af2_terminbuchung_heading af2_mobile">'+af2_frontend_ajax.strings.choosedurdot+'</h4>';
                    c += '<div class="af2_terminbuchung_durations">';
                        c += getTerminbuchungDurations($, json.type_specifics.termineventcontent, form);
                    c += '</div>';
                c += '</div>';
                c += '<div class="af2_terminbuchungs_ti_wrap">';
                    c += '<h4 class="af2_terminbuchung_heading desktop">'+af2_frontend_ajax.strings.choosetimedot+'</h4>';
                    c += '<h4 class="af2_terminbuchung_heading af2_mobile">'+af2_frontend_ajax.strings.choosetimedot+'</h4>';
                    //c += af2_create_timezone_dropdown(form);
                    c += '<div class="af2_terminbuchung_times">';
                    c += '</div>';
                c += '</div>';
            c += '</div>';
        c += '</div>';

        content += c;
    }
    form.firstQuestion = false;
    return content;
};

const getTerminbuchungDurations = ($, json, form) => {
    let cont = '';
    let size = json.dauer.length;
    let one = false;

    json.dauer.forEach((el, i) => {
        let hourString = 'Std.';
        let hourValue = '';
        let hourGap = ' ';
        let minuteString = 'Min.';
        let minuteValue = '';
        let minuteGap = ' ';
        const std = parseInt(el.std);
        const min = parseInt(el.min);

        if(std == 0) {
            hourValue = '';
            hourString = '';
            hourGap = '';
        }
        else hourValue = std.toString();

        if(min == 0) {
            minuteValue = '';
            minuteString = '';
            minuteGap = '';
        }
        else minuteValue = min.toString();

        const durationStr = `${hourValue}${hourGap}${hourString}${hourGap}${minuteValue}${minuteGap}${minuteString}`;

        const selectedClass = i == 0 ? 'af2_duration_selected' : '';
        cont += '<div id="terminbuchung_duration_'+terminbuchungslistener+'" data-itemc="'+i+'" data-min="'+min+'" data-std="'+std+'" class="af2_terminbuchung_duration '+selectedClass+'">'+durationStr+'</div>';

        if(i == 0) {
            form.lastTerminbuchungsObject.duration = durationStr;
            form.lastTerminbuchungsObject.duration_std = std;
            form.lastTerminbuchungsObject.duration_min = min;
            form.lastTerminbuchungsObject.duration_itemc = i;
        }

        terminbuchungslistener++;
    });

    return cont;
};

const putInThousands = (json, cont, $) => {
    let len = cont.length;
    let prom = $.Deferred();

    let ret = '';

    let times = parseInt(len / 3);

    let thousands = json.type_specifics.thousand;

    if (thousands == true)
    {
        if (len > 3)
        {
            let mod = len % 3;
            if (len % 3 === 0)
            {
                times--;
            }

            if (mod === 0)
            {
                mod = 3;
            }

            let schritt = 0;
            for (schritt = 1; schritt <= times; schritt++)
            {
                ret = af2_frontend_ajax.strings.dot + cont.substr(cont.length - schritt * 3, 3) + ret;

                if (schritt === times)
                {
                    ret = cont.substr(0, mod) + ret
                    return prom.resolve(ret);
                }
            }
        } else
        {
            return prom.resolve(cont);
        }
    } else
    {
        return prom.resolve(cont);
    }



    return prom.promise();
};

/**
 * Draws the content of a Kontaktformular
 *
 * @param $
 * @param json
 */
const af2DrawKontaktformular = ($, json, form) => {
    const queryStr = window.location.search.substr(1);
    const queryArr = queryStr.split('&');

    let content = '';



    let tracking = json.tracking_code;
    if(tracking != undefined && tracking != '')
        content += '<div style="display: none;">'+tracking+'</div>';


    content += '<div class="af2_question_heading_wrapper desktop"><div class="af2_question_heading desktop">' + json.frontend_name + '</div><div class="af2_question_description desktop">' + json.frontend_description + '</div></div>';
    content += '<div class="af2_question_heading_wrapper af2_mobile"><div class="af2_question_heading af2_mobile">' + json.frontend_name + '</div><div class="af2_question_description af2_mobile">' + json.frontend_description + '</div></div>';

    $.each(json.questions, (i, el) => {
        let required = '';
        let label = el.label;
        let placeholder = el.placeholder;
        let el_id = el.id;
        let iconval = el.icon;

        let rtl_type_class = form.rtl_layout == true ? 'af2_rtl_layout' : '';

        let icon = iconval != null && iconval.trim() != '' ? '<div class="af2_question_cf_text_type_icon '+rtl_type_class+'"><i class="'+iconval+'"></i></div>' : '';
        let text_type_class = icon == '' ? 'af2_text_type_' : 'af2_text_type '+rtl_type_class;

        if (el.required == 'true' || el.required == true)
        {
            required = ' *';
        }
        if(label == undefined || label == 'undefined' || label == null) label = '';
        if(label == undefined || label.trim() == '') placeholder += required;
        else label += required;
        content += '<div id="' + i + '" class="af2_question">';



        let el_value = '';

        queryArr.forEach(el => {
            const queArr = el.split('=');
            if(queArr[0] == el_id) {
                el_value = decodeURIComponent(queArr[1]);
            }
        });

        el_value = el_value.replaceAll('+', ' ');


        if (el.typ.includes('text_type_'))
        {
            if (el.typ.includes('_name'))
            {
                content += '<div class="af2_question_text_type_wrapper af2_question_wrapper af2_question_wrapper_'+i+'">';
                if(label.trim() != '' )
                    content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
                content += '<div class="af2_question_cf_text_type_wrapper">';
                content += icon;
                content += '<input type="text" name="'+el_id+'" id="'+el.id+'" class="'+text_type_class+' " placeholder="' + placeholder + '" autofill="name" value="'+el_value+'">';
                content += '</div>';
                content += '</div>';
            } else if (el.typ.includes('_mail'))
            {
                content += '<div class="af2_question_text_type_wrapper af2_question_wrapper  af2_question_wrapper_'+i+'">';
                if(label.trim() != '' )
                    content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
                content += '<div class="af2_question_cf_text_type_wrapper">';
                content += icon;
                content += '<input type="text" name="'+el_id+'" id="'+el.id+'" autofill="email" class="'+text_type_class+'" placeholder="' + placeholder + '" value="'+el_value+'">';
                content += '</div>';
                content += '</div>';
            } else if (el.typ.includes('_phone'))
            {
                if(el.typ.includes('_verification')) {
                    required = ' *';
                    if(label == undefined || label == 'undefined' || label == null) label = '';
                    if(label == undefined || label.trim() == '') placeholder += required;
                    else label += required;

                    if(placeholder == 'undefined') {
                        placeholder = "";
                    }

                    content += '<div class="af2_question_text_type_wrapper af2_question_wrapper af2_question_wrapper_'+i+'">';
                    if(label.trim() != '' )
                        content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
                    content += '<div class="af2_question_cf_text_type_wrapper">';
                    content += icon;
                    content += '<input type="tel" name="'+el_id+'" id="'+el.id+'" autofill="tel" class="'+text_type_class+' phone_type" placeholder="' + placeholder + '" value="'+el_value+'">';
                    content += '</div>';
                    content += '</div>';

                    form.hasVerification = true;
                    form.verifictationId = el_id;
                    form.verifictationDataId = form.neededContent;
                }
                else {

                    if(placeholder == 'undefined') {
                        placeholder = "";
                    }

                    content += '<div class="af2_question_text_type_wrapper af2_question_wrapper af2_question_wrapper_'+i+'">';
                    if(label.trim() != '' )
                        content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
                    content += '<div class="af2_question_cf_text_type_wrapper">';
                    content += icon;
                    content += '<input type="tel" name="'+el_id+'" id="'+el.id+'" autofill="tel" class="'+text_type_class+' phone_type" placeholder="' + placeholder + '" value="'+el_value+'">';
                    content += '</div>';
                    content += '</div>';
                }
            } else
            {
                content += '<div class="af2_question_text_type_wrapper af2_question_wrapper af2_question_wrapper_'+i+'">';
                if(label.trim() != '' )
                    content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
                content += '<div class="af2_question_cf_text_type_wrapper">';
                content += icon;
                content += '<input type="text" name="'+el_id+'" id="'+el.id+'" class="'+text_type_class+'" placeholder="' + placeholder + '" value="'+el_value+'">';
                content += '</div>';
                content += '</div>';
            }
        } else if (el.typ.includes('checkbox'))
        {
            content += '<div class="af2_question_wrapper">';
            content += '<div class="af2_question_checkbox_type_wrapper">';
            content += '<input type="checkbox" data-uid="'+el_id+'" id="af2_checkbox_' + i + '" class="af2_checkbox_type"><div class="af2_question_text"><label for="af2_checkbox_' + i + '" class="af2_question_cb_label">' + el.text + required + '</label></div>';
            content += '</div>';
            content += '</div>';
        } else if (el.typ.includes('salutation'))
        {
            content += '<div class="af2_question_text_type_wrapper af2_question_wrapper">';
            if(label.trim() != '' )
                content += '<div class="af2_question_text '+rtl_type_class+'"><p class="af2_question_label desktop">' + label + '</p><p class="af2_question_label af2_mobile">' + label + '</p></div>';
            if(form.rtl_layout == true) content += '<div style="display: flex; align-items: center;">';
            else content += '<div style="display: flex; justify-content: left; align-items: center;">';
            let allowSalutationCompany = true;
            let allowSalutationMale = true;
            let allowSalutationFemale = true;
            let allowSalutationDivers = true;

            if(el.allowSalutationCompany == 'true') el.allowSalutationCompany = true;
            else if(el.allowSalutationCompany == 'false') el.allowSalutationCompany = false;
            if(el.allowSalutationMale == 'true') el.allowSalutationMale = true;
            else if(el.allowSalutationMale == 'false') el.allowSalutationMale = false;
            if(el.allowSalutationFemale == 'true') el.allowSalutationFemale = true;
            else if(el.allowSalutationFemale == 'false') el.allowSalutationFemale = false;
            if(el.allowSalutationDivers == 'true') el.allowSalutationDivers = true;
            else if(el.allowSalutationDivers == 'false') el.allowSalutationDivers = false;

            if(el.allowSalutationCompany != undefined && el.allowSalutationCompany != null && el.allowSalutationCompany == false) allowSalutationCompany = false;
            if(el.allowSalutationMale != undefined && el.allowSalutationMale != null && el.allowSalutationMale == false) allowSalutationMale = false;
            if(el.allowSalutationFemale != undefined && el.allowSalutationFemale != null && el.allowSalutationFemale == false) allowSalutationFemale = false;
            if(el.allowSalutationDivers != undefined && el.allowSalutationDivers != null && el.allowSalutationDivers == false) allowSalutationDivers = false;

            maleChecked = el_value.toLocaleLowerCase() == 'herr' ? 'checked' : '';
            femaleChecked = el_value.toLocaleLowerCase() == 'frau' ? 'checked' : '';
            diversChecked = el_value.toLocaleLowerCase() == 'divers' ? 'checked' : '';
            companyChecked = el_value.toLocaleLowerCase() == 'firma' ? 'checked' : '';
            if(form.rtl_layout == true) {
                if(allowSalutationMale) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="male_'+i+'" value="Herr" '+maleChecked+'/><label for="male_'+i+'" class="af2_radio_label" style="margin-left: 25px;">'+af2_frontend_ajax.strings.mr+'</label>';
                if(allowSalutationFemale) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="female_'+i+'" value="Frau" '+femaleChecked+'/><label for="female_'+i+'" class="af2_radio_label" style="margin-left: 25px;">'+af2_frontend_ajax.strings.mrs+'</label>';
                if(allowSalutationDivers) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="divers_'+i+'" value="Divers" '+diversChecked+'/><label for="divers_'+i+'" class="af2_radio_label" style="margin-left: 25px;">'+af2_frontend_ajax.strings.diverse+'</label>';
                if(allowSalutationCompany) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="company_'+i+'" value="Firma" '+companyChecked+'/><label class="af2_radio_label" for="company_'+i+'">'+af2_frontend_ajax.strings.company+'</label>';
            }
            else {
                if(allowSalutationMale) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="male_'+i+'" value="Herr" '+maleChecked+'/><label for="male_'+i+'" class="af2_radio_label" style="margin-right: 25px;">'+af2_frontend_ajax.strings.mr+'</label>';
                if(allowSalutationFemale) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="female_'+i+'" value="Frau" '+femaleChecked+'/><label for="female_'+i+'" class="af2_radio_label" style="margin-right: 25px;">'+af2_frontend_ajax.strings.mrs+'</label>';
                if(allowSalutationDivers) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="divers_'+i+'" value="Divers" '+diversChecked+'/><label for="divers_'+i+'" class="af2_radio_label" style="margin-right: 25px;">'+af2_frontend_ajax.strings.diverse+'</label>';
                if(allowSalutationCompany) content += '<input style="margin-right: 5px;" type="radio" name="af_salutation_'+i+'" data-uid="'+el_id+'" id="company_'+i+'" value="Firma" '+companyChecked+'/><label class="af2_radio_label" for="company_'+i+'">'+af2_frontend_ajax.strings.company+'</label>';
            }
            content += '</div>';
            content += '</div>';

        } else if (el.typ.includes('google_recaptcha'))
        {
            if (el.site_key.length > 0 && el.site_key != '') {
                content += '<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>';
                content += '<div class="af2_question_wrapper">';
                if (af2_isMobile()) {
                    content += '<div id="' + el.id + '" style="transform:scale(0.75);-webkit-transform:scale(0.785);transform-origin:0 0;-webkit-transform-origin:0 0;" class="g-recaptcha"></div>';
                } else {
                    content += '<div id="' + el.id + '"></div>';
                }

                content += '<script type="text/javascript">var onloadCallback=function() {let _e = document.querySelector(".af2_form_carousel").style.height;const _h = parseInt(_e) + 80; document.querySelector(".af2_form_carousel").style.height= _h + "px"; grecaptcha.render("' + el.id + '",{"sitekey" : "' + el.site_key + '","callback":callback});document.querySelector(".af2_submit_button").setAttribute("disabled", true);};var callback=function() {document.querySelector(".af2_submit_button").removeAttribute("disabled");}</script>';
                content += '</div>';

                // scale recaptcha for responsive
                setTimeout(() => {
                    if (af2_isMobile()) {
                        var width = $('.g-recaptcha').parent().width();
                        if (width < 302) {
                            var scale = width / 302;
                            $('.g-recaptcha').css('transform', 'scale(' + scale + ')');
                            $('.g-recaptcha').css('-webkit-transform', 'scale(' + scale + ')');
                            $('.g-recaptcha').css('transform-origin', '0 0');
                            $('.g-recaptcha').css('-webkit-transform-origin', '0 0');
                        }
                    }
                });
            }
        } else if (el.typ.includes('html_content')) {
            content += '<div class="af2_form_html_content">'+el.html_content+'</div>';
        }

        content += '</div>';
    });

    content += '<div class="af2_question_wrapper">';
    
    content += '<div class="af2_submit_wrapper">';
        content += '<button type="button" class="af2_submit_button">';
        if(form.rtl_layout == true) {
            content += '<span class="af2_submit_button__text">'+json.sendButtonLabel+'<i class="fa fa-paper-plane" style="margin-right: 10px;"></i></span>';
        }
        else {
            content += '<span class="af2_submit_button__text"><i class="fa fa-paper-plane" style="margin-right: 10px;"></i>'+json.sendButtonLabel+'</span>';
        }
        content += '</button>'
    content += '</div>';
    //content += '<div class="af2_submit_wrapper"><input class="af2_submit_button" value="' + json.sendButtonLabel + '" type="submit"></div>';
    content += '</div>';

    return content;
};

const af2_isMobile = () => {
    const winWidth = jQuery(window).width();

    if(winWidth < 700){
        return true;
    }else{
        return false;
    }
}

/**
 * Process Answers for a question
 *
 * @param $
 * @param answers
 * @returns {string}
 */
const af2ProcessAnswers = ($, bonusClass, answers,desktop_layout,mobile_layout) => {
    let content = '';
    $.each(answers, (i, el) => {
        let answer_img = '';
        let answer_mob_img = '';
        if (el.icon_type === 'url')
        {
            if(desktop_layout == 'list' || desktop_layout == 'list2'){
                answer_img = '<div class="af2_answer_card desktop"><div class="af2_answer_image_wrapper"><img class="af2_answer_image pic" src="' + el.icon + '" alt="answer_image"></div><div class="af2_answer_text desktop">' + el.text + '</div></div>';
            }else{
                answer_img = '<div class="af2_answer_card desktop"><div class="af2_answer_image_wrapper"><img class="af2_answer_image pic" src="' + el.icon + '" alt="answer_image"></div></div><div class="af2_answer_text desktop">' + el.text + '</div>';
            }
            
            if(mobile_layout == 'grid'){
                answer_mob_img = '<div class="af2_answer_card af2_mobile"><div class="af2_answer_image_wrapper af2_mobile"><img class="af2_answer_image pic" src="' + el.icon + '" alt="answer_image"></div></div><div class="af2_answer_text af2_mobile">' + el.text + '</div>';
            }else{
                answer_mob_img = '<div class="af2_answer_card af2_mobile"><div class="af2_answer_image_wrapper af2_mobile"><img class="af2_answer_image pic" src="' + el.icon + '" alt="answer_image"></div><div class="af2_answer_text af2_mobile">' + el.text + '</div></div>';
            }
            
            
        } else if (el.icon_type === 'font-awesome')
        {
            
            if(desktop_layout == 'list' || desktop_layout == 'list2'){
                answer_img = '<div class="af2_answer_card desktop"><div class="af2_answer_image_wrapper"><i class="' + el.icon + ' fa-3x"></i></div><div class="af2_answer_text desktop">' + el.text + '</div></div>';
            }else{
                answer_img = '<div class="af2_answer_card desktop"><div class="af2_answer_image_wrapper"><i class="' + el.icon + ' fa-5x"></i></div></div><div class="af2_answer_text desktop">' + el.text + '</div>';
            }
            
            if(mobile_layout == 'grid'){
                answer_mob_img = '<div class="af2_answer_card af2_mobile"><div class="af2_answer_image_wrapper af2_mobile"><i class="' + el.icon + ' fa-4x"></i></div></div><div class="af2_answer_text af2_mobile">' + el.text + '</div>';
            }else{
                answer_mob_img = '<div class="af2_answer_card af2_mobile"><div class="af2_answer_image_wrapper af2_mobile"><i class="' + el.icon + ' fa-2x"></i></div><div class="af2_answer_text af2_mobile">' + el.text + '</div></div>';
            }
        }

        content += '<div id="' + i + '" class="af2_answer '+bonusClass+' desktop">';
        content += answer_img;
        content += '</div>';

        content += '<div id="' + i + '" class="af2_answer '+bonusClass+' af2_mobile">';
        content += answer_mob_img;
        content += '</div>';
    });

    return content;
};


/**
 * Performing and handling a Data-request
 *
 * @param $
 * @param formSelector
 * @param selector
 * @param dataids
 */
const af2HandleRequest = ($, formSelector, selector, dataids, form) => {
    const result = requestData($, dataids, form);

    /**
     * When it had no error -> Throw the Event and set the data into the Array
     */
    result.done((json) => {

        /** Setting up Data **/
        const keys = Object.keys(json);

        $.each(keys, (i, el) => {
            let newJson = json[el];

            if(newJson.type_specifics != null) {
                const keysofjson = Object.keys(newJson.type_specifics);

                $.each(keysofjson, (j, ele) => {
                    if(newJson.type_specifics[ele] == 'true') newJson.type_specifics[ele] = true;
                    if(newJson.type_specifics[ele] == 'false') newJson.type_specifics[ele] = false;

                    if(ele == 'center' && newJson.type_specifics[ele].lat != null && newJson.type_specifics[ele].lng != null) {
                        newJson.type_specifics[ele].lat = Number(newJson.type_specifics[ele].lat);
                        newJson.type_specifics[ele].lng = Number(newJson.type_specifics[ele].lng);
                    }
                });
            }

            datas[el] = json[el];
        });

        /** Throwing out event **/
        let finishedEvent = jQuery.Event('loadedData');
        finishedEvent.dataids = dataids;
        $(selector).trigger(finishedEvent);
    });
    /**
     * When it has an Error -> just send the Error out and fill the data with 'ERROR'
     */
    result.fail((error) => {
        af2ThrowError($, $(formSelector), error);
    });
};

/**
 * Request all data needet to process the Formular in future
 */
const requestData = ($, dataids, form) => {
    
    const prom = $.Deferred();
    $.ajax({
        url: af2_frontend_ajax.ajax_url,
        type: "GET",
        data: {
            _ajax_nonce: af2_frontend_ajax.nonce,
            action: 'af2_request_data',
            ids: dataids
        },
        success: (answer) => {
            if (answer.indexOf('ERROR') != -1)
            {
                if(answer != 'ERRORX')
                {
                    // REQUEST ERROR EMAIL
                    /*
                    if(form.errormail == true) {
                        //send_errormail($, "Intern - " + answer);

                        if(answer == af2_frontend_ajax.strings.error_01)
                        {prom.reject(af2_frontend_ajax.strings.fehler_admin+'<a href="'+af2_frontend_ajax.strings.help_url+'" target="_blank">'+af2_frontend_ajax.strings.help+'</a>');
                        }
                        else prom.reject(af2_frontend_ajax.strings.fehler_find);
                    }
                    else*/
                    if(answer == af2_frontend_ajax.strings.error_01) {
                        prom.reject(af2_frontend_ajax.strings.fehler_admin+'<a href="'+af2_frontend_ajax.strings.help_url+'" target="_blank">'+af2_frontend_ajax.strings.help+'</a>');
                    }
                    else prom.reject(af2_frontend_ajax.strings.fehler_find);
                }
                else prom.reject(af2_frontend_ajax.strings.fehler_find);
            } 
            else
            {
                let answerJson = JSON.parse(answer);
                prom.resolve(answerJson);
            }
        },
        error: (xhr, status, error) => {
            // REQUEST ERROR EMAIL
            if(form.errormail == true) {
                //send_errormail($, "REQUEST - " +  xhr.status + ' - ' + xhr.statusText + ' - ' + status + ' - ' + error+ ' :--');     
            }
            prom.reject(af2_frontend_ajax.strings.fehler_admin+'<a href="'+af2_frontend_ajax.strings.help_url+'" target="_blank">'+af2_frontend_ajax.strings.help+'</a>');
        }
    });

    return prom.promise();
};

const send_errormail = ($, errorcode) => {
    /**const currentURL = window.location.href;
    $.ajax({
        url: af2_frontend_ajax.ajax_url,
        type: "GET",
        data: {
            _ajax_nonce: af2_frontend_ajax.nonce,
            action: 'af2_send_error_mail',
			errorcode: errorcode,
			currentURL: currentURL,
            errortype: 'intern'
        },
        success: (answer) => {

        },
        error: () => {

        }
    });**/
};

/**
 * Find out if this attribute is in the array
 *
 * @param $
 * @param attribute
 * @param arr
 */
const af2CompareAttributeInArray = ($, attribute, arr) => {
    const prom = $.Deferred();

    $(arr).each((i, el) => {
        if (el === attribute)
        {
            prom.resolve();
        }
    });

    return prom.promise();
};

/**
 * Function to append stylings
 */
const af2LoadStyling = ($, id, formSelector, cb) => {
    /** Overwrite styling **/
    af2OverwriteStylings($, datas[id].styling).done((styling) => {
        /** Generate the styling **/
        if(styling == null) { 
            cb(); 
            return;
        }
        else {
            af2GenerateStylingContent($, formSelector, styling).done((style) => {
                $('head').append(style);
                cb();
            });
        }
    });
};

/**
 * Merges the new Styling with the basic one
 *
 * @param $
 * @param styling
 * @returns json
 */
const af2OverwriteStylings = ($, styling) => {
    const prom = $.Deferred();
    let newStyling = af2Styles;

    if(styling == null) prom.resolve(null);
    
    // Copy of the basic styling
    const keys = Object.keys(styling);
    $(keys).each((i, e) => {
        $.each(styling[e], (j, el) => {
            $.each(newStyling[e], (k, ele) => {
                if (ele.attribute === el.attribute)
                {
                    if (ele.special_class === el.special_class && ele.special_state === el.special_state && ele.special_extra === el.special_extra)
                    {
                        newStyling[e][k].value = styling[e][j].value;
                    }
                }
            });
        });

        if (i === keys.length - 1)
        {
            prom.resolve(newStyling);
        }
    });

    return prom.promise();
};

/**
 * Generate the content for the styling
 *
 * @param $
 * @param formSelector
 * @param styling
 * @returns {*}
 */
const af2GenerateStylingContent = ($, formSelector, styling) => {
    const prom = $.Deferred();
    let content = '';

    /** Create wrapper **/
    content += '<style>';

    const keys = Object.keys(styling);

    $(keys).each((i) => {
        let desktopList = [];
        let mobileList = [];
        let dateList = [];
        let af2DisabledList = [];
        let focusList = [];
        let wtList = [];
        let mtList = [];
        let formClassList = [];
        content += formSelector + ' .' + keys[i] + '{';

        $.each(styling[keys[i]], (j, e) => {
            if (e.special_class !== undefined)
            {
                if (e.special_class === "desktop")
                    desktopList.push(e);
                else if (e.special_class === "af2_mobile")
                    mobileList.push(e);
                else if (e.special_class === "af2_disabled")
                    af2DisabledList.push(e);
                else if (e.special_class === "af2_datepicker")
                    dateList.push(e);
                else if (e.special_class === "form_class")
                    formClassList.push(e);

            } else if (e.special_state !== undefined)
            {
                if (e.special_state === "focus")
                    focusList.push(e);
            } else if (e.special_extra !== undefined)
            {
                if (e.special_extra === "-webkit-slider-thumb")
                    wtList.push(e);
                else if (e.special_extra === "-moz-range-thumb")
                    mtList.push(e);
            } else
            {
                content += e.attribute + ':' + e.value + ';';
            }
        });

        content += '}';

        /** Desktop **/
        if (desktopList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + '.desktop {';
        }
        $.each(desktopList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (desktopList.length > 0)
        {
            content += '}';
        }

        formClassFocusList = [];

        /** formClassList **/
        if (formClassList.length > 0)
        {
            content += formSelector.replace('#', '.') + '.' + keys[i] + ' {';
        }
        $.each(formClassList, (j, e) => {
            if(e.special_state !== undefined)
                formClassFocusList.push(e);
            else
                content += e.attribute + ':' + e.value + ';';
        });
        if (formClassList.length > 0)
        {
            content += '}';
        }

         /** formClassList focus **/
         if (formClassFocusList.length > 0)
         {
             content += formSelector.replace('#', '.') + '.' + keys[i] + ':focus {';
         }
         $.each(formClassFocusList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
         });
         if (formClassFocusList.length > 0)
         {
             content += '}';
         }

        /** Mobile **/
        if (mobileList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + '.af2_mobile {';
        }
        $.each(mobileList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (mobileList.length > 0)
        {
            content += '}';
        }

        /** af2Disabled **/
        if (af2DisabledList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + '.af2_disabled {';
        }
        $.each(af2DisabledList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (af2DisabledList.length > 0)
        {
            content += '}';
        }

        /** Datepciker styling **/
        if (dateList.length > 0)
        {
            $.each(dateList, (j, e) => {
                content += formSelector + ' .af2-datepicker .' + e.sub_class + ' {';
                content += e.attribute + ':' + e.value + ';';
                content += '}';
                content += formSelector + ' .af2_terminbuchung_datewrapper .' + e.sub_class + ' {';
                content += e.attribute + ':' + e.value + ';';
                content += '}';
            });
        }

        /** :focus **/
        if (focusList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + ':focus {';
        }
        $.each(focusList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (focusList.length > 0)
        {
            content += '}';
        }

        /** moz **/
        if (mtList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + '::-moz-range-thumb {';
        }
        $.each(mtList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (mtList.length > 0)
        {
            content += '}';
        }

        /** web **/
        if (wtList.length > 0)
        {
            content += formSelector + ' .' + keys[i] + '::-webkit-slider-thumb {';
        }
        $.each(wtList, (j, e) => {
            content += e.attribute + ':' + e.value + ';';
        });
        if (wtList.length > 0)
        {
            content += '}';
        }

        if (i === keys.length - 1)
        {
            prom.resolve(content);
        }
    });

    /** Close wrapper **/
    content += '</style>';

    return prom.promise();
};

/**
 * Throw an Error to the given Selector
 *
 * @param $
 * @param selector
 * @param errortext
 */
const af2ThrowError = ($, selector, errortext) => {
    selector.after('<p class="af2_loading_error">' + errortext + '</p>');
};


const af2ThrowLoadingSuccess = ($, selector, html) => {
    selector.append(html);
};
const af2ThrowLoadingError = ($, selector, html) => {
    selector.append(html);
};

function GMap($, neededContent, actualData, formSelector, setHeight, form) {
    this.$ = $;
    this.formSelector = formSelector;

    this.mapCount = form.mapCount;
    this.markers = [];
    this.form = form;

    this.selector = this.formSelector + ' .af2_adress_mapp_wrapper.af2_mw_'+(this.mapCount-1);
    this.selectorMap = this.$(this.selector + ' #af2_adress_field')[0];

    this.mandatory = $(this.selector).data('mandatory');

    const fact = neededContent == undefined ? actualData : neededContent;

    const zoomlevel = datas[fact].type_specifics.zoomlevel == undefined ? 8 : parseInt(datas[fact].type_specifics.zoomlevel);

    const center = datas[fact].type_specifics.center == undefined ? { lat: -34.397, lng: 150.644 } : datas[fact].type_specifics.center;

    this.map = new extraParms.maps.Map(this.selectorMap, {
        center: center,
        zoom: zoomlevel,
        mapTypeId: "roadmap",
        mapTypeControlOptions: { mapTypeIds: [] },
        disableDefaultUI: true,
    });

    this.autocomplete = new extraParms.maps.places.Autocomplete(
        $(selector + ' input#af2_adress_street')[0], {types: ["geocode"]}
    );
    this.autocomplete2 = new extraParms.maps.places.Autocomplete(
        $(selector + ' input#af2_adress_street_')[0], {types: ["geocode"]}
    );

    this.form.setLastAddrObject("");

    if(this.mandatory == false){
        this.$(this.formSelector + ' .af2_form_foward_button').removeClass('af2_disabled');
        this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
    }

    

    this.fillInAdress = () => {
        const place = this.autocomplete.getPlace();
        let street_number = '';
        let route = '';
        let postal_code = '';
        let locality = '';
        $(this.selector + ' #af2_adress_streetnum').val('');
        $(this.selector + ' #af2_adress_street').val('');
        $(this.selector + ' #af2_adress_plz').val('');
        $(this.selector + ' #af2_adress_city').val('');
        place.address_components.forEach((el) => {
            const adressType = el.types[0];
            const val = el.long_name;
            switch(adressType) {
                case 'street_number': {
                    $(this.selector + ' #af2_adress_streetnum').val(val);
                    street_number = val;
                    break;
                }
                case 'route': {
                    $(this.selector + ' #af2_adress_street').val(val);
                    route = val;
                    break;
                }
                case 'postal_code': {
                    $(this.selector + ' #af2_adress_plz').val(val);
                    postal_code = val;
                    break;
                }
                case 'locality': {
                    $(this.selector + ' #af2_adress_city').val(val);
                    locality = val;
                    break;
                }
                default: break;
            }
            //console.log(adressType + ' - ' + val);
        });
        let clean = true;
        if(street_number == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
        if(route == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_street').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
        if(postal_code == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_plz').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
        if(locality == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_city').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
        if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
    
        this.markers.forEach((marker) => {
            marker.setMap(null);
        });
        this.markers = [];
    
        const icon = {
            url: place.icon,
            size: new extraParms.maps.Size(71, 71),
            origin: new extraParms.maps.Point(0, 0),
            anchor: new extraParms.maps.Point(17, 34),
            scaledSize: new extraParms.maps.Size(25, 25),
        };
    
    
        let mark = new extraParms.maps.Marker({
            title: place.name, position: place.geometry.location,
        });
        mark.setMap(this.map);
        this.markers.push(mark);
    
        this.map.setCenter(place.geometry.location);
        this.map.setZoom(16);
    
        this.form.setLastAddrObject(route + ' ' + street_number + ', ' + postal_code + ' ' + locality);
    }

    this.fillInAdress2 = () => {
        const place = this.autocomplete2.getPlace();
        let street_number = '';
        let route = '';
        let postal_code = '';
        let locality = '';
        $(this.selector + ' #af2_adress_streetnum_').val('');
        $(this.selector + ' #af2_adress_street_').val('');
        $(this.selector + ' #af2_adress_plz_').val('');
        $(this.selector + ' #af2_adress_city_').val('');
        place.address_components.forEach((el) => {
            const adressType = el.types[0];
            const val = el.long_name;
            switch(adressType) {
                case 'street_number': {
                    $(this.selector + ' #af2_adress_streetnum_').val(val);
                    street_number = val;
                    break;
                }
                case 'route': {
                    $(this.selector + ' #af2_adress_street_').val(val);
                    route = val;
                    break;
                }
                case 'postal_code': {
                    $(this.selector + ' #af2_adress_plz_').val(val);
                    postal_code = val;
                    break;
                }
                case 'locality': {
                    $(this.selector + ' #af2_adress_city_').val(val);
                    locality = val;
                    break;
                }
                default: break;
            }
            //console.log(adressType + ' - ' + val);
        });
        let clean = true;
        if(street_number == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
        if(route == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_street_').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
        if(postal_code == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
        if(locality == '') {
            clean = false;
            this.$(this.selector + ' #af2_adress_city_').css('border-color', 'red');
            if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
        } else this.$(this.selector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
        if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');

        this.markers.forEach((marker) => {
            marker.setMap(null);
        });
        this.markers = [];

        const icon = {
            url: place.icon,
            size: new extraParms.maps.Size(71, 71),
            origin: new extraParms.maps.Point(0, 0),
            anchor: new extraParms.maps.Point(17, 34),
            scaledSize: new extraParms.maps.Size(25, 25),
        };


        let mark = new extraParms.maps.Marker({
            title: place.name, position: place.geometry.location,
        });
        mark.setMap(this.map);
        this.markers.push(mark);

        this.map.setCenter(place.geometry.location);
        this.map.setZoom(16);

        this.form.setLastAddrObject(route + ' ' + street_number + ', ' + postal_code + ' ' + locality);
    }

    this.triggersDesktop = () => {
        $(this.selector + ' #af2_adress_streetnum').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum').val();
            const street = $(this.selector + ' #af2_adress_street').val();
            const plz = $(this.selector + ' #af2_adress_plz').val();
            const city = $(this.selector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_street').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum').val();
            const street = $(this.selector + ' #af2_adress_street').val();
            const plz = $(this.selector + ' #af2_adress_plz').val();
            const city = $(this.selector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street').css('border-color', 'red');
                if(this.mandatory == true)  this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_plz').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum').val();
            const street = $(this.selector + ' #af2_adress_street').val();
            const plz = $(this.selector + ' #af2_adress_plz').val();
            const city = $(this.selector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_city').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum').val();
            const street = $(this.selector + ' #af2_adress_street').val();
            const plz = $(this.selector + ' #af2_adress_plz').val();
            const city = $(this.selector + ' #af2_adress_city').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street').css('border-color', 'red');
                if(this.mandatory == true)  this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.desktop').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.desktop').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
    }

    this.triggersMobile = () => {
        $(this.selector + ' #af2_adress_streetnum_').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum_').val();
            const street = $(this.selector + ' #af2_adress_street_').val();
            const plz = $(this.selector + ' #af2_adress_plz_').val();
            const city = $(this.selector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'red');
                if(this.mandatory == true)this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_street_').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum_').val();
            const street = $(this.selector + ' #af2_adress_street_').val();
            const plz = $(this.selector + ' #af2_adress_plz_').val();
            const city = $(this.selector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'red');
                if(this.mandatory == true)  this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_plz_').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum_').val();
            const street = $(this.selector + ' #af2_adress_street_').val();
            const plz = $(this.selector + ' #af2_adress_plz_').val();
            const city = $(this.selector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city_').css('border-color', 'red');
                if(this.mandatory == true)  this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
        $(this.selector + ' #af2_adress_city_').on('input', (ev) => {
            const streetnum = $(this.selector + ' #af2_adress_streetnum_').val();
            const street = $(this.selector + ' #af2_adress_street_').val();
            const plz = $(this.selector + ' #af2_adress_plz_').val();
            const city = $(this.selector + ' #af2_adress_city_').val();

            let clean = true;
            if(streetnum == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_streetnum_').css('border-color', 'rgba(51,51,51,0.12)');
            if(street == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_street_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_street_').css('border-color', 'rgba(51,51,51,0.12)');
            if(plz == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'red');
                if(this.mandatory == true) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_plz_').css('border-color', 'rgba(51,51,51,0.12)');
            if(city == '') {
                clean = false;
                this.$(this.selector + ' #af2_adress_city_').css('border-color', 'red');
                if(this.mandatory == true)  this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').addClass('af2_disabled');
            } else this.$(this.selector + ' #af2_adress_city_').css('border-color', 'rgba(51,51,51,0.12)');
            if(clean) this.$(this.formSelector + ' .af2_form_foward_button.af2_mobile').removeClass('af2_disabled');
            this.form.setLastAddrObject( street + ' ' + streetnum + ', ' + plz + ' ' + city);
        });
    }

    setTimeout(() => {
        autocomplete.setFields(["address_component", "geometry"]);
        autocomplete.addListener("place_changed", this.fillInAdress);
        autocomplete2.setFields(["address_component", "geometry"]);
        autocomplete2.addListener("place_changed", this.fillInAdress2);
    }, 1000);

    setHeight();

    this.triggersDesktop();
    this.triggersMobile();
}



jQuery(document).ready(($) => {
    if($('.af2_form_wrapper').length > 0){
            af2_init($);  
    }

    document.fonts.onloadingdone = (fontFaceSetEvent) => {
        $('.af2_form_wrapper').trigger('af2_loaded_font', []);
    };
    
    $(document).on('click', '.iti__flag-container', function() { 
        var countryCode = $('.iti__selected-flag').attr('title');
        countryCode = countryCode.replace(/[^0-9]/g,'')
        $('#telefon').val("");
        $('#telefon').val("+"+countryCode+" "+ $('#telefon').val());
    });

    $(document).on("input", '.iti--allow-dropdown #telefon', function(e){
        let value = e.currentTarget.value;
        let countryCode = $('.iti__selected-flag').attr('title');
        countryCode = countryCode.replace(/[^0-9]/g,'');
        if( value == '+'+countryCode) return false;
        if( value.indexOf('+'+countryCode) == -1 ){
            if( '+'+countryCode.slice(0,countryCode.length-1) == value ){
                e.currentTarget.value = "+"+countryCode+" ";
            }else{
                e.currentTarget.value = "+"+countryCode+" "+ value;
            }
        }
    });
});

const af2_deepCopyArray = (arr) => {
    let newArr = [];
  
    arr.forEach((el, i) => {
      if (Array.isArray(el)) newArr.push(af2_deepCopyArray(el));
      else if (typeof el === 'object') newArr.push(af2_deepCopyObject(el));
      else newArr.push(el);
    });
  
    return newArr;
  }
  
  const af2_deepCopyObject = (obj) => {
    let newObj = {};
      
    for(let [key, val] of Object.entries(obj)){
        if(Array.isArray(val)) newObj[key] = af2_deepCopyArray(val);
      else if (typeof val === 'object') newObj[key] = af2_deepCopyObject(val);
      else newObj[key] = val;
    }
    
    return newObj;
  }


function af2_convertTZ(date, tzString) {
    return new Date((typeof date === "string" ? new Date(date) : date).toLocaleString("en-US", {timeZone: tzString}));   
}

function af2_returnTimeZoneName() {
	return Intl.DateTimeFormat().resolvedOptions().timeZone;
}

function af2_getTimeZoneNameRegion() {
	let str = Intl.DateTimeFormat().resolvedOptions().timeZone;
  
    return str.split('/')[0];
}

function af2_getTodayStandard() {
    return af2_convertTZ(new Date(), 'Europe/Amsterdam');
}

function af2_convertMinutesToHoursAndMinutes(num) {
    let number = Math.abs(num);
    let hours = number/60;
    let rHours = Math.floor(hours);
    let minutes = (hours - rHours) * 60;
    let rMinutes = Math.round(minutes);

    rHours = (rHours < 10 ? '0' : '') + rHours;
    rMinutes = (rMinutes < 10 ? '0' : '') + rMinutes;

    let vorzeichen = Math.sign(num);

    if(vorzeichen == 0) vorzeichen = '+';
    if(vorzeichen == 1) vorzeichen = '-';
    if(vorzeichen == -1) vorzeichen = '+';

    return vorzeichen + rHours + ':' + rMinutes;
}

function af2_create_timezone_dropdown(form) {
    let cont = '';
    let timezone = af2_returnTimeZoneName();

    let dateForOffset = new Date();

    let timeZoneOffset = dateForOffset.getTimezoneOffset();

    let timeZoneOffsetString = af2_convertMinutesToHoursAndMinutes(timeZoneOffset);
    let timeZoneRegion = af2_getTimeZoneNameRegion();

    let allTimeZones = af2_getTimeZoneJson();
    let filteredTimeZones = allTimeZones.allTimeZones.filter(el => { return el.region == timeZoneRegion && el.offset == timeZoneOffsetString });

    timezone = 'Europe/Amsterdam';

    if(filteredTimeZones.length < 1) form.lastTerminbuchungsObject.chosenTimeZone = 'Europe/Amsterdam';
    else {
        form.lastTerminbuchungsObject.chosenTimeZone = filteredTimeZones[0].value;
        timezone = filteredTimeZones[0].value;
    }

    cont += '<select class="af2_terminbuchungs_select af2_tb_select_timezone" name="af2_zeitzone" id="af2_zeitzone">';
        cont += '<optgroup label="Afrika">';
            cont += '<option value="Africa/Abidjan"'; if(timezone == 'Africa/Abidjan') cont += ' selected'; cont += '>+00:00 Mittlere Greenwich-Zeit</option>';
            cont += '<option value="Africa/Algiers"'; if(timezone == 'Africa/Algiers') cont += ' selected'; cont += '>+01:00 (Afrika) Mitteleuropäische Zeit</option>';
            cont += '<option value="Africa/Casablanca"'; if(timezone == 'Africa/Casablanca') cont += ' selected'; cont += '>+01:00 Casablanca, El Aaiun</option>';
            cont += '<option value="Africa/Blantyre"'; if(timezone == 'Africa/Blantyre') cont += ' selected'; cont += '>+02:00 South Africa Time</option>';
            cont += '<option value="Africa/Ceuta"'; if(timezone == 'Africa/Ceuta') cont += ' selected'; cont += '>+02:00 Ceuta</option>';
            cont += '<option value="Africa/Addis_Ababa"'; if(timezone == 'Africa/Addis_Ababa') cont += ' selected'; cont += '>+03:00 East Africa Time</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Amerika">';
            cont += '<option value="America/Adak"'; if(timezone == 'America/Adak') cont += ' selected'; cont += '>-09:00 Adak, Atka</option>';
            cont += '<option value="America/Anchorage"'; if(timezone == 'America/Anchorage') cont += ' selected'; cont += '>-08:00 Anchorage, Juneau, Metlakatla, Nome</option>';
            cont += '<option value="America/Creston"'; if(timezone == 'America/Creston') cont += ' selected'; cont += '>-07:00 Arizona &amp; Yukon Time</option>';
            cont += '<option value="America/Ensenada"'; if(timezone == 'America/Ensenada') cont += ' selected'; cont += '>-07:00 Pacific Time</option>';
            cont += '<option value="America/Belize"'; if(timezone == 'America/Belize') cont += ' selected'; cont += '>-06:00 Central Standard Time</option>';
            cont += '<option value="America/Boise"'; if(timezone == 'America/Boise') cont += ' selected'; cont += '>-06:00 Mountain Time</option>';
            cont += '<option value="America/Chihuahua"'; if(timezone == 'America/Chihuahua') cont += ' selected'; cont += '>-06:00 Chihuahua, Mazatlan</option>';
            cont += '<option value="America/Atikokan"'; if(timezone == 'America/Atikokan') cont += ' selected'; cont += '>-05:00 Jamaika, Panama, Kolumbien</option>';
            cont += '<option value="America/Bahia_Banderas"'; if(timezone == 'America/Bahia_Banderas') cont += ' selected'; cont += '>-05:00 Bahia Banderas, Merida, Mexiko-Stadt, Monterrey</option>';
            cont += '<option value="America/Chicago"'; if(timezone == 'America/Chicago') cont += ' selected'; cont += '>-05:00 Central Time</option>';
            cont += '<option value="America/Anguilla"'; if(timezone == 'America/Anguilla') cont += ' selected'; cont += '>-04:00 Eastern Caribbean Time</option>';
            cont += '<option value="America/Asuncion"'; if(timezone == 'America/Asuncion') cont += ' selected'; cont += '>-04:00 Asunción</option>';
            cont += '<option value="America/Detroit"'; if(timezone == 'America/Detroit') cont += ' selected'; cont += '>-04:00 Eastern Time</option>';
            cont += '<option value="America/Havana"'; if(timezone == 'America/Havana') cont += ' selected'; cont += '>-04:00 Havanna</option>';
            cont += '<option value="America/Santiago"'; if(timezone == 'America/Santiago') cont += ' selected'; cont += '>-04:00 Santiago</option>';
            cont += '<option value="America/Araguaina"'; if(timezone == 'America/Araguaina') cont += ' selected'; cont += '>-03:00 Argentinien, Brasilien</option>';
            cont += '<option value="America/Glace_Bay"'; if(timezone == 'America/Glace_Bay') cont += ' selected'; cont += '>-03:00 Glace Bay, Goose Bay, Halifax, Moncton</option>';
            cont += '<option value="America/Godthab"'; if(timezone == 'America/Godthab') cont += ' selected'; cont += '>-02:00 Godthab, Nuuk</option>';
            cont += '<option value="America/Miquelon"'; if(timezone == 'America/Miquelon') cont += ' selected'; cont += '>-02:00 Miquelon</option>';
            cont += '<option value="America/Noronha"'; if(timezone == 'America/Noronha') cont += ' selected'; cont += '>-02:00 Noronha</option>';
            cont += '<option value="America/St_Johns"'; if(timezone == 'America/St_Johns') cont += ' selected'; cont += '>-02:30 St Johns</option>';
            cont += '<option value="America/Danmarkshavn"'; if(timezone == 'America/Danmarkshavn') cont += ' selected'; cont += '>+00:00 Danmarkshavn</option>';
            cont += '<option value="America/Scoresbysund"'; if(timezone == 'America/Scoresbysund') cont += ' selected'; cont += '>+00:00 Scoresbysund</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Antarktik">';
            cont += '<option value="Antarctica/Palmer"'; if(timezone == 'Antarctica/Palmer') cont += ' selected'; cont += '>-03:00 Palmer, Rothera</option>';
            cont += '<option value="Antarctica/Troll"'; if(timezone == 'Antarctica/Troll') cont += ' selected'; cont += '>+02:00 Troll</option>';
            cont += '<option value="Antarctica/Syowa"'; if(timezone == 'Antarctica/Syowa') cont += ' selected'; cont += '>+03:00 Syowa</option>';
            cont += '<option value="Antarctica/Mawson"'; if(timezone == 'Antarctica/Mawson') cont += ' selected'; cont += '>+05:00 Mawson</option>';
            cont += '<option value="Antarctica/Vostok"'; if(timezone == 'Antarctica/Vostok') cont += ' selected'; cont += '>+06:00 Vostok</option>';
            cont += '<option value="Antarctica/Davis"'; if(timezone == 'Antarctica/Davis') cont += ' selected'; cont += '>+07:00 Davis</option>';
            cont += '<option value="Antarctica/DumontDUrville"'; if(timezone == 'Antarctica/DumontDUrville') cont += ' selected'; cont += ">+10:00 Dumont-d'Urville</option>";
            cont += '<option value="Antarctica/Macquarie"'; if(timezone == 'Antarctica/Macquarie') cont += ' selected'; cont += '>+10:00 Macquarie</option>';
            cont += '<option value="Antarctica/Casey"'; if(timezone == 'Antarctica/Casey') cont += ' selected'; cont += '>+11:00 Casey</option>';
            cont += '<option value="Antarctica/McMurdo"'; if(timezone == 'Antarctica/McMurdo') cont += ' selected'; cont += '>+12:00 McMurdo, Südpol</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Arktis">';
            cont += '<option value="Arctic/Longyearbyen"'; if(timezone == 'Arctic/Longyearbyen') cont += ' selected'; cont += '>+02:00 Longyearbyen</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Asien">';
            cont += '<option value="Asia/Aden"'; if(timezone == 'Asia/Aden') cont += ' selected'; cont += '>+03:00 Bagdad, Bahrain, Istanbul, Katar</option>';
            cont += '<option value="Asia/Amman"'; if(timezone == 'Asia/Amman') cont += ' selected'; cont += '>+03:00 Amman</option>';
            cont += '<option value="Asia/Beirut"'; if(timezone == 'Asia/Beirut') cont += ' selected'; cont += '>+03:00 Beirut</option>';
            cont += '<option value="Asia/Damascus"'; if(timezone == 'Asia/Damascus') cont += ' selected'; cont += '>+03:00 Damaskus</option>';
            cont += '<option value="Asia/Famagusta"'; if(timezone == 'Asia/Famagusta') cont += ' selected'; cont += '>+03:00 Famagusta, Nikosia</option>';
            cont += '<option value="Asia/Gaza"'; if(timezone == 'Asia/Gaza') cont += ' selected'; cont += '>+03:00 Gaza, Hebron</option>';
            cont += '<option value="Asia/Jerusalem"'; if(timezone == 'Asia/Jerusalem') cont += ' selected'; cont += '>+03:00 Jerusalem, Tel Aviv</option>';
            cont += '<option value="Asia/Baku"'; if(timezone == 'Asia/Baku') cont += ' selected'; cont += '>+04:00 Baku, Dubai, Muscat, Tiflis</option>';
            cont += '<option value="Asia/Kabul"'; if(timezone == 'Asia/Kabul') cont += ' selected'; cont += '>+04:30 Kabul</option>';
            cont += '<option value="Asia/Tehran"'; if(timezone == 'Asia/Tehran') cont += ' selected'; cont += '>+04:30 Teheran</option>';
            cont += '<option value="Asia/Aqtau"'; if(timezone == 'Asia/Aqtau') cont += ' selected'; cont += '>+05:00 Aqtau, Aqtobe, Ashgabat, Ashkhabad</option>';
            cont += '<option value="Asia/Calcutta"'; if(timezone == 'Asia/Calcutta') cont += ' selected'; cont += '>+05:30 Neu-Delhi, Mumbai, Kalkutta</option>';
            cont += '<option value="Asia/Kathmandu"'; if(timezone == 'Asia/Kathmandu') cont += ' selected'; cont += '>+05:45 Kathmandu, Kathmandu</option>';
            cont += '<option value="Asia/Almaty"'; if(timezone == 'Asia/Almaty') cont += ' selected'; cont += '>+06:00 Almaty, Bishkek, Dhaka, Dhaka</option>';
            cont += '<option value="Asia/Rangoon"'; if(timezone == 'Asia/Rangoon') cont += ' selected'; cont += '>+06:30 Rangoon, Yangon</option>';
            cont += '<option value="Asia/Bangkok"'; if(timezone == 'Asia/Bangkok') cont += ' selected'; cont += '>+07:00 Indochina Time</option>';
            cont += '<option value="Asia/Brunei"'; if(timezone == 'Asia/Brunei') cont += ' selected'; cont += '>+08:00 China, Hongkong, Singapur</option>';
            cont += '<option value="Asia/Chita"'; if(timezone == 'Asia/Chita') cont += ' selected'; cont += '>+09:00 Seoul, Tokio</option>';
            cont += '<option value="Asia/Ust-Nera"'; if(timezone == 'Asia/Ust-Nera') cont += ' selected'; cont += '>+10:00 Ust-Nera, Wladiwostok</option>';
            cont += '<option value="Asia/Magadan"'; if(timezone == 'Asia/Magadan') cont += ' selected'; cont += '>+11:00 Magadan, Sakhalin, Srednekolymsk</option>';
            cont += '<option value="Asia/Anadyr"'; if(timezone == 'Asia/Anadyr') cont += ' selected'; cont += '>+12:00 Anadyr, Kamtschatka</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Atlantik">';
            cont += '<option value="Atlantic/Bermuda"'; if(timezone == 'Atlantic/Bermuda') cont += ' selected'; cont += '>-03:00 Bermuda</option>';
            cont += '<option value="Atlantic/Stanley"'; if(timezone == 'Atlantic/Stanley') cont += ' selected'; cont += '>-03:00 Stanley</option>';
            cont += '<option value="Atlantic/South_Georgia"'; if(timezone == 'Atlantic/South_Georgia') cont += ' selected'; cont += '>-02:00 Südgeorgien</option>';
            cont += '<option value="Atlantic/Cape_Verde"'; if(timezone == 'Atlantic/Cape_Verde') cont += ' selected'; cont += '>-01:00 Kap Verde</option>';
            cont += '<option value="Atlantic/Azores"'; if(timezone == 'Atlantic/Azores') cont += ' selected'; cont += '>+00:00 Azoren</option>';
            cont += '<option value="Atlantic/Reykjavik"'; if(timezone == 'Atlantic/Reykjavik') cont += ' selected'; cont += '>+00:00 Reykjavik, St Helena</option>';
            cont += '<option value="Atlantic/Canary"'; if(timezone == 'Atlantic/Canary') cont += ' selected'; cont += '>+01:00 Kanaren, Färöer, Färöer, Madeira</option>';
            cont += '<option value="Atlantic/Jan_Mayen"'; if(timezone == 'Atlantic/Jan_Mayen') cont += ' selected'; cont += '>+02:00 Jan Mayen</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Australien">';
            cont += '<option value="Australia/Eucla"'; if(timezone == 'Australia/Eucla') cont += ' selected'; cont += '>+08:45 Eucla</option>';
            cont += '<option value="Australia/Perth"'; if(timezone == 'Australia/Perth') cont += ' selected'; cont += '>+08:00 Perth, Westen</option>';
            cont += '<option value="Australia/Adelaide"'; if(timezone == 'Australia/Adelaide') cont += ' selected'; cont += '>+09:30 Adelaide, Broken Hill, Süden, Yancowinna</option>';
            cont += '<option value="Australia/Darwin"'; if(timezone == 'Australia/Darwin') cont += ' selected'; cont += '>+09:30 Darwin, Norden</option>';
            cont += '<option value="Australia/ACT"'; if(timezone == 'Australia/ACT') cont += ' selected'; cont += '>+10:00 Australian Eastern Time</option>';
            cont += '<option value="Australia/Brisbane"'; if(timezone == 'Australia/Brisbane') cont += ' selected'; cont += '>+10:00 Brisbane, Lindeman, Queensland</option>';
            cont += '<option value="Australia/LHI"'; if(timezone == 'Australia/LHI') cont += ' selected'; cont += '>+10:30 LHI, Lord Howe</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Brasilien">';
            cont += '<option value="Brazil/Acre"'; if(timezone == 'Brazil/Acre') cont += ' selected'; cont += '>-05:00 Acre</option>';
            cont += '<option value="Brazil/West"'; if(timezone == 'Brazil/West') cont += ' selected'; cont += '>-04:00 Westen</option>';
            cont += '<option value="Brazil/East"'; if(timezone == 'Brazil/East') cont += ' selected'; cont += '>-03:00 Osten</option>';
            cont += '<option value="Brazil/DeNoronha"'; if(timezone == 'Brazil/DeNoronha') cont += ' selected'; cont += '>-02:00 De Noronha</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Kanada">';
            cont += '<option value="Canada/Pacific"'; if(timezone == 'Canada/Pacific') cont += ' selected'; cont += '>-07:00 Pazifik</option>';
            cont += '<option value="Canada/Yukon"'; if(timezone == 'Canada/Yukon') cont += ' selected'; cont += '>-07:00 Yukon</option>';
            cont += '<option value="Canada/Mountain"'; if(timezone == 'Canada/Mountain') cont += ' selected'; cont += '>-06:00 Mountain</option>';
            cont += '<option value="Canada/Saskatchewan"'; if(timezone == 'Canada/Saskatchewan') cont += ' selected'; cont += '>-06:00 Saskatchewan</option>';
            cont += '<option value="Canada/Central"'; if(timezone == 'Canada/Central') cont += ' selected'; cont += '>-05:00 Central</option>';
            cont += '<option value="Canada/Eastern"'; if(timezone == 'Canada/Eastern') cont += ' selected'; cont += '>-04:00 Eastern</option>';
            cont += '<option value="Canada/Atlantic"'; if(timezone == 'Canada/Atlantic') cont += ' selected'; cont += '>-03:00 Atlantic Time</option>';
            cont += '<option value="Canada/Newfoundland"'; if(timezone == 'Canada/Newfoundland') cont += ' selected'; cont += '>-02:30 Neufundland</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Chile">';
            cont += '<option value="Chile/EasterIsland"'; if(timezone == 'Chile/EasterIsland') cont += ' selected'; cont += '>-06:00 Osterinsel</option>';
            cont += '<option value="Chile/Continental"'; if(timezone == 'Chile/Continental') cont += ' selected'; cont += '>-04:00 Continental</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Europa">';
            cont += '<option value="Europe/Belfast"'; if(timezone == 'Europe/Belfast') cont += ' selected'; cont += '>+01:00 Dublin, London, Lissabon</option>';
            cont += '<option value="Europe/Amsterdam"'; if(timezone == 'Europe/Amsterdam') cont += ' selected'; cont += '>+02:00 (Europa) Mitteleuropäische Zeit</option>';
            cont += '<option value="Europe/Kaliningrad"'; if(timezone == 'Europe/Kaliningrad') cont += ' selected'; cont += '>+02:00 Kaliningrad</option>';
            cont += '<option value="Europe/Athens"'; if(timezone == 'Europe/Athens') cont += ' selected'; cont += '>+03:00 Osteuropäische Zeit</option>';
            cont += '<option value="Europe/Chisinau"'; if(timezone == 'Europe/Chisinau') cont += ' selected'; cont += '>+03:00 Chisinau, Tiraspol</option>';
            cont += '<option value="Europe/Istanbul"'; if(timezone == 'Europe/Istanbul') cont += ' selected'; cont += '>+03:00 Istanbul, Kirov, Minsk, Moskau</option>';
            cont += '<option value="Europe/Astrakhan"'; if(timezone == 'Europe/Astrakhan') cont += ' selected'; cont += '>+04:00 Astrachan, Samara, Saratov, Uljanowsk</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Indisch">';
            cont += '<option value="Indian/Antananarivo"'; if(timezone == 'Indian/Antananarivo') cont += ' selected'; cont += '>+03:00 Antananarivo, Comoro, Mayotte</option>';
            cont += '<option value="Indian/Mahe"'; if(timezone == 'Indian/Mahe') cont += ' selected'; cont += '>+04:00 Mahe, Mauritius, Reunion</option>';
            cont += '<option value="Indian/Kerguelen"'; if(timezone == 'Indian/Kerguelen') cont += ' selected'; cont += '>+05:00 Kerguelen, Malediven</option>';
            cont += '<option value="Indian/Chagos"'; if(timezone == 'Indian/Chagos') cont += ' selected'; cont += '>+06:00 Chagos</option>';
            cont += '<option value="Indian/Cocos"'; if(timezone == 'Indian/Cocos') cont += ' selected'; cont += '>+06:30 Cocos</option>';
            cont += '<option value="Indian/Christmas"'; if(timezone == 'Indian/Christmas') cont += ' selected'; cont += '>+07:00 Christmas</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Mexiko">';
            cont += '<option value="Mexico/BajaNorte"'; if(timezone == 'Mexico/BajaNorte') cont += ' selected'; cont += '>-07:00 Baja Norte</option>';
            cont += '<option value="Mexico/BajaSur"'; if(timezone == 'Mexico/BajaSur') cont += ' selected'; cont += '>-06:00 Baja Sur</option>';
            cont += '<option value="Mexico/General"'; if(timezone == 'Mexico/General') cont += ' selected'; cont += '>-05:00 General</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Pazifik">';
            cont += '<option value="Pacific/Midway"'; if(timezone == 'Pacific/Midway') cont += ' selected'; cont += '>-11:00 Midway, Niue, Pago Pago, Samoa</option>';
            cont += '<option value="Pacific/Honolulu"'; if(timezone == 'Pacific/Honolulu') cont += ' selected'; cont += '>-10:00 Honolulu, Johnston, Rarotonga, Tahiti</option>';
            cont += '<option value="Pacific/Gambier"'; if(timezone == 'Pacific/Gambier') cont += ' selected'; cont += '>-09:00 Gambier</option>';
            cont += '<option value="Pacific/Marquesas"'; if(timezone == 'Pacific/Marquesas') cont += ' selected'; cont += '>-09:30 Marquesas</option>';
            cont += '<option value="Pacific/Pitcairn"'; if(timezone == 'Pacific/Pitcairn') cont += ' selected'; cont += '>-08:00 Pitcairn</option>';
            cont += '<option value="Pacific/Easter"'; if(timezone == 'Pacific/Easter') cont += ' selected'; cont += '>-06:00 Easter</option>';
            cont += '<option value="Pacific/Galapagos"'; if(timezone == 'Pacific/Galapagos') cont += ' selected'; cont += '>-06:00 Galapagos</option>';
            cont += '<option value="Pacific/Palau"'; if(timezone == 'Pacific/Palau') cont += ' selected'; cont += '>+09:00 Palau</option>';
            cont += '<option value="Pacific/Chuuk"'; if(timezone == 'Pacific/Chuuk') cont += ' selected'; cont += '>+10:00 Chuuk, Guam, Port Moresby, Saipan</option>';
            cont += '<option value="Pacific/Bougainville"'; if(timezone == 'Pacific/Bougainville') cont += ' selected'; cont += '>+11:00 Bougainville, Efate, Guadalcanal, Kosrae</option>';
            cont += '<option value="Pacific/Norfolk"'; if(timezone == 'Pacific/Norfolk') cont += ' selected'; cont += '>+11:00 Norfolk</option>';
            cont += '<option value="Pacific/Auckland"'; if(timezone == 'Pacific/Auckland') cont += ' selected'; cont += '>+12:00 Auckland</option>';
            cont += '<option value="Pacific/Chatham"'; if(timezone == 'Pacific/Chatham') cont += ' selected'; cont += '>+12:45 Chatham</option>';
            cont += '<option value="Pacific/Fiji"'; if(timezone == 'Pacific/Fiji') cont += ' selected'; cont += '>+12:00 Fidschi</option>';
            cont += '<option value="Pacific/Funafuti"'; if(timezone == 'Pacific/Funafuti') cont += ' selected'; cont += '>+12:00 Funafuti, Kwajalein, Majuro, Nauru</option>';
            cont += '<option value="Pacific/Apia"'; if(timezone == 'Pacific/Apia') cont += ' selected'; cont += '>+13:00 Apia</option>';
            cont += '<option value="Pacific/Enderbury"'; if(timezone == 'Pacific/Enderbury') cont += ' selected'; cont += '>+13:00 Enderbury, Fakaofo, Tongatapu</option>';
            cont += '<option value="Pacific/Kiritimati"'; if(timezone == 'Pacific/Kiritimati') cont += ' selected'; cont += '>+14:00 Kiritimati</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="USA">';
            cont += '<option value="US/Pacific"'; if(timezone == 'US/Pacific') cont += ' selected'; cont += '>-07:00 Pacific Time</option>';
            cont += '<option value="US/Mountain"'; if(timezone == 'US/Mountain') cont += ' selected'; cont += '>-06:00 Mountain Time</option>';
            cont += '<option value="US/Central"'; if(timezone == 'US/Central') cont += ' selected'; cont += '>-05:00 Central Time</option>';
            cont += '<option value="US/East-Indiana"'; if(timezone == 'US/East-Indiana') cont += ' selected'; cont += '>-04:00 Eastern Time</option>';
        cont += '</optgroup>';
        cont += '<optgroup label="Etc">';
            cont += '<option value="Etc/GMT"'; if(timezone == 'Etc/GMT') cont += ' selected'; cont += '>Etc/GMT</option>';
            cont += '<option value="Etc/GMT+1"'; if(timezone == 'Etc/GMT+1') cont += ' selected'; cont += '>Etc/GMT+1</option>';
            cont += '<option value="Etc/GMT+2"'; if(timezone == 'Etc/GMT+2') cont += ' selected'; cont += '>Etc/GMT+2</option>';
            cont += '<option value="Etc/GMT+3"'; if(timezone == 'Etc/GMT+3') cont += ' selected'; cont += '>Etc/GMT+3</option>';
            cont += '<option value="Etc/GMT+4"'; if(timezone == 'Etc/GMT+4') cont += ' selected'; cont += '>Etc/GMT+4</option>';
            cont += '<option value="Etc/GMT+5"'; if(timezone == 'Etc/GMT+5') cont += ' selected'; cont += '>Etc/GMT+5</option>';
            cont += '<option value="Etc/GMT+6"'; if(timezone == 'Etc/GMT+6') cont += ' selected'; cont += '>Etc/GMT+6</option>';
            cont += '<option value="Etc/GMT+7"'; if(timezone == 'Etc/GMT+7') cont += ' selected'; cont += '>Etc/GMT+7</option>';
            cont += '<option value="Etc/GMT+8"'; if(timezone == 'Etc/GMT+8') cont += ' selected'; cont += '>Etc/GMT+8</option>';
            cont += '<option value="Etc/GMT+9"'; if(timezone == 'Etc/GMT+9') cont += ' selected'; cont += '>Etc/GMT+9</option>';
            cont += '<option value="Etc/GMT+10"'; if(timezone == 'Etc/GMT+10') cont += ' selected'; cont += '>Etc/GMT+10</option>';
            cont += '<option value="Etc/GMT+11"'; if(timezone == 'Etc/GMT+11') cont += ' selected'; cont += '>Etc/GMT+11</option>';
            cont += '<option value="Etc/GMT+12"'; if(timezone == 'Etc/GMT+12') cont += ' selected'; cont += '>Etc/GMT+12</option>';
            cont += '<option value="Etc/GMT-1"'; if(timezone == 'Etc/GMT-1') cont += ' selected'; cont += '>Etc/GMT-1</option>';
            cont += '<option value="Etc/GMT-2"'; if(timezone == 'Etc/GMT-2') cont += ' selected'; cont += '>Etc/GMT-2</option>';
            cont += '<option value="Etc/GMT-3"'; if(timezone == 'Etc/GMT-3') cont += ' selected'; cont += '>Etc/GMT-3</option>';
            cont += '<option value="Etc/GMT-4"'; if(timezone == 'Etc/GMT-4') cont += ' selected'; cont += '>Etc/GMT-4</option>';
            cont += '<option value="Etc/GMT-5"'; if(timezone == 'Etc/GMT-5') cont += ' selected'; cont += '>Etc/GMT-5</option>';
            cont += '<option value="Etc/GMT-6"'; if(timezone == 'Etc/GMT-6') cont += ' selected'; cont += '>Etc/GMT-6</option>';
            cont += '<option value="Etc/GMT-7"'; if(timezone == 'Etc/GMT-7') cont += ' selected'; cont += '>Etc/GMT-7</option>';
            cont += '<option value="Etc/GMT-8"'; if(timezone == 'Etc/GMT-8') cont += ' selected'; cont += '>Etc/GMT-8</option>';
            cont += '<option value="Etc/GMT-9"'; if(timezone == 'Etc/GMT-9') cont += ' selected'; cont += '>Etc/GMT-9</option>';
            cont += '<option value="Etc/GMT-10"'; if(timezone == 'Etc/GMT-10') cont += ' selected'; cont += '>Etc/GMT-10</option>';
            cont += '<option value="Etc/GMT-11"'; if(timezone == 'Etc/GMT-11') cont += ' selected'; cont += '>Etc/GMT-11</option>';
            cont += '<option value="Etc/GMT-12"'; if(timezone == 'Etc/GMT-12') cont += ' selected'; cont += '>Etc/GMT-12</option>';
            cont += '<option value="Etc/GMT-13"'; if(timezone == 'Etc/GMT-13') cont += ' selected'; cont += '>Etc/GMT-13</option>';
            cont += '<option value="Etc/GMT-14"'; if(timezone == 'Etc/GMT-14') cont += ' selected'; cont += '>Etc/GMT-14</option>';
            cont += '<option value="Etc/UTC"'; if(timezone == 'Etc/UTC') cont += ' selected'; cont += '>Etc/UTC</option>';
        cont += '</optgroup>';
    cont += '</select>';

    return cont;
}

function af2_adjustTerminbuchungsTimesByTimezone($, form) {
    /*$('.af2_terminbuchung_time').each((i, el) => {
        
    });*/
}

function af2_getTimeZoneJson() {
    return {
        "allTimeZones": [
            { "value":"Africa/Abidjan", "name": "UTC +00:00 Mittlere Greenwich-Zeit", "region": "Africa", "offset":"+00:00" },
            { "value":"Africa/Algiers", "name": "UTC +01:00 (Afrika) Mitteleuropäische Zeit", "region": "Africa", "offset":"+01:00" },
            { "value":"Africa/Casablanca", "name": "UTC +01:00 Casablanca, El Aaiun", "region": "Africa", "offset":"+01:00" },
            { "value":"Africa/Blantyre", "name": "UTC +02:00 South Africa Time", "region": "Africa", "offset":"+02:00" },
            { "value":"Africa/Ceuta", "name": "UTC +02:00 Ceuta", "region": "Africa", "offset":"+02:00" },
            { "value":"Africa/Addis_Ababa", "name": "UTC +03:00 East Africa Time", "region": "Africa", "offset":"+03:00" },
            { "value":"America/Adak", "name": "UTC -09:00 Adak, Atka", "region": "America", "offset":"-09:00" },
            { "value":"America/Anchorage", "name": "UTC -08:00 Anchorage, Juneau, Metlakatla, Nome", "region": "America", "offset":"-08:00" },
            { "value":"America/Creston", "name": "UTC -07:00 Arizona &amp; Yukon Time", "region": "America", "offset":"-07:00" },
            { "value":"America/Ensenada", "name": "UTC -07:00 Pacific Time", "region": "America", "offset":"-07:00" },
            { "value":"America/Belize", "name": "UTC -06:00 Central Standard Time", "region": "America", "offset":"-06:00" },
            { "value":"America/Boise", "name": "UTC -06:00 Mountain Time", "region": "America", "offset":"-06:00" },
            { "value":"America/Chihuahua", "name": "UTC -06:00 Chihuahua, Mazatlan", "region": "America", "offset":"-06:00" },
            { "value":"America/Atikokan", "name": "UTC -05:00 Jamaika, Panama, Kolumbien", "region": "America", "offset":"-05:00" },
            { "value":"America/Bahia_Banderas", "name": "UTC -05:00 Bahia Banderas, Merida, Mexiko-Stadt, Monterrey", "region": "America", "offset":"-05:00" },
            { "value":"America/Chicago", "name": "UTC -05:00 Central Time", "region": "America", "offset":"-05:00" },
            { "value":"America/Anguilla", "name": "UTC -04:00 Eastern Caribbean Time", "region": "America", "offset":"-04:00" },
            { "value":"America/Asuncion", "name": "UTC -04:00 Asunción", "region": "America", "offset":"-04:00" },
            { "value":"America/Detroit", "name": "UTC -04:00 Eastern Time", "region": "America", "offset":"-04:00" },
            { "value":"America/Havana", "name": "UTC -04:00 Havanna", "region": "America", "offset":"-04:00" },
            { "value":"America/Santiago", "name": "UTC -04:00 Santiago", "region": "America", "offset":"-04:00" },
            { "value":"America/Araguaina", "name": "UTC -03:00 Argentinien, Brasilien", "region": "America", "offset":"-03:00" },
            { "value":"America/Glace_Bay", "name": "UTC -03:00 Glace Bay, Goose Bay, Halifax, Moncton", "region": "America", "offset":"-03:00" },
            { "value":"America/Godthab", "name": "UTC -02:00 Godthab, Nuuk", "region": "America", "offset":"-02:00" },
            { "value":"America/Miquelon", "name": "UTC -02:00 Miquelon", "region": "America", "offset":"-02:00" },
            { "value":"America/Noronha", "name": "UTC -02:00 Noronha", "region": "America", "offset":"-02:00" },
            { "value":"America/St_Johns", "name": "UTC -02:30 St Johns", "region": "America", "offset":"-02:30" },
            { "value":"America/Danmarkshavn", "name": "UTC +00:00 Danmarkshavn", "region": "America", "offset":"+00:00" },
            { "value":"America/Scoresbysund", "name": "UTC +00:00 Scoresbysund", "region": "America", "offset":"+00:00" },
            { "value":"Antarctica/Palmer", "name": "UTC -03:00 Palmer, Rothera", "region": "Antarctica", "offset":"-03:00" },
            { "value":"Antarctica/Troll", "name": "UTC +02:00 Troll", "region": "Antarctica", "offset":"+02:00" },
            { "value":"Antarctica/Syowa", "name": "UTC +03:00 Syowa", "region": "Antarctica", "offset":"+03:00" },
            { "value":"Antarctica/Mawson", "name": "UTC +05:00 Mawson", "region": "Antarctica", "offset":"+05:00" },
            { "value":"Antarctica/Vostok", "name": "UTC +06:00 Vostok", "region": "Antarctica", "offset":"+06:00" },
            { "value":"Antarctica/Davis", "name": "UTC +07:00 Davis", "region": "Antarctica", "offset":"+07:00" },
            { "value":"Antarctica/DumontDUrville", "name": "UTC +10:00 Dumont-d'Urville", "region": "Antarctica", "offset":"+10:00" },
            { "value":"Antarctica/Macquarie", "name": "UTC +10:00 Macquarie", "region": "Antarctica", "offset":"+10:00" },
            { "value":"Antarctica/Casey", "name": "UTC +11:00 Casey", "region": "Antarctica", "offset":"+11:00" },
            { "value":"Antarctica/McMurdo", "name": "UTC +12:00 McMurdo, Südpol", "region": "Antarctica", "offset":"+12:00" },
            { "value":"Arctic/Longyearbyen", "name": "UTC +02:00 Longyearbyen", "region": "Arctic", "offset":"+02:00" },
            { "value":"Asia/Aden", "name": "UTC +03:00 Bagdad, Bahrain, Istanbul, Katar", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Amman", "name": "UTC +03:00 Amman", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Beirut", "name": "UTC +03:00 Beirut", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Damascus", "name": "UTC +03:00 Damaskus", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Famagusta", "name": "UTC +03:00 Famagusta, Nikosia", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Gaza", "name": "UTC +03:00 Gaza, Hebron", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Jerusalem", "name": "UTC +03:00 Jerusalem, Tel Aviv", "region": "Asia", "offset":"+03:00" },
            { "value":"Asia/Baku", "name": "UTC +04:00 Baku, Dubai, Muscat, Tiflis", "region": "Asia", "offset":"+04:00" },
            { "value":"Asia/Kabul", "name": "UTC +04:30 Kabul", "region": "Asia", "offset":"+04:30" },
            { "value":"Asia/Tehran", "name": "UTC +04:30 Teheran", "region": "Asia", "offset":"+04:30" },
            { "value":"Asia/Aqtau", "name": "UTC +05:00 Aqtau, Aqtobe, Ashgabat, Ashkhabad", "region": "Asia", "offset":"+05:00" },
            { "value":"Asia/Calcutta", "name": "UTC +05:30 Neu-Delhi, Mumbai, Kalkutta", "region": "Asia", "offset":"+05:30" },
            { "value":"Asia/Kathmandu", "name": "UTC +05:45 Kathmandu, Kathmandu", "region": "Asia", "offset":"+05:45" },
            { "value":"Asia/Almaty", "name": "UTC +06:00 Almaty, Bishkek, Dhaka, Dhaka", "region": "Asia", "offset":"+06:00" },
            { "value":"Asia/Rangoon", "name": "UTC +06:30 Rangoon, Yangon", "region": "Asia", "offset":"+06:30" },
            { "value":"Asia/Bangkok", "name": "UTC +07:00 Indochina Time", "region": "Asia", "offset":"+07:00" },
            { "value":"Asia/Brunei", "name": "UTC +08:00 China, Hongkong, Singapur", "region": "Asia", "offset":"+08:00" },
            { "value":"Asia/Chita", "name": "UTC +09:00 Seoul, Tokio", "region": "Asia", "offset":"+09:00" },
            { "value":"Asia/Ust-Nera", "name": "UTC +10:00 Ust-Nera, Wladiwostok", "region": "Asia", "offset":"+10:00" },
            { "value":"Asia/Magadan", "name": "UTC +11:00 Magadan, Sakhalin, Srednekolymsk", "region": "Asia", "offset":"+11:00" },
            { "value":"Asia/Anadyr", "name": "UTC +12:00 Anadyr, Kamtschatka", "region": "Asia", "offset":"+12:00" },
            { "value":"Atlantic/Bermuda", "name": "UTC -03:00 Bermuda", "region": "Atlantic", "offset":"-03:00" },
            { "value":"Atlantic/Stanley", "name": "UTC -03:00 Stanley", "region": "Atlantic", "offset":"-03:00" },
            { "value":"Atlantic/South_Georgia", "name": "UTC -02:00 Südgeorgien", "region": "Atlantic", "offset":"-02:00" },
            { "value":"Atlantic/Cape_Verde", "name": "UTC -01:00 Kap Verde", "region": "Atlantic", "offset":"-01:00" },
            { "value":"Atlantic/Azores", "name": "UTC +00:00 Azoren", "region": "Atlantic", "offset":"+00:00" },
            { "value":"Atlantic/Reykjavik", "name": "UTC +00:00 Reykjavik, St Helena", "region": "Atlantic", "offset":"+00:00" },
            { "value":"Atlantic/Canary", "name": "UTC +01:00 Kanaren, Färöer, Färöer, Madeira", "region": "Atlantic", "offset":"+01:00" },
            { "value":"Atlantic/Jan_Mayen", "name": "UTC +02:00 Jan Mayen", "region": "Atlantic", "offset":"+02:00" },
            { "value":"Australia/Eucla", "name": "UTC +08:45 Eucla", "region": "Australia", "offset":"+08:45" },
            { "value":"Australia/Perth", "name": "UTC +08:00 Perth, Westen", "region": "Australia", "offset":"+08:00" },
            { "value":"Australia/Adelaide", "name": "UTC +09:30 Adelaide, Broken Hill, Süden, Yancowinna", "region": "Australia", "offset":"+09:30" },
            { "value":"Australia/Darwin", "name": "UTC +09:30 Darwin, Norden", "region": "Australia", "offset":"+09:30" },
            { "value":"Australia/ACT", "name": "UTC +10:00 Australian Eastern Time", "region": "Australia", "offset":"+10:00" },
            { "value":"Australia/Brisbane", "name": "UTC +10:00 Brisbane, Lindeman, Queensland", "region": "Australia", "offset":"+10:00" },
            { "value":"Australia/LHI", "name": "UTC +10:30 LHI, Lord Howe", "region": "Australia", "offset":"+10:30" },
            { "value":"Brazil/Acre", "name": "UTC -05:00 Acre", "region": "Brazil", "offset":"-05:00" },
            { "value":"Brazil/West", "name": "UTC -04:00 Westen", "region": "Brazil", "offset":"-04:00" },
            { "value":"Brazil/East", "name": "UTC -03:00 Osten", "region": "Brazil", "offset":"-03:00" },
            { "value":"Brazil/DeNoronha", "name": "UTC -02:00 De Noronha", "region": "Brazil", "offset":"-02:00" },
            { "value":"Canada/Pacific", "name": "UTC -07:00 Pazifik", "region": "Canada", "offset":"-07:00" },
            { "value":"Canada/Yukon", "name": "UTC -07:00 Yukon", "region": "Canada", "offset":"-07:00" },
            { "value":"Canada/Mountain", "name": "UTC -06:00 Mountain", "region": "Canada", "offset":"-06:00" },
            { "value":"Canada/Saskatchewan", "name": "UTC -06:00 Saskatchewan", "region": "Canada", "offset":"-06:00" },
            { "value":"Canada/Central", "name": "UTC -05:00 Central", "region": "Canada", "offset":"-05:00" },
            { "value":"Canada/Eastern", "name": "UTC -04:00 Eastern", "region": "Canada", "offset":"-04:00" },
            { "value":"Canada/Atlantic", "name": "UTC -03:00 Atlantic Time", "region": "Canada", "offset":"-03:00" },
            { "value":"Canada/Newfoundland", "name": "UTC -02:30 Neufundland", "region": "Canada", "offset":"-02:30" },
            { "value":"Chile/EasterIsland", "name": "UTC -06:00 Osterinsel", "region": "Chile", "offset":"-06:00" },
            { "value":"Chile/Continental", "name": "UTC -04:00 Continental", "region": "Chile", "offset":"-04:00" },
            { "value":"Europe/Belfast", "name": "UTC +01:00 Dublin, London, Lissabon", "region": "Europe", "offset":"+01:00" },
            { "value":"Europe/Amsterdam", "name": "UTC +02:00 (Europa) Mitteleuropäische Zeit", "region": "Europe", "offset":"+02:00" },
            { "value":"Europe/Kaliningrad", "name": "UTC +02:00 Kaliningrad", "region": "Europe", "offset":"+02:00" },
            { "value":"Europe/Athens", "name": "UTC +03:00 Osteuropäische Zeit", "region": "Europe", "offset":"+03:00" },
            { "value":"Europe/Chisinau", "name": "UTC +03:00 Chisinau, Tiraspol", "region": "Europe", "offset":"+03:00" },
            { "value":"Europe/Istanbul", "name": "UTC +03:00 Istanbul, Kirov, Minsk, Moskau", "region": "Europe", "offset":"+03:00" },
            { "value":"Europe/Astrakhan", "name": "UTC +04:00 Astrachan, Samara, Saratov, Uljanowsk", "region": "Europe", "offset":"+04:00" },
            { "value":"Indian/Antananarivo", "name": "UTC +03:00 Antananarivo, Comoro, Mayotte", "region": "Indian", "offset":"+03:00" },
            { "value":"Indian/Mahe", "name": "UTC +04:00 Mahe, Mauritius, Reunion", "region": "Indian", "offset":"+04:00" },
            { "value":"Indian/Kerguelen", "name": "UTC +05:00 Kerguelen, Malediven", "region": "Indian", "offset":"+05:00" },
            { "value":"Indian/Chagos", "name": "UTC +06:00 Chagos", "region": "Indian", "offset":"+06:00" },
            { "value":"Indian/Cocos", "name": "UTC +06:30 Cocos", "region": "Indian", "offset":"+06:30" },
            { "value":"Indian/Christmas", "name": "UTC +07:00 Christmas", "region": "Indian", "offset":"+07:00" },
            { "value":"Mexico/BajaNorte", "name": "UTC -07:00 Baja Norte", "region": "Mexico", "offset":"-07:00" },
            { "value":"Mexico/BajaSur", "name": "UTC -06:00 Baja Sur", "region": "Mexico", "offset":"-06:00" },
            { "value":"Mexico/General", "name": "UTC -05:00 General", "region": "Mexico", "offset":"-05:00" },
            { "value":"Pacific/Midway", "name": "UTC -11:00 Midway, Niue, Pago Pago, Samoa", "region": "Pacific", "offset":"-11:00" },
            { "value":"Pacific/Honolulu", "name": "UTC -10:00 Honolulu, Johnston, Rarotonga, Tahiti", "region": "Pacific", "offset":"-10:00" },
            { "value":"Pacific/Gambier", "name": "UTC -09:00 Gambier", "region": "Pacific", "offset":"-09:00" },
            { "value":"Pacific/Marquesas", "name": "UTC -09:30 Marquesas", "region": "Pacific", "offset":"-09:30" },
            { "value":"Pacific/Pitcairn", "name": "UTC -08:00 Pitcairn", "region": "Pacific", "offset":"-08:00" },
            { "value":"Pacific/Easter", "name": "UTC -06:00 Easter", "region": "Pacific", "offset":"-06:00" },
            { "value":"Pacific/Galapagos", "name": "UTC -06:00 Galapagos", "region": "Pacific", "offset":"-06:00" },
            { "value":"Pacific/Palau", "name": "UTC +09:00 Palau", "region": "Pacific", "offset":"+09:00" },
            { "value":"Pacific/Chuuk", "name": "UTC +10:00 Chuuk, Guam, Port Moresby, Saipan", "region": "Pacific", "offset":"+10:00" },
            { "value":"Pacific/Bougainville", "name": "UTC +11:00 Bougainville, Efate, Guadalcanal, Kosrae", "region": "Pacific", "offset":"+11:00" },
            { "value":"Pacific/Norfolk", "name": "UTC +11:00 Norfolk", "region": "Pacific", "offset":"+11:00" },
            { "value":"Pacific/Auckland", "name": "UTC +12:00 Auckland", "region": "Pacific", "offset":"+12:00" },
            { "value":"Pacific/Chatham", "name": "UTC +12:45 Chatham", "region": "Pacific", "offset":"+12:45" },
            { "value":"Pacific/Fiji", "name": "UTC +12:00 Fidschi", "region": "Pacific", "offset":"+12:00" },
            { "value":"Pacific/Funafuti", "name": "UTC +12:00 Funafuti, Kwajalein, Majuro, Nauru", "region": "Pacific", "offset":"+12:00" },
            { "value":"Pacific/Apia", "name": "UTC +13:00 Apia", "region": "Pacific", "offset":"+13:00" },
            { "value":"Pacific/Enderbury", "name": "UTC +13:00 Enderbury, Fakaofo, Tongatapu", "region": "Pacific", "offset":"+13:00" },
            { "value":"Pacific/Kiritimati", "name": "UTC +14:00 Kiritimati", "region": "Pacific", "offset":"+14:00" },
            { "value":"US/Pacific", "name": "UTC -07:00 Pacific Time", "region": "US", "offset":"-07:00" },
            { "value":"US/Mountain", "name": "UTC -06:00 Mountain Time", "region": "US", "offset":"-06:00" },
            { "value":"US/Central", "name": "UTC -05:00 Central Time", "region": "US", "offset":"-05:00" },
            { "value":"US/East-Indiana", "name": "UTC -04:00 Eastern Time", "region": "US", "offset":"-04:00" },
            { "value":"Etc/GMT", "name": "Etc/GMT", "offset":"+00:00" },
            { "value":"Etc/GMT+1", "name": "Etc/GMT+1", "offset":"+01:00" },
            { "value":"Etc/GMT+2", "name": "Etc/GMT+2", "offset":"+02:00" },
            { "value":"Etc/GMT+3", "name": "Etc/GMT+3", "offset":"+03:00" },
            { "value":"Etc/GMT+4", "name": "Etc/GMT+4", "offset":"+04:00" },
            { "value":"Etc/GMT+5", "name": "Etc/GMT+5", "offset":"+05:00" },
            { "value":"Etc/GMT+6", "name": "Etc/GMT+6", "offset":"+06:00" },
            { "value":"Etc/GMT+7", "name": "Etc/GMT+7", "offset":"+07:00" },
            { "value":"Etc/GMT+8", "name": "Etc/GMT+8", "offset":"+08:00" },
            { "value":"Etc/GMT+9", "name": "Etc/GMT+9", "offset":"+09:00" },
            { "value":"Etc/GMT+10", "name": "Etc/GMT+10", "offset":"+10:00" },
            { "value":"Etc/GMT+11", "name": "Etc/GMT+11", "offset":"+11:00" },
            { "value":"Etc/GMT+12", "name": "Etc/GMT+12", "offset":"+12:00" },
            { "value":"Etc/GMT-1", "name": "Etc/GMT-1", "offset":"-01:00" },
            { "value":"Etc/GMT-2", "name": "Etc/GMT-2", "offset":"-02:00" },
            { "value":"Etc/GMT-3", "name": "Etc/GMT-3", "offset":"-03:00" },
            { "value":"Etc/GMT-4", "name": "Etc/GMT-4", "offset":"-04:00" },
            { "value":"Etc/GMT-5", "name": "Etc/GMT-5", "offset":"-05:00" },
            { "value":"Etc/GMT-6", "name": "Etc/GMT-6", "offset":"-06:00" },
            { "value":"Etc/GMT-7", "name": "Etc/GMT-7", "offset":"-07:00" },
            { "value":"Etc/GMT-8", "name": "Etc/GMT-8", "offset":"-08:00" },
            { "value":"Etc/GMT-9", "name": "Etc/GMT-9", "offset":"-09:00" },
            { "value":"Etc/GMT-10", "name": "Etc/GMT-10", "offset":"-10:00" },
            { "value":"Etc/GMT-11", "name": "Etc/GMT-11", "offset":"-11:00" },
            { "value":"Etc/GMT-12", "name": "Etc/GMT-12", "offset":"-12:00" },
            { "value":"Etc/GMT-13", "name": "Etc/GMT-13", "offset":"-13:00" },
            { "value":"Etc/GMT-14", "name": "Etc/GMT-14", "offset":"-14:00" },
            { "value":"Etc/UTC", "name": "Etc/UTC", "offset":"+00:00" }
        ]
    };
}


const af2_parseTZToFloat = (timeZoneOffsetString_) => {
    /*let vorzeichen = '+';
    if(timeZoneOffsetString_.length == 6) vorzeichen = timeZoneOffsetString_.substr(0,1);
    let timeZoneOffsetString_calc = timeZoneOffsetString_.substr(timeZoneOffsetString_.length-5);
    let splittedTimeZoneOffsetString_calc = timeZoneOffsetString_calc.split(':');
    let splittedAfterComma = 100/(60/parseInt(splittedTimeZoneOffsetString_calc[1]));
    let splittedBeforeComma = parseInt(splittedTimeZoneOffsetString_calc[0]);
    let commaValue = parseFloat(vorzeichen + splittedBeforeComma + '.' + splittedAfterComma);

    return commaValue;*/
}
const af2_parseFloatToTZ = (float) => {

    /*let splitted = float.toString().split('.');
    let split1 = splitted[1] != undefined ? splitted[1] : undefined;
    let splittedAfterComma = split1 != undefined ? 60/(100/splitted[1]) : '00';
    let splittedBeforeComma = splitted[0];

    let needsNull = false;
    if(splittedBeforeComma < 10 && splittedBeforeComma > -10) needsNull = true;

    let vorzeichen = Math.sign(float) != -1 ? '+' : '-';

    //if(splittedBeforeComma < 10 && > 0) splitted

    return splitted[0] + ':' + splittedAfterComma ;*/
}

const initiateIntlTelInput = ($, rtl_layout) => {
    if( $('.phone_type').length ){
        $('.phone_type').each( function(){
            $(this).intlTelInputSelect2({
                preferredCountries:[],
                geoIpLookup:true
              }, rtl_layout);      
        } );
    }
}