$( document ).ready(function($) {

    $('form[name="af2_license_form"] .af2_edit_content_input').on('input', (e) => {
        if(e.currentTarget.value){
            $('form[name="af2_license_form"] [type="submit"]').attr('disabled', false);
            $('form[name="af2_license_form"] [type="submit"]').removeClass('af2_btn_disabled');
        }else{
            $('form[name="af2_license_form"] [type="submit"]').attr('disabled', true);
            $('form[name="af2_license_form"] [type="submit"]').addClass('af2_btn_disabled');
        }
    });

    $('form[name="af2_license_form"]').submit( (e) => {
        e.preventDefault();
        
        jQuery.ajax({
            url: af2_menu_components_object.ajax_url,
            method:'POST',
            data: {
                action: 'af2_lizenz_check',
                key: $('form[name="af2_license_form"] .af2_edit_content_input').val()
            },
            beforeSend: () => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').removeClass('af2_hide');
            },
            success: ( response ) => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
                $('#af2_lizenz_modal .af2_modal_content').html(response);
                if(response != af2_lizenz_object.strings.domain_activated) {
                    $('#af2_lizenz_modal').attr('data-bottombar', 'false');
                }
                else {
                    $('#af2_lizenz_modal').attr('data-bottombar', 'true');
                }
                af2_open_modal('#af2_lizenz_modal');
            },
            error: ( error ) => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
                $('#af2_lizenz_modal .af2_modal_content').html('Status:'+error.status +' '+ error.statusText+'<p>Error:<br>'+error.responseText+'</p>');
                af2_open_modal('#af2_lizenz_modal');
            }
        }).done(function() {
            $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
        });        
    });

    $('form[name="af2_app_form"]').submit( (e) => {
        e.preventDefault();
        
        jQuery.ajax({
            url: af2_menu_components_object.ajax_url,
            method:'POST',
            data: {
                action: 'af2_delete_app',
            },
            beforeSend: () => {
                $('form[name="af2_app_form"] #af2_delete_app_button .loading').removeClass('af2_hide');
            },
            success: ( response ) => {
                $('form[name="af2_app_form"] #af2_delete_app_button .loading').addClass('af2_hide');
                af2_open_modal('#af2_app_modal');
            },
            error: ( error ) => {
                $('form[name="af2_app_form"] #af2_delete_app_button .loading').addClass('af2_hide');
            }
        }).done(function() {
            $('form[name="af2_app_form"] #af2_delete_app_button .loading').addClass('af2_hide');
        });        
    });

    $(document).on('af2_close_modal', '#af2_lizenz_modal', _ => {
        window.location.reload();
    })
    $(document).on('af2_close_modal', '#af2_app_modal', _ => {
        window.location.reload();
    })
});