$( document ).ready(function($) {

    $('form.af2_integration_form_wrapper').submit( (e) => {
        e.preventDefault();
        const formId = $(e.currentTarget).attr('id');
        const integrationId = $(e.currentTarget).attr('data-integrationid');

        let data = { action: 'af2_save_integration_credentials', integrationid: integrationId };

        $('.af2_credential_input[data-integration="'+formId+'"]').each((i, el) => {
            const optionvalue = $(el).attr('data-optionvalue');
            const value = $(el).val();

            data[optionvalue] = value;
        });

        jQuery.ajax({
            url: af2_menu_components_object.ajax_url,
            method: 'POST',
            data: data,
            beforeSend: () => {
                $('button[form="'+formId+'"] .loading').removeClass('af2_hide');
            },
            success: ( response ) => {
                $('button[form="'+formId+'"] .loading').addClass('af2_hide');
                $('button[form="'+formId+'"]').html(af2_integrationen_object.strings.saved);

				setTimeout(_ => {
					window.location.reload();
				}, 1000);
            },
            error: ( error ) => {
                $('button[form="'+formId+'"] .loading').addClass('af2_hide');
                $('button[form="'+formId+'"]').html(af2_integrationen_object.strings.not_saved);

				setTimeout(_ => {
					window.location.reload();
				}, 1000);
            }
        });
    });
    /*
    $('form[name="af2_license_form"]').submit( (e) => {
        e.preventDefault();
        
        jQuery.ajax({
            url: af2_menu_components_object.ajax_url,
            method:'POST',
            data: {
                action: 'af2_lizenz_check',
                key: $('form[name="af2_license_form"] .af2_edit_content_input').val()
            },
            beforeSend: () => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').removeClass('af2_hide');
            },
            success: ( response ) => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
                $('#af2_lizenz_modal .af2_modal_content').html(response);
                if(response != 'Die Domain ist aktiviert!') {
                    $('#af2_lizenz_modal').attr('data-bottombar', 'false');
                }
                else {
                    $('#af2_lizenz_modal').attr('data-bottombar', 'true');
                }
                af2_open_modal('#af2_lizenz_modal');
            },
            error: ( error ) => {
                $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
                $('#af2_lizenz_modal .af2_modal_content').html('Status:'+error.status +' '+ error.statusText+'<p>Error:<br>'+error.responseText+'</p>');
                af2_open_modal('#af2_lizenz_modal');
            }
        }).done(function() {
            $('form[name="af2_license_form"] #af2_save_license_button .loading').addClass('af2_hide');
        });        
    });

    $(document).on('af2_close_modal', '#af2_lizenz_modal', _ => {
        window.location.reload();
    })*/

});