<?php

// Include misc functions
require_once AF2_MISC_FUNCTIONS_PATH;


if (!get_option('af2_version_num_')) {
    add_option('af2_version_num_', '1');
}

if (!get_option('af2_version')) {
    add_option('af2_version', AF2_FINAL_VERSION);
} else {
    update_option('af2_version', AF2_FINAL_VERSION);
}

if (!get_option('af2_dark_mode')) {
    add_option('af2_dark_mode', '0');
}

// Deals and Projects
if (!get_option('dnp_mail')) {
    add_option('dnp_mail', '');
}
if (!get_option('dnp_api_key')) {
    add_option('dnp_api_key', '');
}
if (!get_option('af2_dnp_mail')) {
    add_option('af2_dnp_mail', get_option('dnp_mail'));
}
if (!get_option('af2_dnp_api_key')) {
    add_option('af2_dnp_api_key', get_option('dnp_api_key'));
}

// Klicktipp
if (!get_option('klicktipp_user')) {
    add_option('klicktipp_user', '');
}
if (!get_option('klicktipp_pw')) {
    add_option('klicktipp_pw', '');
}
if (!get_option('af2_klicktipp_user')) {
    add_option('af2_klicktipp_user', get_option('klicktipp_user'));
}
if (!get_option('af2_klicktipp_pw')) {
    add_option('af2_klicktipp_pw', get_option('klicktipp_pw'));
}

// ActiveCampaign
if (!get_option('ac_url')) {
    add_option('ac_url', '');
}
if (!get_option('ac_key')) {
    add_option('ac_key', '');
}
if (!get_option('af2_ac_url')) {
    add_option('af2_ac_url', get_option('ac_url'));
}
if (!get_option('af2_ac_key')) {
    add_option('af2_ac_key', get_option('ac_key'));
}

// HubSpot
if (!get_option('hubspot_key')) {
    add_option('hubspot_key', '');
}
if (!get_option('af2_hubspot_key')) {
    add_option('af2_hubspot_key', get_option('hubspot_key'));
}

// FinCRM
if (!get_option('fincrm_id')) {
    add_option('fincrm_id', '');
}
if (!get_option('fincrm_token')) {
    add_option('fincrm_token', '');
}
if (!get_option('af2_fincrm_id')) {
    add_option('af2_fincrm_id', get_option('fincrm_id'));
}
if (!get_option('af2_fincrm_token')) {
    add_option('af2_fincrm_token', get_option('fincrm_token'));
}

// Messagebird
if (!get_option('messagebird_key')) {
    add_option('messagebird_key', '');
}
if (!get_option('af2_messagebird_key')) {
    add_option('af2_messagebird_key', get_option('messagebird_key'));
}

// GetResponse
if (!get_option('af2_getresponse_api_key')) {
    add_option('af2_getresponse_api_key', '');
}

// MailChimp
if (!get_option('af2_mailchimp_api_key')) {
    add_option('af2_mailchimp_api_key', '');
}

// Pipedrive
if (!get_option('af2_pipedrive_api_key')) {
    add_option('af2_pipedrive_api_key', '');
}
if (!get_option('af2_pipedrive_api_url')) {
    add_option('af2_pipedrive_api_url', '');
}


if (!get_option('messagebird_error')) {
    add_option('messagebird_error', 'false');
}
if (!get_option('messagebird_error_text')) {
    add_option('messagebird_error_text', '');
}

// Zapier
if (!get_option('zapier_pw')) {
    add_option('zapier_pw', '');
}
if (!get_option('af2_zapier_pw')) {
    add_option('af2_zapier_pw', get_option('zapier_pw'));
}
if(!get_option('af2_zapier_url')) {
    add_option('af2_zapier_url', home_url( '/wp-json/af2/v1', 'https' ));
}
if (!get_option('af2_make_pw')) {
    add_option('af2_make_pw', '');
}
if(!get_option('af2_make_url')) {
    add_option('af2_make_url', home_url( '/wp-json/af2/make/v1', 'https' ));
}

if (!get_option('af2_impressions')) {
    add_option('af2_impressions', '0');
}

if (!get_option('af2_impressions_data')) {
    add_option('af2_impressions_data', serialize([]));
}

if (!get_option('af2_reset_dashboard_date')) {
    add_option('af2_reset_dashboard_date', date('Y-m-01 01:00:00', time()));
}

if (!get_option('af2_license_key')) {
    add_option('af2_license_key', '');
}
if (!get_option('license_password')) {
    add_option('license_password', '');
}
if (!get_option('af2_license_stat')) {
    add_option('af2_license_stat', '');
}
if (!get_option('af2_license_last_updated')) {
    add_option('af2_license_last_updated', '');
}
if (!get_option('registrationTokens')) {
	add_option('registrationTokens', '{ "tokens": [] }');
}
if (!get_option('registrationTokens')) {
	add_option('registrationTokens', '{ "tokens": [] }');
}
if(!get_option('regNewApp')) {
    update_option('registrationTokens', '{ "tokens": [] }');
    add_option('regNewApp', 'true');
}
if (!get_option('af2_registered_app_code')) {
    add_option('af2_registered_app_code', '');
}
if (!get_option('af2_registered_app_device')) {
    add_option('af2_registered_app_device', '');
}
if (!get_option('af2_registered_app_fcm')) {
    add_option('af2_registered_app_fcm', '');
}
if (!get_option('app_code')) {
    add_option('app_code', '');
}
if (!get_option('app_qr_code')) {
    add_option('app_qr_code', '');
    $randomNum = substr(str_shuffle("012345678901234567890123456789012345678901234567890123456789abcdefghijklmnopqrstuvwxyzabcdefghijklmopqrstuvwxyzsdjafkleiwopvnjkdvncyfeiawojkldsmvcxy"), 0, 32);
	update_option('app_qr_code', $randomNum);
}
if(!get_option('unread_leads')) {
    add_option('unread_leads', '{ "leads": [] }');
}


add_action('init', function() {
    if(!get_option('af2_categories')) {

        $id = wp_insert_post(array('post_content' => urlencode(serialize(array())), 'post_type' => 'af2_categories', 'post_status' => 'privat'));
        add_option('af2_categories', strval($id));
    }

    if(!get_option('af2_verification_codes')) {

        $id = wp_insert_post(array('post_content' => '{ "codes": [] }', 'post_type' => 'af2_ver_codes', 'post_status' => 'privat'));
        add_option('af2_verification_codes', strval($id));
    }
});

function af2_register_app_data() {
    if(get_option('af2_license_stat') == 'Die Domain ist aktiviert!') {
        $randomNum = substr(str_shuffle("012345678901234567890123456789012345678901234567890123456789abcdefghijklmnopqrstuvwxyzabcdefghijklmopqrstuvwxyzsdjafkleiwopvnjkdvncyfeiawojkldsmvcxy"), 0, 32);
        update_option('app_code', $randomNum);

        $valcode = get_option('app_code');
        $prefix = str_replace("wp-admin/", "", get_admin_url());
        $qrlink = $prefix.'wp-json/af2/app/v2/register_qr?val_code='.$valcode;

        update_option('app_qr_code', 'https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl='.$qrlink.'&choe=UTF-8');
    }
    else {
        update_option('app_code', '');
        update_option('app_qr_code', '');
    }
}

if(get_option('af2_license_stat') == 'Die Domain ist aktiviert!' && get_option('app_code') == '') af2_register_app_data();

/** TO DO $password -> JUST SAFE IT WITH NO WHITESPACE ERRORS */
if (get_option('af2_license_last_updated') === '' || intval(get_option('af2_license_last_updated')) != intval(create_timestamp())) {

    $urlparts = parse_url(home_url());
    $domain = $urlparts['host'];

    $password = '';
    $key = get_option('af2_license_key');


    $url = 'https://licenseserver-anfrageformular.com/key_validation/plugin_validation/plu_interface.php?passkey=1-dj!Activate281ThedaieksMenu192!E&event=checkthedomainevent&password=' . $password . '&key=' . $key . '&domain=' . $domain;
    $args = array(
        'headers' => array(
            'Accept: text/plain',
            'Content-Type: text/plain'
        ),
        'timeout' => 30,
    );

    $response = wp_remote_get($url, $args);
    $resp = wp_remote_retrieve_body($response);

    if (strpos($resp, 'ADK2918dSS') !== false) {
        $resp = str_replace('ADK2918dSS', '', $resp);
    }

    update_option('af2_license_stat', $resp);
    update_option('af2_license_last_updated', create_timestamp());

    
    //Version Tracking
    $af2_vers = get_option('af2_version');

    $urlparts = parse_url(home_url());
    $domain = af_base64UrlEncode($urlparts['host']);

    $baseurl = 'https://member.funnelforms.io/wp-json/version_checking/v1/setClientVersion';

    $curlurl = $baseurl . '?domain='.$domain.'&version='.$af2_vers;

    $ch = curl_init();
    $headers = array(

    );
    curl_setopt($ch, CURLOPT_URL, $curlurl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $resp = curl_exec($ch);

    curl_close($ch);

    af2_register_app_data();
}

// Checklist options

if (!get_option('checklist_question')) {
    add_option('checklist_question', '');
}
if(!get_option('checklist_contactform')) {
    add_option('checklist_contactform', 'false');
}
if(!get_option('checklist_form')) {
    add_option('checklist_form', 'false');
}
if(!get_option('checklist_shortcode')) {
    add_option('checklist_shortcode', 'false');
}
if(!get_option('checklist_appointmentevent')) {
    add_option('checklist_appointmentevent', 'false');
}
if(!get_option('checklist_appointmenteventquestion')) {
    add_option('checklist_appointmenteventquestion', 'false');
}
if(!get_option('checklist_appointtoform')) {
    add_option('checklist_appointtoform', 'false');
}
