<?php

abstract class Af2Integration {

    private $credential_fields;
    private $credentials;

    protected $api_values;

    public function __construct() {
        $this->credential_fields = $this->get_credential_fields();
    }

    public abstract function get_credential_fields();

    public function get_api_values() { return array(); }
    public function get_api_draw_fields() { return array(); }
    public function fetch_fields_from_api() { return null; }
    public function send_to_api() { return null; }
    public function is_active() { return false; }

    public function parse_form_questions_to_values($form_api_values, $contact_form_answers, $answer_string) {
        $api_values = $this->get_api_values();

        foreach( $api_values as $api_value ) {
            
            $value = null;

            switch($api_value['type']) {
                case 'contactform': {
                    $contact_form_value = $form_api_values->{$api_value['label']};
                    foreach( $contact_form_answers as $question ) {
                        $id = '['.$question['id'].']';
                        if(strtolower($id) == strtolower($contact_form_value)) $value = $question['value'];
                    }
                    break;
                }
                case 'text': {
                    $value = $form_api_values->{$api_value['label']};
                    break;
                }
                case 'field': {
                    $value = $form_api_values->{$api_value['label']};
                    break;
                }
                default: {
                    $value = null;
                    break;
                }
            }

            
            $this->api_values[$api_value['label']] = $value;
        }

        $this->api_values['answer_string'] = $answer_string;
    }

    public function get_credentials() {
        if(isset($this->credentials)) return $this->credentials;
        
        $credentials = array();
        foreach( $this->credential_fields as $field ) {
            $key = $field['key'];
            $option_value = get_option($field['option_value']);

            $credentials[$key] = $option_value;
        }

        $this->credentials = $credentials;
        return $credentials;
    }
}