<?php

require_once AF2_INTEGRATION_HANDLER_CLASS;
class DealsNProjects_Integration extends Af2Integration {

    public function get_credential_fields() {
        return array( 
            array( 'key' => 'mail', 'option_value' => 'af2_dnp_mail', 'icon' => 'fas fa-envelope', 'label' => 'E-Mail address:', 'type' => 'text' ),
            array( 'key' => 'api_key', 'option_value' => 'af2_dnp_api_key', 'icon' => 'fas fa-key', 'label' => 'API Key:', 'type' => 'password' ),
        );
    }

    public function is_active() { 
        $credentials = $this->get_credentials();

        if(!isset($credentials) || empty($credentials)) return false;
        if(!isset($credentials['mail']) || empty($credentials['mail'])) return false;
        if(!isset($credentials['api_key']) || empty($credentials['api_key'])) return false;

        return true;
    }

    public function send_to_api() { 
        $credentials = $this->get_credentials();

        $contact_create = json_encode(array(
            "FirstName" => $this->api_values['vorname'],
            "LastName" => $this->api_values['name'],
            "Organization" => $this->api_values['organisation'],
            "Communication" => array(
                "PhoneMobile" => $this->api_values['telefon'],
                "EMailAddress" => $this->api_values['mail']),
            "Address" => array(
                "Street" => $this->api_values['strasse'],
                "ZipCode" => $this->api_values['plz'],
                "City" => $this->api_values['stadt'])), JSON_FORCE_OBJECT);

        $data = $this->curlWrap("/mixed", $contact_create, "POST");

        $deal_create = json_encode(array(
            "Name" => $this->api_values['bezeichnung'],
            "LongDescription" => $this->api_values['answer_string'],
            "Stage" => "Open",
            "State" => "New",
            "CustomerId" => $data,
            "Probability" => 00.0,
            "DealOwnerName" => $credentials['mail']), JSON_FORCE_OBJECT);

        $this->curlWrap('/deal', $deal_create, "POST");
    }

    private function curlWrap($url, $json, $action) {
        $credentials = $this->get_credentials();
        
        $apikey = $credentials['api_key'];
        $user = $credentials['mail'];
        $baseurl = "https://api.julitec.com/api";
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_URL, $baseurl . $url);
        curl_setopt($ch, CURLOPT_USERPWD, $user . ":" . $apikey);
        
        switch ($action) {
            case "POST":
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
                break;
            case "GET":
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                break;
            case "PUT":
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            default:
                break;
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
        curl_setopt($ch, CURLOPT_USERAGENT, "MozillaXYZ/1.0");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $output = curl_exec($ch);
        curl_close($ch);
        $decoded = json_decode($output);
        return $decoded;
    }

    public function get_api_values() { 
        return array(
            array( 'label' => 'vorname', 'type' => 'contactform'),
            array( 'label' => 'name', 'type' => 'contactform'),
            array( 'label' => 'organisation', 'type' => 'contactform'),
            array( 'label' => 'telefon', 'type' => 'contactform'),
            array( 'label' => 'mail', 'type' => 'contactform'),
            array( 'label' => 'strasse', 'type' => 'contactform'),
            array( 'label' => 'plz', 'type' => 'contactform'),
            array( 'label' => 'stadt', 'type' => 'contactform'),
            array( 'label' => 'bezeichnung', 'type' => 'text'),
        ); 
    }

    public function get_api_draw_fields() { 
        return array(
            array(
                'label' => __('Contact information:', 'af2_multilanguage'),
                'fields' => array(
                    array( 'label' => __('First name', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'vorname' ),
                    array( 'label' => __('Name', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'name' ),
                    array( 'label' => __('Company', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'organisation' ),
                    array( 'label' => __('Phone', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'telefon' ),
                    array( 'label' => __('E-mail', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'mail' ),
                    array( 'label' => __('Street', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'strasse' ),
                    array( 'label' => __('Postcode', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'plz' ),
                    array( 'label' => __('City', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'stadt' ),
                ),
            ),
            array(
                'label' => __('Deal data:', 'af2_multilanguage'),
                'fields' => array(
                    array( 'label' => __('Deal name', 'af2_multilanguage'), 'required' => true, 'type' => 'text', 'value' => 'bezeichnung' ),
                ),
            ),
        );
    }
}