<div class="af2_custom_builder_wrapper">
    <h3 id="af2_terminevent_backend_heading" class="af2_builder_editable_object" data-editcontentid="backend_heading"></h3>   
    <div class="custom_builder_content_card" id="calendar">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorPrimary"><i class="fas fa-calendar"></i></div>
            <h5><?=__('Calendar', 'af2_multilanguage')?></h5>
        </div>
        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <p><?=__('Connect the external calendar in which this appointment should be entered', 'af2_multilanguage')?></p>
                    <div class="af2_do_column_el">
                        <div class="af2_terminbuchung_calendar_top_part">
                        <img src="<?= $af2_builder_custom_contents['calendar_image'] ?>" class="af2_terminbuchung_calender_status" width="50" height="50">
                            <div class="af2_terminbuchung_calendar_data">
                                <h5 class="af2_terminbuchung_calendar_name" style=""><?=$af2_builder_custom_contents['calendar_name']?></h5>
                                <div class="af2_terminbuchung_calendar_status" style=""><?=__('Connected calendar:', 'af2_multilanguage'); ?>  <span style="font-weight: 600"><?=$af2_builder_custom_contents['calendar_type']?></span></div>
                            </div>
                        </div>
                        <a class="af2_btn_link" href="<?=$af2_builder_custom_contents['buttonLink']?>">
                            <div id="revoke_button" class="af2_btn af2_btn_primary revoke_button"><i class="<?=$af2_builder_custom_contents['buttonIcon']?>"></i><?=$af2_builder_custom_contents['buttonText']?></div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(isset($af2_builder_custom_contents['calendarList']) && !empty($af2_builder_custom_contents['calendarList'])) { ?>
    <div class="custom_builder_content_card">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorPrimary"><i class="fas fa-calendar-week"></i></div>
            <h5><?=__('Calendar settings', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('In which calendar should this appointment be entered?', 'af2_multilanguage')?></h6>
                    <select id="select_calendar_typ" class="af2_edit_content_select" data-saveobjectid="calendar_typ" value="">
                        <?php foreach($af2_builder_custom_contents['calendarList'] as $calendar)  { ?>
                        <option value="<?=$calendar['calendar_id']?>"><?=$calendar['calendar_name']?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Which calendars should be checked for conflicts?', 'af2_multilanguage')?></h6>
                    <div class="af2_checkbox_flex_container">
                        <?php foreach($af2_builder_custom_contents['calendarList'] as $calendar)  { ?>
                        <div class="af2_checkbox_flex">
                            <input type="checkbox"  id="af2_calendar_<?=$calendar['calendar_id']?>" class="af2_edit_content_checkbox_array_list" data-saveobjectid="calendar_conflict" data-saveobjectidvalue="<?=$calendar['calendar_id']?>">
                            <p><label for="af2_calendar_<?=$calendar['calendar_id']?>"><?=$calendar['calendar_name']?></label></p>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <div class="custom_builder_content_card">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorOrange"><i class="fas fa-cog"></i></div>
            <h5><?=__('Basic settings', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Appointment type', 'af2_multilanguage')?></h6>
                    <div class="af2_checkbox_flex_container">
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_typ_personal" name="af2_terminevent_typ" class="af2_edit_content_radio" 
                                data-saveobjectid="typ" value="meeting_personal">
                            <label for="af2_typ_personal"><p><?=__('Personal appointment', 'af2_multilanguage')?></p></label>
                        </div>
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_typ_call" name="af2_terminevent_typ" class="af2_edit_content_radio" 
                                data-saveobjectid="typ" value="meeting_call">
                            <label for="af2_typ_call"><p><?=__('Call', 'af2_multilanguage')?></p></label>
                        </div>
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_typ_video" name="af2_terminevent_typ" class="af2_edit_content_radio" 
                                data-saveobjectid="typ" value="meeting_video">
                            <label for="af2_typ_video"><p><?=__('Video conference', 'af2_multilanguage')?></p></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="custom_builder_content_card" id="time">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorBlue"><i class="fas fa-clock"></i></div>
            <h5><?=__('Time settings', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Available times', 'af2_multilanguage')?></h6>
                    <div class="af2_terminevent_time_select">
                        
                    </div>
                    <div class="af2_edit_content_add af2_edit_content_add_verfuegbarkeit af2_btn af2_btn_primary"><i class="fas fa-plus"></i><?=__('Add time', 'af2_multilanguage')?></div>
                </div>
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Duration', 'af2_multilanguage')?></h6>
                    <div class="af2_terminevent_duration_select">
                        
                    </div>
                    <div class="af2_edit_content_add af2_edit_content_add_dauer af2_btn af2_btn_primary"><i class="fas fa-plus"></i><?=__('Add duration', 'af2_multilanguage')?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="custom_builder_content_card" id="reminder">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorGreen"><i class="fas fa-bell"></i></div>
            <h5><?=__('Appointment reminders', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Time of the reminder/s', 'af2_multilanguage')?></h6>
                    <div class="af2_terminevent_reminder_select">
                        
                    </div>
                    <div class="af2_edit_content_add af2_edit_content_add_reminder af2_btn af2_btn_primary"><i class="fas fa-plus"></i><?=__('Add reminder', 'af2_multilanguage')?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="custom_builder_content_card" id="date">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorBlue"><i class="fas fa-calendar-alt"></i></div>
            <h5><?=__('Date settings', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Date range', 'af2_multilanguage')?></h6>
                    <div class="af2_checkbox_flex_container">
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_daterange_future" name="af2_daterange" class="af2_edit_content_radio" 
                                data-saveobjectid="datumsbereich" value="daterange_future" 
                                data-togglecontentid="af2_daterange_future_group" data-togglecontentgroup="af2_daterange_toggle_group">
                            <label for="af2_daterange_future"><p><?=__('book a specific duration into the future', 'af2_multilanguage')?></p></label>
                        </div>
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_daterange_daterange" name="af2_daterange" class="af2_edit_content_radio" 
                                data-saveobjectid="datumsbereich" value="daterange_daterange" 
                                data-togglecontentid="af2_daterange_daterange_group" data-togglecontentgroup="af2_daterange_toggle_group">
                            <label for="af2_daterange_daterange"><p><?=__('book in a specific date range', 'af2_multilanguage')?></p></label>
                        </div>
                        <div class="af2_checkbox_flex">
                            <input type="radio"  id="af2_daterange_unlimited" name="af2_daterange" class="af2_edit_content_radio" 
                                data-saveobjectid="datumsbereich" value="daterange_unlimited" data-togglecontentgroup="af2_daterange_toggle_group">
                            <label for="af2_daterange_unlimited"><p><?=__('book unlimited into the future (maximum 6 months)', 'af2_multilanguage')?></p></label>
                        </div>
                    </div>
                </div>
                <div class="custom_builder_content_card_box_content">
                    <div id="af2_daterange_future_group" class="toggle_content_group" data-togglecontentgroup="af2_daterange_toggle_group">
                        <h6><?=__('Available date range', 'af2_multilanguage')?></h6>
                        <div class="af2_terminevent_array_wrapper">
                            <input id="input_future_number" type="number" class="af2_edit_content_input" data-saveobjectid="daterange_future_number" min="1" max="30">
                            <select id="select_daterange_unit" class="af2_edit_content_select" data-saveobjectid="daterange_future_unit" value="">
                                <option value="day"><?=__('Calendar day/s', 'af2_multilanguage')?></option>
                                <option value="week"><?=__('Calendar week/s', 'af2_multilanguage')?></option>
                                <option value="month"><?=__('Calendar month/s', 'af2_multilanguage')?></option>
                            </select>
                        </div>
                    </div>
                    <div id="af2_daterange_daterange_group" class="toggle_content_group" data-togglecontentgroup="af2_daterange_toggle_group">
                        <h6><?=__('Date range Details', 'af2_multilanguage')?></h6>
                        <input id="daterange_picker" type="text" name="daterangepicker">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="custom_builder_content_card">
        <div class="custom_builder_content_card_heading af2_icon_text">
            <div class="af2_icon_wrapper colorPrimary"><i class="fas fa-cog"></i></div>
            <h5><?=__('Advanced settings', 'af2_multilanguage')?></h5>
        </div>

        <div class="custom_builder_content_card_box_wrapper">
            <div class="custom_builder_content_card_box">
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Buffer time', 'af2_multilanguage')?></h6>
                    <select id="select_pufferzeit" class="af2_edit_content_select" data-saveobjectid="puffer" value="">
                        <option value="pufer_0"><?=__('No buffer time', 'af2_multilanguage')?></option>
                        <option value="puffer_5"><?=__('5 minutes', 'af2_multilanguage')?></option>
                        <option value="puffer_10"><?=__('10 minutes', 'af2_multilanguage')?></option>
                        <option value="puffer_15"><?=__('15 minutes', 'af2_multilanguage')?></option>
                        <option value="puffer_30"><?=__('30 minutes', 'af2_multilanguage')?></option>
                        <option value="puffer_60"><?=__('60 minutes', 'af2_multilanguage')?></option>
                    </select>
                </div>
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Minimal notice time', 'af2_multilanguage')?></h6>
                    <select id="select_vorlaufzeit" class="af2_edit_content_select" data-saveobjectid="vorlaufzeit" value="">
                        <option value="15"  ><?=__('15 minutes', 'af2_multilanguage')?></option>
                        <option value="30"  ><?=__('30 minutes', 'af2_multilanguage')?></option>
                        <option value="60"  ><?=__('1 hour', 'af2_multilanguage')?></option>
                        <option value="120" ><?=__('2 hours', 'af2_multilanguage')?></option>
                        <option value="180" ><?=__('3 hours', 'af2_multilanguage')?></option>
                        <option value="240" ><?=__('4 hours', 'af2_multilanguage')?></option>
                        <option value="300" ><?=__('5 hours', 'af2_multilanguage')?></option>
                        <option value="360" ><?=__('6 hours', 'af2_multilanguage')?></option>
                        <option value="1"   ><?=__('1 day', 'af2_multilanguage')?></option>
                        <option value="3"   ><?=__('3 days', 'af2_multilanguage')?></option>
                        <option value="7"   ><?=__('7 days', 'af2_multilanguage')?></option>
                    </select>
                </div>
                <div class="custom_builder_content_card_box_content">
                    <h6><?=__('Start times interval', 'af2_multilanguage')?></h6>
                    <select id="select_anfangszeit" class="af2_edit_content_select" data-saveobjectid="anfangszeit" value="">
                        <option value="5"><?=__('5 minutes', 'af2_multilanguage')?></option>
                        <option value="10"><?=__('10 minutes', 'af2_multilanguage')?></option>
                        <option value="15"><?=__('15 minutes', 'af2_multilanguage')?></option>
                        <option value="20"><?=__('20 minutes', 'af2_multilanguage')?></option>
                        <option value="30"><?=__('30 minutes', 'af2_multilanguage')?></option>
                        <option value="45"><?=__('45 minutes', 'af2_multilanguage')?></option>
                        <option value="60"><?=__('60 minutes', 'af2_multilanguage')?></option>
                        <option value="90"><?=__('90 minutes', 'af2_multilanguage')?></option>
                        <option value="120"><?=__('120 minutes', 'af2_multilanguage')?></option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>