<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2LeadsDetails extends Af2MenuCustom {

    protected function get_heading() { 
        $post = get_post($_GET['id']);
        return __('Lead from', 'af2_multilanguage').' '.get_post_field('post_date', $post); 
    }
    protected function get_menu_custom_template() { return AF2_CUSTOM_MENU_LEADDETAILS; }
    protected function get_show_sidebar_() { return true; }

    protected function get_af2_custom_contents_() { 
        return $this->get_lead_details(true);
    }

    protected function load_resources() {
        wp_enqueue_style('af2_leaddetails_style');
        parent::load_resources();
    }

    protected function get_menu_hook_inline_button_form_() { 
        return array( 
            'icon' => 'fas fa-download', 
            'label' => __('Export CSV file', 'af2_multilanguage'), 
            'id' => 'af2_export_csv', 
            'id_label' => 'id',
            'id_value' => $_GET['id'],
            'bonus_label' => 'af2_single_lead_download',
            'bonus_value' => 'true',
        ); 
    }
    public function do_request_handling() {
        if(isset($_POST['af2_single_lead_download'])) {
            require_once AF2_MENU_AJAX_LEADS;
            $ajax_leads = new Af2AjaxLeads();
            $lead_details = $this->get_lead_details(false);
            $ajax_leads->af2_handle_single_lead_export($lead_details['lead_details']);
        }
    }

    private function get_lead_details($get) {
        $post = get_post($get ? $_GET['id'] : $_POST['id']);

        $lead_details_array = array();
        $hidden_fields_array = array();

        $post_content = unserialize( urldecode( get_post_field( 'post_content', $post ) ) );

        if(isset($post_content['questions']) && is_array($post_content['questions'])) {
            foreach( $post_content['questions'] as $field ) {
                $label = $field['frage'];

                $value = $field['antwort'];
                if( is_array( $field['antwort'] ) ) {
                    $value = '';
                    $i = 0;
                    for ($i=0; $i < sizeof($field['antwort']); $i++) { 
                        $value .= $field['antwort'][$i];
                        if($i < sizeof($field['antwort'])-1) $value .= ', ';
                    }
                }
                $new_field = array( 'label' => $label, 'value' => $value );
                array_push($lead_details_array, $new_field);
            }
        }

        if(isset($post_content['contact_form']) && is_array($post_content['contact_form'])) {
            foreach( $post_content['contact_form'] as $field ) {
                $label = isset($field['label']) && !empty($field['label']) ? $field['label'] : $field['id'];
                $new_field = array( 'label' => $label, 'value' => $field['input'] );
                array_push($lead_details_array, $new_field);
            }
        }

        if(isset($post_content['analyticsData']) && is_array($post_content['analyticsData'])) {
            foreach( $post_content['analyticsData'] as $field ) {
                $label = $field['id'];
                if($label == 'queryString') $label = __('Received URL parameters', 'af2_multilanguage');
                if($label == 'url') $label = __('URL on which the form was submitted', 'af2_multilanguage');
                $new_field = array( 'label' => $label, 'value' => $field['value'] );
                array_push($lead_details_array, $new_field);
            }
        }

        if(!isset($post_content['questions']) && !isset($post_content['contact_form']) && !isset($post_content['analyticsData'])) {
            foreach($post_content as $field) {
                $label = isset($field['title']) && !empty($field['title']) ? $field['title'] : $field['id'];
                $value = is_array($field['answer']) ? '---' : $field['answer'];

                $new_field = array( 'label' => $label, 'value' => $value );
                array_push($lead_details_array, $new_field);
            }
        }


        if(isset($post_content['hidden_fields']) && is_array($post_content['questions'])) {
            foreach( $post_content['hidden_fields'] as $key => $val ) {
                $label = $key;
                $value = $val;
                
                if( is_array( $val ) ) {
                    $value = '';
                    $i = 0;
                    for ($i=0; $i < sizeof($val); $i++) { 
                        $value .= $val[$i];
                        if($i < sizeof($val)-1) $value .= "\n\n";
                    }
                }

                $new_field = array( 'label' => $label, 'value' => $value );
                array_push($hidden_fields_array, $new_field);
            }
        }

        return array('lead_details' => $lead_details_array, 'hidden_fields' => $hidden_fields_array);
    }
}