<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Kontaktformularbuilder extends Af2MenuBuilder {

    private $messagebird_integration;

    public function __construct($Admin) {
        require_once AF2_INTEGRATION_HANDLER_MESSAGEBIRD;
        $this->messagebird_integration = new Messagebird_Integration();

        parent::__construct($Admin);
    }

    protected function get_builder_heading() { return array('label' => 'Contact form editor', 'icon' => 'fas fa-edit'); }
    protected function get_builder_sidebar_data_() { return array('label' => 'Elements', 'icon' => 'fas fa-atom'); }
    protected function get_builder_sidebar_edit_() { return array('label' => 'Settings'); }
    protected function get_builder_template() { return AF2_BUILDER_TEMPLATE_KONTAKTFORMULAR; }
    protected function get_menu_builder_control_buttons_() { return array(array('id' => 'af2_goto_kontaktformularbuilder_settings', 'icon' => 'fas fa-cog', 'label' => 'Settings')); }
    protected function get_builder_sidebar_content_element_class_() { return 'af2_array_add_draggable af2_drop_on_remove'; }
    

    protected function get_close_editor_url() { return admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG ); }
    
    protected function get_builder_sidebar_content_elements_() {
        $array = array();

        array_push($array, array('label' => 'Salutation', 'image' => '/res/images/contact_form_types/salutation_type.png', 'elementid' => 'salutation_type'));
        array_push($array, array('label' => 'Name', 'image' => '/res/images/contact_form_types/name_type.png', 'elementid' => 'text_type_name'));
        array_push($array, array('label' => 'E-mail', 'image' => '/res/images/contact_form_types/email_type.png', 'elementid' => 'text_type_mail'));
        array_push($array, array('label' => 'Phone', 'image' => '/res/images/contact_form_types/phone_type.png', 'elementid' => 'text_type_phone'));
        array_push($array, array('label' => 'Text', 'image' => '/res/images/contact_form_types/text_type.png', 'elementid' => 'text_type_plain'));
        array_push($array, array('label' => 'Checkbox', 'image' => '/res/images/contact_form_types/checkbox_type.png', 'elementid' => 'checkbox_type'));
        array_push($array, array('label' => 'Google reCaptcha', 'image' => '/res/images/contact_form_types/recaptcha_type.png', 'elementid' => 'google_recaptcha'));
        array_push($array, array('label' => 'HTML content', 'image' => '/res/images/contact_form_types/content_type.png', 'elementid' => 'html_content'));
        if($this->messagebird_integration->is_active()) array_push($array, array('label' => 'SMS verification', 'image' => '/res/images/contact_form_types/phone_type.png', 'elementid' => 'text_type_phone_verification'));

        return $array;
    }
    protected function get_builder_sidebar_edit_elements_() {
        require_once AF2_MENU_KONTAKTFORMULARBUILDER_ELEMENTS_PATH;
        return get_kontaktformularbuilder_elements();
    }

    protected function get_builder_script() { return 'af2_kontaktformularbuilder'; }
    protected function get_builder_style() { return 'af2_kontaktformularbuilder_style'; }
    protected function get_builder_script_object_name() { return 'af2_kontaktformularbuilder_object';  }
    protected function get_builder_script_localize_array() { 
        return array(
            'redirect_kontaktformularbuilder_settings_url' => admin_url('/admin.php?page='.KONTAKTFORMULARBUILDER_SETTINGS_SLUG.'&id='.$_GET['id'] ),
            'wordpress_mail_url' => 'wordpress@'.parse_url(get_site_url(), PHP_URL_HOST),
            'reCaptcha_Url' => plugins_url('/res/images/reCaptcha.gif', AF2_PLUGIN),
            'page_title' => get_option('blogname'),
            'strings' => array(
                'answers_tag' => __('[ANSWERS]', 'af2_multilanguage'),
                'anrede' => __('salutation', 'af2_multilanguage'),
                'name' => __('name', 'af2_multilanguage'),
                'mail' => __('mail', 'af2_multilanguage'),
                'telefon' => __('phone', 'af2_multilanguage'),
                'text' => __('text', 'af2_multilanguage'),
                'mobile' => __('mobile', 'af2_multilanguage'),
                'checkbox' => __('checkbox', 'af2_multilanguage'),
                'name_placeholder' => __('Your name...', 'af2_multilanguage'),
                'mail_placeholder' => __('Your e-mail...', 'af2_multilanguage'),
                'phone_placeholder' => __('Your phone number...', 'af2_multilanguage'),
                'mobile_placeholder' => __('Your mobile number...', 'af2_multilanguage'),
                'text_placeholder' => __('Your text...', 'af2_multilanguage'),
                'checkbox_text' => __('I accept the privacy policy', 'af2_multilanguage'),
                'checkbox_text_enter' => __('Enter checkbox text...', 'af2_multilanguage'),
                'herr' => __('Mr.', 'af2_multilanguage'),
                'frau' => __('Mrs.', 'af2_multilanguage'),
                'divers' => __('Diverse', 'af2_multilanguage'),
                'firma' => __('Company', 'af2_multilanguage'),
                'send_form' => __('Submit form', 'af2_multilanguage'),
                'subject' => __('New Lead', 'af2_multilanguage'),
            )
        );
    }

    protected function load_resources() {
        wp_enqueue_script('af2_interact_js');
        wp_enqueue_script('af2_drag_drop');
        
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_media_iconpicker();

        parent::load_resources();
    }


    public static function save_function($content) {
        require_once AF2_MISC_FUNCTIONS_PATH;
        $own_content = $content;
        $echo_content = array();


        if(!isset($own_content['cftitle']) || empty($own_content['cftitle'])) {
            array_push($echo_content, array('label' => __('No contact form title (frontend) specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_contact_form_heading'));
        }

        if(!isset($own_content['send_button']) || empty($own_content['send_button'])) {
            array_push($echo_content, array('label' => __('No button text specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.contact_form_send_button_wrapper'));
        }

        if(!isset($own_content['name']) || empty($own_content['name'])) {
            array_push($echo_content, array('label' => __('No contact form title (backend) specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }


        if(isset($own_content['questions'])) {
            $i = 0;

            $ids_array = array();

            $messagebird_count = 0;

            foreach($own_content['questions'] as $question) {
                if(!isset($question['id']) || empty($question['id'])) {
                    array_push($echo_content, array('label' => __('All elements must have an ID!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_question_wrapper[data-editcontentarrayid="'.$i.'"]'));
                }
                else if($question['typ'] == 'salutation_type') {
                   if(
                       (!filter_var($question['allowSalutationCompany'], FILTER_VALIDATE_BOOLEAN)) &&
                       (!filter_var($question['allowSalutationDivers'], FILTER_VALIDATE_BOOLEAN)) &&
                       (!filter_var($question['allowSalutationFemale'], FILTER_VALIDATE_BOOLEAN)) &&
                       (!filter_var($question['allowSalutationMale'], FILTER_VALIDATE_BOOLEAN))
                    ) {
                        array_push($echo_content, array('label' => __('At least one field must be displayed for the salutation!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_question_wrapper[data-editcontentarrayid="'.$i.'"]'));
                    }
                }
                else if($question['typ'] == 'google_recaptcha') {
                    if(!isset($question['site_key']) || empty($question['site_key'])) {
                        array_push($echo_content, array('label' => __('The site key must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_question_wrapper[data-editcontentarrayid="'.$i.'"]'));
                    }
                    if(!isset($question['site_secret']) || empty($question['site_secret'])) {
                        array_push($echo_content, array('label' => __('The secret key must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_question_wrapper[data-editcontentarrayid="'.$i.'"]'));
                    }
                }
                if($question['typ'] == 'text_type_phone_verification') $messagebird_count++;

                if(in_array($question['id'], $ids_array)) {
                    array_push($echo_content, array('label' => __('An ID cannot be assigned twice!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_question_wrapper[data-editcontentarrayid="'.$i.'"]'));
                }
                array_push($ids_array, $question['id']);
                $i++;
            }

            if($messagebird_count > 0) {
                if(!isset($own_content['smsSender']) || empty($own_content['smsSender'])) {
                    array_push($echo_content, array('label' => __('An SMS sender must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
                }
                if(!isset($own_content['smsText']) || empty($own_content['smsText'])) {
                    array_push($echo_content, array('label' => __('An SMS message must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
                }
                else if(!af2_str_contains(strtolower($own_content['smsText']), strtolower(__('[CODE]', 'af2_multilanguage')))) {
                    array_push($echo_content, array('label' => __('The code is not passed in the SMS message!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
                }
                
                if($messagebird_count > 1) {
                    array_push($echo_content, array('label' => __('A maximum of one SMS verification is possible!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
            }
        }

        
        if(!isset($own_content['mailtext']) || empty($own_content['mailtext'])) {
            array_push($echo_content, array('label' => __('No e-mail message specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        else if(!af2_str_contains(strtolower($own_content['mailtext']), strtolower(__('[ANSWERS]', 'af2_multilanguage')))) {
            array_push($echo_content, array('label' => __('The tag [ANSWERS] is not included in the e-mail message!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        if(!isset($own_content['mailsubject']) || empty($own_content['mailsubject'])) {
            array_push($echo_content, array('label' => __('No e-mail subject specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        if(!isset($own_content['mailto']) || empty($own_content['mailto'])) {
            array_push($echo_content, array('label' => __('No e-mail recipient specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        if(!isset($own_content['mailfrom']) || empty($own_content['mailfrom'])) {
            array_push($echo_content, array('label' => __('No sender e-mail specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        if(!isset($own_content['mailfrom_name']) || empty($own_content['mailfrom_name'])) {
            array_push($echo_content, array('label' => __('No sender name specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
        }
        if($own_content['use_autorespond'] == 'true') {
            if(!isset($own_content['autoresponder_field']) || empty($own_content['autoresponder_field'])) {
                array_push($echo_content, array('label' => __('No autoresponder e-mail address specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
            if(!isset($own_content['autoresponder_nachricht']) || empty($own_content['autoresponder_nachricht'])) {
                array_push($echo_content, array('label' => __('No autoresponder message specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
            if(!isset($own_content['autoresponder_subject']) || empty($own_content['autoresponder_subject'])) {
                array_push($echo_content, array('label' => __('No autoresponder subject specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
        }
        if($own_content['use_smtp'] == 'true') {
            if(!isset($own_content['smtp_host']) || empty($own_content['smtp_host'])) {
                array_push($echo_content, array('label' => __('No SMTP server specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
            if(!isset($own_content['smtp_username']) || empty($own_content['smtp_username'])) {
                array_push($echo_content, array('label' => __('No SMTP username specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
            if(!isset($own_content['smtp_password']) || empty($own_content['smtp_password'])) {
                array_push($echo_content, array('label' => __('No SMTP password specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
            if(!isset($own_content['smtp_port']) || empty($own_content['smtp_port'])) {
                array_push($echo_content, array('label' => __('No SMTP port specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder_settings'));
            }
        }


        if(isset($own_content['redirect_params'])) {
            $i = 0;

            $ids_array = array();
            foreach($own_content['redirect_params'] as $param) {
                if(!isset($param['text']) || empty($param['text']) || !isset($param['field']) || trim($param['field']) == '') {
                    array_push($echo_content, array('label' => __('All redirect parameter must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_redirect_params_wrapper[data-editcontentarrayid="'.$i.'"]'));
                }
                $i++;
            }
        }

        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }

        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));

        echo json_encode($echo_content);
        return $own_content;
    }
}
