<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Integrationen extends Af2MenuCustom {

    protected function get_heading() { return 'Integrations'; }
    protected function get_menu_custom_template() { return AF2_CUSTOM_MENU_INTEGRATIONEN; }
    protected function get_af2_custom_contents_() {
        
        require_once AF2_INTEGRATION_HANDLER_DEALSNPROJECTS;
        $dnp_handler = new DealsNProjects_Integration();
        $dnp_fields = $dnp_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_KLICKTIPP;
        $klicktipp_handler = new Klicktipp_Integration();
        $klicktipp_fields = $klicktipp_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_ACTIVECAMPAIGN;
        $ac_handler = new ActiveCampaign_Integration();
        $ac_fields = $ac_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_ZAPIER;
        $zapier_handler = new Zapier_Integration();
        $zapier_fields = $zapier_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_MAKE;
        $make_handler = new Make_Integration();
        $make_fields = $make_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_FINCRM;
        $fincrm_handler = new FinCRM_Integration();
        $fincrm_fields = $fincrm_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_MESSAGEBIRD;
        $messagebird_handler = new Messagebird_Integration();
        $messagebird_fields = $messagebird_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_HUBSPOT;
        $hubspot_handler = new HubSpot_Integration();
        $hubspot_fields = $hubspot_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_PIPEDRIVE;
        $pipedrive_handler = new PipeDrive_Integration();
        $pipedrive_fields = $pipedrive_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_GETRESPONSE;
        $getresponse_handler = new GetResponse_Integration();
        $getresponse_fields = $getresponse_handler->get_credential_fields();

        require_once AF2_INTEGRATION_HANDLER_MAILCHIMP;
        $mailchimp_handler = new MailChimp_Integration();
        $mailchimp_fields = $mailchimp_handler->get_credential_fields();


        return array(
            array('name' => 'Deals & Projects',     'type' => 'Agency software',        'active' => 1, 'modal_id' => 'dealsnprojects', 'credentials' => $dnp_fields),
            array('name' => 'KlickTipp',            'type' => 'E-mail marketing',       'active' => 1, 'modal_id' => 'klicktipp', 'credentials' => $klicktipp_fields),
            array('name' => 'ActiveCampaign',       'type' => 'E-mail marketing',       'active' => 1, 'modal_id' => 'activecampaign', 'credentials' => $ac_fields),
            array('name' => 'FinCRM',               'type' => 'Financial CRM',             'active' => 1, 'modal_id' => 'fincrm', 'credentials' => $fincrm_fields),
            array('name' => 'Zapier',               'type' => 'Automation',        'active' => 1, 'modal_id' => 'zapier', 'credentials' => $zapier_fields),
            array('name' => 'Make',               'type' => 'Automation',        'active' => 1, 'modal_id' => 'make', 'credentials' => $make_fields),
            array('name' => 'MessageBird',          'type' => 'SMS verification',      'active' => 1, 'modal_id' => 'messagebird', 'credentials' => $messagebird_fields),
            array('name' => 'HubSpot',              'type' => 'CRM',                    'active' => 1, 'modal_id' => 'hubspot', 'credentials' => $hubspot_fields),
            array('name' => 'Pipedrive',            'type' => 'CRM',                    'active' => 1, 'modal_id' => 'pipedrive', 'credentials' => $pipedrive_fields),
            array('name' => 'GetResponse',          'type' => 'E-mail marketing',       'active' => 1, 'modal_id' => 'getresponse', 'credentials' => $getresponse_fields),
            array('name' => 'Mailchimp',            'type' => 'E-mail marketing',       'active' => 1, 'modal_id' => 'mailchimp', 'credentials' => $mailchimp_fields)
        );
    }

    protected function load_resources() {
        wp_enqueue_style('af2_integrationen_style');
        wp_localize_script( 'af2_integrationen', 'af2_integrationen_object', array(
            'strings' => array(
                'saved' => __('Saved successfully!', 'af2_multilanguage'),
                'not_saved' => __('An error has occurred!', 'af2_multilanguage'),
            )
        ));
        wp_enqueue_script('af2_integrationen');

        parent::load_resources();
    }
}
