<?php

abstract class Af2Menu {
    // Needed Everywhere
    protected $menu_type = null;
    protected $Admin = null;

    // Needed in no Builders
    protected $heading = null;
    protected $menu_functions_button = null; // optional
    protected $menu_functions_search = null; // optional
    protected $menu_functions_select = null; // optional
    protected $menu_hook_inline_checkbox = null; // optional
    protected $menu_hook_inline_search = null; // optional
    protected $menu_hook_extra_title = null; // optional
    protected $menu_hook_inline_button_form = null; // optional

    // Needed in Tables
    protected $menu_action_button_add_post = null; // optional
    protected $menu_action_button_copy_posts = null; // optional
    protected $menu_action_button_delete_posts = null; // optional
    protected $table_columns = null;
    protected $posts = null;
    protected $post_type_constant = null;
    protected $table_builder_load_url = null; // optional
    protected $table_builder_load_url_id = null; // optional
    protected $table_builder_load_url_ids_array = null; // optional

    protected $custom_template = null; // optional

    // Needed in Customs
    protected $menu_custom_template = null;
    protected $af2_custom_contents = null; // optional
    protected $show_sidebar = null; //optional

    // Needed in Builders
    protected $builder_heading = null;
    protected $builder_sidebar_data = null; // optional
    protected $builder_sidebar_select_filter = null; // optional
    protected $builder_sidebar_content_elements = null; // optional
    protected $builder_sidebar_content_element_class = null; // optional
    protected $builder_sidebar_edit = null; // optional
    protected $builder_template = null;
    protected $menu_builder_control_buttons = null; // optional
    protected $menu_builder_pre_control_buttons = null; // optional
    protected $builder_pre_heading_buttons = null; // optional
    protected $af2_builder_custom_contents = null; // optional
    protected $af2_own_save_button_id = null; // optional
    protected $close_editor_url = null; // optional

    // Functions
    public function __construct($Admin) {
        $this->Admin = $Admin;

        add_action('wp_loaded',array($this,'do_request_handling'));
    }

    abstract protected function load_resources();
    abstract protected function load_all_values();

    public function get_content() {
        $this->load_all_values();
        $this->load_resources();

        $menu_type = $this->menu_type;

        $heading = $this->heading;

        $custom_template = $this->custom_template;

        $menu_functions_button = $this->menu_functions_button;
        $menu_functions_search = $this->menu_functions_search;
        $menu_functions_select = $this->menu_functions_select;

        $menu_action_button_add_post = $this->menu_action_button_add_post;
        $menu_action_button_copy_posts = $this->menu_action_button_copy_posts;
        $menu_action_button_delete_posts = $this->menu_action_button_delete_posts;
        $menu_hook_inline_checkbox = $this->menu_hook_inline_checkbox;
        $menu_hook_inline_search = $this->menu_hook_inline_search;
        $menu_hook_extra_title = $this->menu_hook_extra_title;
        $menu_hook_inline_button_form = $this->menu_hook_inline_button_form;
        $table_columns = $this->table_columns;
        $posts = $this->posts;
        $post_type_constant = $this->post_type_constant;
        $table_builder_load_url = $this->table_builder_load_url;
        $table_builder_load_url_id = $this->table_builder_load_url_id;
        $table_builder_load_url_ids_array = $this->table_builder_load_url_ids_array;

        $menu_custom_template = $this->menu_custom_template;
        $af2_custom_contents = $this->af2_custom_contents;
        $show_sidebar = $this->show_sidebar;

        $builder_heading = $this->builder_heading;
        $close_editor_url = $this->close_editor_url;
        $builder_sidebar_data = $this->builder_sidebar_data;
        $builder_sidebar_select_filter = $this->builder_sidebar_select_filter;
        $builder_sidebar_content_elements = $this->builder_sidebar_content_elements;
        $builder_sidebar_content_element_class = $this->builder_sidebar_content_element_class;
        $builder_sidebar_edit = $this->builder_sidebar_edit;
        $builder_template = $this->builder_template;
        $menu_builder_control_buttons = $this->menu_builder_control_buttons;
        $menu_builder_pre_control_buttons = $this->menu_builder_pre_control_buttons;
        $builder_pre_heading_buttons = $this->builder_pre_heading_buttons;
        $af2_builder_custom_contents = $this->af2_builder_custom_contents;
        $af2_own_save_button_id = $this->af2_own_save_button_id;

        include AF2_MENU_WRAPPER_VIEW;
    }

    public function do_request_handling() { return null; }
}


abstract class Af2MenuTable extends Af2Menu {
    
    public function __construct($Admin) {
        parent::__construct($Admin);
        $this->menu_type = 'table';
        
        $this->post_type_constant = $this->get_post_type_constant();
    }

    protected function load_all_values() {
        $this->heading = $this->get_heading();

        $this->custom_template = $this->get_custom_template_();

        $this->menu_functions_button = $this->get_menu_functions_button_();
        $this->menu_functions_search = $this->get_menu_functions_search_();
        $this->menu_functions_select = $this->get_menu_functions_select_();

        $this->menu_action_button_add_post = null;
        $this->menu_action_button_copy_posts = $this->get_menu_action_button_copy_posts_();
        $this->menu_action_button_delete_posts = $this->get_menu_action_button_delete_posts_();
        $this->menu_hook_inline_checkbox = $this->get_menu_hook_inline_checkbox_();
        $this->menu_hook_inline_search = $this->get_menu_hook_inline_search_();
        $this->menu_hook_extra_title = $this->get_menu_hook_extra_title_();
        $this->menu_hook_inline_button_form = $this->get_menu_hook_inline_button_form_();
        $add_post_array = $this->get_menu_action_button_add_post_();
        if(isset($add_post_array) && is_array($add_post_array) && sizeof($add_post_array) == 3 
            && isset($add_post_array['page']) && isset($add_post_array['post_type']) && isset($add_post_array['builder'])) {
            $this->menu_action_button_add_post = admin_url('/admin.php?page='.$add_post_array['page'].'&action=af2CreatePost&custom_post_type='.$add_post_array['post_type'].'&redirect_slug='.$add_post_array['builder']);
        }

        $this->table_builder_load_url = null;
        $this->table_builder_load_url_id = null;
        $table_builder_load_array = $this->get_table_builder_load_array_();
        if(isset($table_builder_load_array) && is_array($table_builder_load_array) && sizeof($table_builder_load_array) == 2 
            && isset($table_builder_load_array['page']) && isset($table_builder_load_array['id_label']) ) {
            $this->table_builder_load_url = admin_url('/admin.php?page=').$table_builder_load_array['page'].'&id=';
            $this->table_builder_load_url_id = $table_builder_load_array['id_label'];
        }

        $this->table_builder_load_url_ids_array = null;
        $table_builder_load_array_ids = $this->get_table_builder_load_array_ids_();
        if(isset($table_builder_load_array_ids) && is_array($table_builder_load_array_ids)) {
            $this->table_builder_load_url_ids_array = array();
            foreach($table_builder_load_array_ids as $field) {
                if(isset($field['page']) && isset($field['id_label']) && isset($field['id_param']) ) {
                    $array = array();
                    $array['page'] = admin_url('/admin.php?page=').$field['page'].'&'.$field['id_param'].'=';
                    $array['id'] = $field['id_label'];

                    array_push($this->table_builder_load_url_ids_array, $array);
                }
            }
        }
            
        $this->table_columns = $this->get_table_columns();
    }

    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_basic_admin_menu_resources();
    }

    public function get_content() {
        $this->Admin->af2_delete_drafts($this->post_type_constant);
        $this->posts = $this->edit_posts_for_table($this->get_posts());
        parent::get_content();
    }

    abstract protected function get_heading();
    protected function get_menu_functions_button_() { return null; }
    protected function get_menu_functions_search_() { return null; }
    protected function get_menu_functions_select_() { return null; }
    
    protected function get_custom_template_() { return null; }

    protected function get_menu_action_button_add_post_() { return null; }
    protected function get_menu_action_button_copy_posts_() { return null; }
    protected function get_menu_action_button_delete_posts_() { return null; }
    protected function get_menu_hook_inline_checkbox_() { return null; }
    protected function get_menu_hook_inline_search_() { return null; }
    protected function get_menu_hook_extra_title_() { return null; }
    protected function get_menu_hook_inline_button_form_() { return null; }
    abstract protected function get_table_columns();
    protected function get_posts() { return $this->Admin->af2_get_posts($this->post_type_constant); }
    abstract protected function edit_posts_for_table($posts);
    abstract protected function get_post_type_constant();

    protected function get_table_builder_load_array_() { return null; }
    protected function get_table_builder_load_array_ids_() { return null; }
}

abstract class Af2MenuCustom extends Af2Menu {

    public function __construct($Admin) {
        parent::__construct($Admin);
        $this->menu_type = 'custom';
    }

    protected function load_all_values() {
        $this->heading = $this->get_heading();
        $this->menu_functions_button = $this->get_menu_functions_button_();
        $this->menu_functions_search = $this->get_menu_functions_search_();
        $this->menu_functions_select = $this->get_menu_functions_select_();


        $this->menu_hook_inline_checkbox = $this->get_menu_hook_inline_checkbox_();
        $this->menu_hook_inline_search = $this->get_menu_hook_inline_search_();
        $this->menu_hook_extra_title = $this->get_menu_hook_extra_title_();
        $this->menu_hook_inline_button_form = $this->get_menu_hook_inline_button_form_();

        $this->menu_custom_template = $this->get_menu_custom_template();
        $this->af2_custom_contents = $this->get_af2_custom_contents_();
        $this->show_sidebar = $this->get_show_sidebar_();
    }

    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_basic_admin_menu_resources();
    }

    abstract protected function get_heading();
    protected function get_menu_functions_button_() { return null; }
    protected function get_menu_functions_search_() { return null; }
    protected function get_menu_functions_select_() { return null; }


    protected function get_menu_hook_inline_checkbox_() { return null; }
    protected function get_menu_hook_inline_search_() { return null; }
    protected function get_menu_hook_extra_title_() { return null; }
    protected function get_menu_hook_inline_button_form_() { return null; }

    abstract protected function get_menu_custom_template();
    protected function get_af2_custom_contents_() { return null; }
    protected function get_show_sidebar_() { return false; }
}

abstract class Af2MenuBuilder extends Af2Menu {
    public function __construct($Admin) {
        parent::__construct($Admin);
        $this->menu_type = 'builder';
    }

    protected function load_all_values() { 
        $this->builder_heading = $this->get_builder_heading();
        $this->close_editor_url = $this->get_close_editor_url();
        $this->builder_sidebar_data = $this->get_builder_sidebar_data_();
        $this->builder_sidebar_select_filter = $this->get_builder_sidebar_select_filter_();
        $this->builder_sidebar_content_elements = $this->get_builder_sidebar_content_elements_();
        $this->builder_sidebar_content_element_class = $this->get_builder_sidebar_content_element_class_();
        $this->builder_sidebar_edit = $this->get_builder_sidebar_edit_();
        $this->builder_template = $this->get_builder_template();
        $this->menu_builder_control_buttons = $this->get_menu_builder_control_buttons_();
        $this->menu_builder_pre_control_buttons = $this->get_menu_builder_pre_control_buttons_();
        $this->builder_pre_heading_buttons = $this->get_builder_pre_heading_buttons_();
        $this->af2_builder_custom_contents = $this->get_af2_builder_custom_contents_();
        $this->af2_own_save_button_id = $this->af2_own_save_button_id_();
    }


    protected function get_af2_builder_custom_contents_() { return null; }
    protected function af2_own_save_button_id_() { return 'af2_save_post'; }

    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        $builder_localize_array = array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'admin_url' => admin_url('/admin.php?page='),
            'post_id' => $this->get_builder_post_id_(),
            'af2_save_object' => $this->get_builder_save_object_(), 
            'sidebar_elements' => $this->get_builder_sidebar_edit_elements_(),
            'page' => sanitize_key($_GET['page']),
            'strings' => array(
                'speichern' => __('Save...', 'af2_multilanguage'),
                'error' => __('An error has occurred! Click to display the error!', 'af2_multilanguage'),
                'support' => __('An error has occurred! Please contact the support!', 'af2_multilanguage'),
            )
        );
        load_basic_admin_builder_resources($builder_localize_array);

        wp_localize_script( $this->get_builder_script(), $this->get_builder_script_object_name(), $this->get_builder_script_localize_array());
        wp_enqueue_style($this->get_builder_style());
        wp_enqueue_script($this->get_builder_script());
    }

    abstract public static function save_function($content);

    abstract protected function get_builder_heading();
    abstract protected function get_close_editor_url();
    protected function get_builder_sidebar_data_() { return null; }
    protected function get_builder_sidebar_select_filter_() { return null; }
    protected function get_builder_sidebar_content_elements_() { return null; }
    protected function get_builder_sidebar_content_element_class_() { return ''; }
    protected function get_builder_sidebar_edit_() { return null; }
    abstract protected function get_builder_template();

    protected function get_menu_builder_control_buttons_() { return null; }
    protected function get_menu_builder_pre_control_buttons_() { return null; }
    protected function get_builder_pre_heading_buttons_() { return null; }

    protected function get_builder_sidebar_edit_elements_() { return array(); }
    protected function get_builder_save_object_() { 
        if(!isset($_GET['id'])) return array();
        
        $associated_post = get_post( $_GET['id']);
        require_once AF2_MISC_FUNCTIONS_PATH;
        $post_content_array = af2_get_post_content($associated_post);
        return $post_content_array; 
    }
    protected function get_builder_post_id_() {
        if(!isset($_GET['id'])) return null;
        return $_GET['id'];
    }

    abstract protected function get_builder_script();
    abstract protected function get_builder_style();
    abstract protected function get_builder_script_object_name();
    abstract protected function get_builder_script_localize_array();

}

?>