<?php

class Af2AjaxExternal {

    function __construct() {}

    public function iframeContent() {
    
        $hosturl = $_POST['externtest'];
        $hosturl2 = $_SERVER['HTTP_HOST'];
    
        $contentID = $_POST['contentID'];
    
        /*if (sql_check($contentID) == 'ERROR') {
            die();
        }*/
    
        $return['style'] = apply_filters('af2_frame_styles',array(
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/styles/fontawesome_5.15.4.css',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/styles/frontend.css',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/styles/select.css',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/styles/intlTelInput.css'
        ));
        
        $return['script'] = apply_filters('af2_frame_scripts',array( 
            includes_url('js/jquery/ui/datepicker.min.js'),
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/scripts/dropzone.js',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/scripts/frontend.js',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/scripts/select.js',
            plugin_dir_url(AF2_PLUGIN) . 'res/frontend/scripts/intlTelInputSelect2.js',
        ));
    
        $server_max_size = size_format(wp_max_upload_size());
        $supported_types = $this->_af2_get_supported_mime_types();
    
        $return['nonce'] = wp_create_nonce('af2_FE_nonce') ;
        $return['supported_file_types'] = implode(',', $supported_types);
        $return['server_max_size'] = trim(str_replace("MB","", $server_max_size));

        $return['strings'] = array(
            'antworten_tag' => __('[ANSWERS]', 'af2_multilanguage'),
            'error_01' => __('ERROR - [01] Ajax error (caching error, please contact support)!', 'af2_multilanguage'),
            'fehler_admin' => __('An error has occurred! If you are an administrator of this website, you can find more information here:', 'af2_multilanguage'),
            'fehler_find' => __('An error has occurred! Please check your questions, contact forms and forms for completeness!', 'af2_multilanguage'),
            'help' => __('Get help', 'af2_multilanguage'),
            'help_url' => __('https://help.funnelforms.io/das-formular-wird-auf-der-website-nicht-angezeigt/', 'af2_multilanguage'),
            'erroroccured' => __('An error has occurred!', 'af2_multilanguage'),
            'sms' => __('SMS verification', 'af2_multilanguage'),
            'sms_sent' => __('A verification code was sent via SMS to the following number:', 'af2_multilanguage'),
            'sms_change' => __('Change number', 'af2_multilanguage'),
            'sms_repeat' => __('Send again', 'af2_multilanguage'),
            'sms_verify' => __('Verify', 'af2_multilanguage'),
            'country_search_placeholder' => __('Search for country or dial code', 'af2_multilanguage'),
            'dot' => __(',', 'af2_multilanguage'),
            'form_sent' => __('FORM SENT', 'af2_multilanguage'),
            'street' => __('Street', 'af2_multilanguage'),
            'no' => __('No.', 'af2_multilanguage'),
            'postcode' => __('Postcode', 'af2_multilanguage'),
            'city' => __('City', 'af2_multilanguage'),
            'resend' => __('Send again', 'af2_multilanguage'),
            'choosedur' => __('Select duration of appointment', 'af2_multilanguage'),
            'choosedurdot' => __('Select duration of appointment:', 'af2_multilanguage'),
            'choosetime' => __('Select time of appointment', 'af2_multilanguage'),
            'choosetimedot' => __('Select time of appointment:', 'af2_multilanguage'),
            'noappointments' => __('No appointments available on this day!', 'af2_multilanguage'),
            'mr' => __('Mr.', 'af2_multilanguage'),
            'mrs' => __('Mrs.', 'af2_multilanguage'),
            'diverse' => __('Diverse', 'af2_multilanguage'),
            'company' => __('Company', 'af2_multilanguage'),
            'date' => array(
                'sonntag' => __('Sunday', 'af2_multilanguage'),
                'montag' => __('Monday', 'af2_multilanguage'),
                'dienstag' => __('Tuesday', 'af2_multilanguage'),
                'mittwoch' => __('Wednesday', 'af2_multilanguage'),
                'donnerstag' => __('Thursday', 'af2_multilanguage'),
                'freitag' => __('Friday', 'af2_multilanguage'),
                'samstag' => __('Saturday', 'af2_multilanguage'),
                'so' => __('Su', 'af2_multilanguage'),
                'mo' => __('Mo', 'af2_multilanguage'),
                'di' => __('Tu', 'af2_multilanguage'),
                'mi' => __('We', 'af2_multilanguage'),
                'do' => __('Th', 'af2_multilanguage'),
                'fr' => __('Fr', 'af2_multilanguage'),
                'sa' => __('Sa', 'af2_multilanguage'),
                "januar" => __('January', 'af2_multilanguage'),
                "februar" => __('February', 'af2_multilanguage'),
                "marz" => __('March', 'af2_multilanguage'),
                "april" => __('April', 'af2_multilanguage'),
                "mai" => __('May', 'af2_multilanguage'),
                "juni" => __('June', 'af2_multilanguage'),
                "juli" => __('July', 'af2_multilanguage'),
                "august" => __('August', 'af2_multilanguage'),
                "september" => __('September', 'af2_multilanguage'),
                "oktober" => __('October', 'af2_multilanguage'),
                "november" => __('November', 'af2_multilanguage'),
                "dezember" => __('December', 'af2_multilanguage'),
                "jan" => __('Jan', 'af2_multilanguage'),
                "feb" => __('Feb', 'af2_multilanguage'),
                "mar" => __('Mar', 'af2_multilanguage'),
                "apr" => __('Apr', 'af2_multilanguage'),
                "mai" => __('May', 'af2_multilanguage'),
                "jun" => __('Jun', 'af2_multilanguage'),
                "jul" => __('Jul', 'af2_multilanguage'),
                "aug" => __('Aug', 'af2_multilanguage'),
                "sep" => __('Sep', 'af2_multilanguage'),
                "okt" => __('Oct', 'af2_multilanguage'),
                "nov" => __('Nov', 'af2_multilanguage'),
                "dez" => __('Dec', 'af2_multilanguage'),
            ),
        );
        

        $return['content'] = do_shortcode('[funnelforms id="' . $contentID . '"]');
    
        echo json_encode($return);
        wp_die();
    }
    
    private function _af2_get_supported_mime_types(){
        $supported_types = array();
        $restricted_types = array('application/javascript','text/css','text/html','application/java','application/ttaf+xml','application/vnd.ms-access','application/vnd.ms-project','application/vnd.oasis.opendocument.database');
        $wp_mime_types = get_allowed_mime_types();
        foreach ($wp_mime_types as $ext=>$type){
            if(!in_array($type, $restricted_types)){
                $supported_types[] = $type;
            }
        }
        
        return $supported_types;
    }
}
