<?php

function get_fragenbuilder_elements()
{
    $editArray = array();

    array_push(
        $editArray,
        array(
            'editContentId' => 'heading',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Question title', 'af2_multilanguage'),
                    'placeholder' => __('Enter question title...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_type_heading',
                        'empty_value' => __('Question title', 'af2_multilanguage'),
                        'saveObjectId' => 'name'
                    )
                ),
                array(
                    'type' => 'radio',
                    'icon' => 'fas fa-desktop',
                    'label' => __('Layout desktop', 'af2_multilanguage'),
                    'conditioned' => true,
                    'enabled' => false,
                    'default_option' => 'grid',
                    'options' => array(
                        array('label' => __('Grid view', 'af2_multilanguage'), 'value' => 'grid'),
                        array('label' => __('List view 1-column', 'af2_multilanguage'), 'value' => 'list'),
                        array('label' => __('List view 2-columns', 'af2_multilanguage'), 'value' => 'list2'),
                    ),
                    'details' => array(
                        'saveObjectId' => 'desktop_layout'
                    )
                ),
                array(
                    'type' => 'radio',
                    'icon' => 'fas fa-mobile-alt',
                    'label' => __('Layout mobile', 'af2_multilanguage'),
                    'conditioned' => true,
                    'enabled' => false,
                    'default_option' => 'list',
                    'options' => array(
                        array('label' => __('Grid view', 'af2_multilanguage'), 'value' => 'grid'),
                        array('label' => __('List view', 'af2_multilanguage'), 'value' => 'list')
                    ),
                    'details' => array(
                        'saveObjectId' => 'mobile_layout'
                    )
                ),
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-code',
                    'label' => __('JavaScript code (optional)', 'af2_multilanguage'),
                    'placeholder' => __('Enter JavaScript code...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'tracking_code'
                    )
                )
            ),
        ),
        array(
            'editContentId' => 'description',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Description (optional)', 'af2_multilanguage'),
                    'placeholder' => __('Enter description...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_type_description',
                        'empty_value' => __('Description (optional)', 'af2_multilanguage'),
                        'saveObjectId' => 'description'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'condition',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-up-alt',
                    'label' => __('Maximum number', 'af2_multilanguage'),
                    'placeholder' => __('Enter number...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_type_condition',
                        'htmlPreset' => __('Maximum number', 'af2_multilanguage') . ': ',
                        'empty_value' => __('Maximum number of selectable answers (optional)', 'af2_multilanguage'),
                        'saveObjectId' => 'condition'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'answer',
            'editContentArray' => true,
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Answer text', 'af2_multilanguage'),
                    'placeholder' => __('Enter answer text...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_answer_text',
                        'empty_value' => '',
                        'saveObjectId' => 'answers',
                        'saveObjectIdField' => 'text'
                    )
                ),
                array(
                    'type' => 'icon_image',
                    'icon' => 'fas fa-image',
                    'label' => __('Select image', 'af2_multilanguage'),
                    'label_buttons' => array('image' => __('Select image', 'af2_multilanguage'), 'icon' => __('Select icon', 'af2_multilanguage')),
                    'enable_icon' => true,
                    'enable_media' => true,
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_answer_img',
                        'saveObjectId' => 'answers',
                        'saveObjectIdField' => 'img'
                    )
                ),
                array(
                    'type' => 'textarea',
                    'icon' => 'fas fa-lock',
                    'label' => __('Hidden answer', 'af2_multilanguage'),
                    'placeholder' => __('Enter hidden answer text...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => false,
                        'empty_value' => '',
                        'saveObjectId' => 'answers',
                        'saveObjectIdField' => 'hidden_field'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'dropdown',
            'editContentArray' => true,
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Label', 'af2_multilanguage'),
                    'placeholder' => __('Enter label...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_dropdown_element',
                        'empty_value' => '',
                        'saveObjectId' => 'dropdown_options',
                        'saveObjectIdField' => 'label'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Value', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'saveObjectId' => 'dropdown_options',
                        'saveObjectIdField' => 'value'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'textrow',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Placeholder', 'af2_multilanguage'),
                    'placeholder' => __('Enter placeholder...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_textrow',
                        'empty_value' => __('Text row settings', 'af2_multilanguage'),
                        'saveObjectId' => 'textfeld',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-down',
                    'label' => __('Minimum number of characters', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'min_length',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-up',
                    'label' => __('Maximum number of characters', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'max_length',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow text only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_only_text'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow numbers only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_only_numbers'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow date only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_birthday'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'textfield_mandatory'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'textarea',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Placeholder', 'af2_multilanguage'),
                    'placeholder' => __('Enter placeholder...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_textarea',
                        'empty_value' => __('Text area settings', 'af2_multilanguage'),
                        'saveObjectId' => 'textarea',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-down',
                    'label' => __('Minimum number of characters', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'min_length',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-up',
                    'label' => __('Maximum number of characters', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'max_length',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow text only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_only_text'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow numbers only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_only_numbers'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Allow date only', 'af2_multilanguage'),
                    'radio_group' => 'text_only',
                    'details' => array(
                        'saveObjectId' => 'text_birthday'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'textarea_mandatory'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'date',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Date text', 'af2_multilanguage'),
                    'placeholder' => __('Enter date text...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_date',
                        'empty_value' => __('Date settings', 'af2_multilanguage'),
                        'saveObjectId' => 'datum',
                    )
                ),
                array(
                    'type' => 'select',
                    'icon' => 'fas fa-calendar',
                    'label' => __('Date format', 'af2_multilanguage'),
                    'select_values' => array(
                        array('value' => 'dd.mm.yy', 'label' => 'dd.mm.yy'),
                        array('value' => 'mm.dd.yy', 'label' => 'mm.dd.yy'),
                        array('value' => 'yy.mm.dd', 'label' => 'yy.mm.dd'),
                        array('value' => 'dd-mm-yy', 'label' => 'dd-mm-yy'),
                        array('value' => 'mm-dd-yy', 'label' => 'mm-dd-yy'),
                        array('value' => 'yy-mm-dd', 'label' => 'yy-mm-dd'),
                        array('value' => 'dd/mm/yy', 'label' => 'dd/mm/yy'),
                        array('value' => 'mm/dd/yy', 'label' => 'mm/dd/yy'),
                        array('value' => 'yy/mm/dd', 'label' => 'yy/mm/dd'),
                    ),
                    'default_value' => 'dd.mm.yy',
                    'details' => array(
                        'saveObjectId' => 'datum_format',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'datemandatory'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'slider',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Unit', 'af2_multilanguage'),
                    'placeholder' => __('Enter unit...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_label_wrapper',
                        'saveObjectId' => 'label',
                        'throwEvent' => 'af2_calc_label',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Show unit before number', 'af2_multilanguage'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_label_wrapper',
                        'saveObjectId' => 'lab',
                        'throwEvent' => 'af2_calc_label',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-down',
                    'label' => __('Minimum value', 'af2_multilanguage'),
                    'placeholder' => __('Enter minimum value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_value_min',
                        'saveObjectId' => 'min',
                        'throwEvent' => 'af2_calculate_dots',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-sort-numeric-up',
                    'label' => __('Maximum value', 'af2_multilanguage'),
                    'placeholder' => __('Enter maximum value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_value_max',
                        'saveObjectId' => 'max',
                        'throwEvent' => 'af2_calculate_dots',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Step size', 'af2_multilanguage'),
                    'placeholder' => __('Enter step size...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'saveObjectId' => 'step',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Start value', 'af2_multilanguage'),
                    'placeholder' => __('Enter start value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_start_value',
                        'saveObjectId' => 'start',
                        'throwEvent' => 'af2_calculate_dots',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Separator', 'af2_multilanguage'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_wrapper',
                        'saveObjectId' => 'thousand',
                        'throwEvent' => 'af2_calculate_dots',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Manual input', 'af2_multilanguage'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_wrapper',
                        'saveObjectId' => 'manual',
                        'throwEvent' => 'af2_slider_enable_manual',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Label', 'af2_multilanguage'),
                    'placeholder' => __('Enter label...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_alternate_label',
                        'saveObjectId' => 'text_manual',
                    )
                ),
                array(
                    'type' => 'icon_image',
                    'icon' => 'fas fa-image',
                    'label' => __('Select image', 'af2_multilanguage'),
                    'label_buttons' => array('image' => __('Select image', 'af2_multilanguage'), 'icon' => __('Select icon', 'af2_multilanguage'), 'remove' => __('Remove image / icon', 'af2_multilanguage')),
                    'enable_icon' => true,
                    'enable_media' => true,
                    'enable_remove' => true, 
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_slider_image',
                        'saveObjectId' => 'slider_image',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'file_upload',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Description', 'af2_multilanguage'),
                    'placeholder' => __('Enter description...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_file_upload_description',
                        'empty_value' => __('Description', 'af2_multilanguage'),
                        'saveObjectId' => 'fileupload_desc',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-upload',
                    'label' => __('Maximum upload size (in MB)', 'af2_multilanguage'),
                    'placeholder' => __('enter without MB...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'saveObjectId' => 'fileupload_max_size'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-upload',
                    'label' => __('Maximum number of file uploads', 'af2_multilanguage'),
                    'placeholder' => __('Enter number...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'saveObjectId' => 'fileupload_max_count'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'fileupload_mandatory'
                    )
                ),
                array(
                    'type' => 'restriction',
                    'label' => __('Allowed file types', 'af2_multilanguage'),
                    'icon' => 'fas fa-file',
                    'options' => af2_be_get_supported_mime_types(),
                    'label_all_activate' => __('Activate all', 'af2_multilanguage'),
                    'label_all_deactivate' => __('Deactivate all', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'restrictedFiles'
                    )
                )
            ),
        ),
        array(
            'editContentId' => 'map',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-search-plus',
                    'label' => __('Default zoom level', 'af2_multilanguage'),
                    'placeholder' => __('1=close / 20=far', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_address_zoom',
                        'saveObjectId' => 'zoomlevel',
                        'throwEvent' => 'af2_maps_zoom'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-map-marker-alt',
                    'label' => __('Starting position (center of map)', 'af2_multilanguage'),
                    'placeholder' => __('Germany', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_address_start_location',
                        'saveObjectId' => 'startposition',
                        'saveObjectIdField' => 'name',
                        'throwEvent' => 'af2_maps_typein'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'details' => array(
                        'saveObjectId' => 'mapmandatory'
                    )
                )
            ),
        ),
        array(
            'editContentId' => 'html',
            'fields' => array(
                array(
                    'type' => 'textarea',
                    'icon' => 'fas fa-code',
                    'label' => __('HTML content', 'af2_multilanguage'),
                    'placeholder' => __('Enter HTML content...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_html',
                        'empty_value' => __('Enter your HTML content here', 'af2_multilanguage'),
                        'saveObjectId' => 'content_area',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'far fa-hourglass',
                    'label' => __('Waiting time (in milliseconds) until the next automatic step', 'af2_multilanguage'),
                    'placeholder' => __('3000', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'content_wait',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Button to continue', 'af2_multilanguage'),
                    'own_checkbox_class' => 'af2_html_trigger_content_button',
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_html',
                        'saveObjectId' => 'content_button',
                        'throwEvent' => 'set_move_button',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'html_button',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Button text', 'af2_multilanguage'),
                    'placeholder' => __('Insert button text...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_html_button',
                        'empty_value' => __('Insert button text', 'af2_multilanguage'),
                        'saveObjectId' => 'content_button_text'
                    )
                )
            )
        ),
        array(
            'editContentId' => 'appointment',
            'fields' => array(
                array(
                    'type' => 'select',
                    'icon' => 'fas fa-calendar',
                    'label' => __('Select appointment event', 'af2_multilanguage'),
                    'required' => true,
                    'select_values' => af2_get_appointment_events(),
                    'default_value' => '',
                    'details' => array(
                        'saveObjectId' => 'terminbuchungsid',
                    )
                ),
            ),
        ),
    );


    return $editArray;
}

function af2_get_appointment_events() {
    $all_posts = array();
    $posts = get_posts(array(
        'post_type' => TERMINEVENT_POST_TYPE,
        'post_status' => 'privat',
        'numberposts' => -1,
        'order'    => 'ASC'
    ));

    array_push($all_posts, array('value' => '', 'label' => __('Select appointment event', 'af2_multilanguage')));
    
    foreach($posts as $post) {
        $status = get_post_field('post_status', $post);
        if($status == 'privat') {
            $newPost = array();
            require_once AF2_MISC_FUNCTIONS_PATH;
            $post_content = af2_get_post_content($post);
            $newPost['value'] = get_post_field('ID', $post);
            $newPost['label'] = isset($post_content['title']) && !empty($post_content['title']) ? $post_content['title'] : __('Appointment event title', 'af2_multilanguage');
            array_push($all_posts, $newPost);
        } 
    }
    
    return $all_posts;
}

function af2_be_get_supported_mime_types(){
    $supported_types = array();
    $restricted_types = array('application/javascript','text/css','text/html','application/java','application/ttaf+xml','application/vnd.ms-access','application/vnd.ms-project','application/vnd.oasis.opendocument.database');
    $wp_mime_types = get_allowed_mime_types();
    foreach ($wp_mime_types as $ext=>$type){
        if(!in_array($type, $restricted_types)){
            $supported_types[] = $type;
        }
    }
    
    return $supported_types;
}