<?php

defined('ABSPATH') or die('NO!');

class Admin {

    private $menu_object_dashboard = null;
    private $menu_object_fragen = null;
    private $menu_object_leads = null;
    private $menu_object_leads_details = null;
    private $menu_object_fragenbuilder = null;
    private $menu_object_kontaktformulare = null;
    private $menu_object_kontaktformularbuilder = null;
    private $menu_object_kontaktformularbuilder_settings = null;
    private $menu_object_formulare = null;
    private $menu_object_formularbuilder = null;
    private $menu_object_formularbuilder_settings = null;
    private $menu_object_formularbuilder_preview = null;
    private $menu_object_termine = null;
    private $menu_object_terminevents = null;
    private $menu_object_termineventbuilder = null;
    private $menu_object_import = null;
    private $menu_object_demoimport = null;
    private $menu_object_integrationen = null;
    private $menu_object_lizenz = null;
    private $menu_object_checklist = null;

    private $AdminHelper = null;
    private $af2_menu_ajax = null;

    public function __construct() {
        require_once AF2_ADMIN_HELPER_PATH;
        $this->AdminHelper = new Af2AdminHelper();

        add_action('init', array($this, 'af2_register_menu_files'));

        add_action('init', array($this, 'af2_add_custom_post_types'));

        add_action('admin_init', array($this,'af2_external_redirect'));
        add_action('admin_menu', array($this,'af2_add_menus'));

        add_action('admin_head', array($this, 'af2_external_links_target'));

        add_action('admin_head', array($this,'menu_highlight'));
        
        add_filter('admin_body_class', array($this, 'af2_fold_admin_menu'));
    }

    public function af2_register_menu_files() {

        require_once AF2_MENU_DASHBOARD_PATH;
        $this->menu_object_dashboard = new Af2Dashboard($this->AdminHelper);

        require_once AF2_MENU_LEADS_PATH;
        $this->menu_object_leads = new Af2Leads($this->AdminHelper);
        require_once AF2_MENU_LEADS_DETAILS_PATH;
        $this->menu_object_leads_details = new Af2LeadsDetails($this->AdminHelper);

        require_once AF2_MENU_FRAGEN_PATH;
        $this->menu_object_fragen = new Af2Fragen($this->AdminHelper);
        require_once AF2_MENU_FRAGENBUILDER_PATH;
        $this->menu_object_fragenbuilder = new Af2Fragenbuilder($this->AdminHelper);

        require_once AF2_MENU_KONTAKTFORMULARE_PATH;
        $this->menu_object_kontaktformulare = new Af2Kontaktformulare($this->AdminHelper);
        require_once AF2_MENU_KONTAKTFORMULARBUILDER_PATH;
        $this->menu_object_kontaktformularbuilder = new Af2Kontaktformularbuilder($this->AdminHelper);
        require_once AF2_MENU_KONTAKTFORMULARBUILDER_SETTINGS_PATH;
        $this->menu_object_kontaktformularbuilder_settings = new Af2KontaktformularbuilderSettings($this->AdminHelper);

        require_once AF2_MENU_FORMULARE_PATH;
        $this->menu_object_formulare = new Af2Formulare($this->AdminHelper);
        require_once AF2_MENU_FORMULARBUILDER_PATH;
        $this->menu_object_formularbuilder = new Af2Formularbuilder($this->AdminHelper);
        require_once AF2_MENU_FORMULARBUILDER_SETTINGS_PATH;
        $this->menu_object_formularbuilder_settings = new Af2FormularbuilderSettings($this->AdminHelper);
        require_once AF2_MENU_FORMULARBUILDER_PREVIEW_PATH;
        $this->menu_object_formularbuilder_preview = new Af2FormularbuilderPreview($this->AdminHelper);
        
        require_once AF2_MENU_TERMINE_PATH;
        $this->menu_object_termine = new Af2Termine($this->AdminHelper);

        require_once AF2_MENU_TERMINEVENTS_PATH;
        $this->menu_object_terminevents = new Af2Terminevents($this->AdminHelper);
        require_once AF2_MENU_TERMINEVENT_BUILDER_PATH;
        $this->menu_object_termineventbuilder = new Af2Termineventbuilder($this->AdminHelper);

        require_once AF2_MENU_IMPORT_PATH;
        $this->menu_object_import = new Af2ImportExport($this->AdminHelper);

        require_once AF2_MENU_DEMOIMPORT_PATH;
        $this->menu_object_demoimport = new Af2DemoImport($this->AdminHelper);

        require_once AF2_MENU_INTEGRATIONEN_PATH;
        $this->menu_object_integrationen = new Af2Integrationen($this->AdminHelper);

        require_once AF2_MENU_LIZENZ_PATH;
        $this->menu_object_lizenz = new Af2Lizenzen($this->AdminHelper);

        require_once AF2_MENU_CHECKLIST_PATH;
        $this->menu_object_checklist = new Af2Checklist($this->AdminHelper);


        require_once AF2_MENU_AJAX_PATH;
        $this->af2_menu_ajax = new Af2MenuAjax($this->AdminHelper);

        
    }

    public function af2_add_custom_post_types() {

        // Fragen
        $cpt_labels = array('name' => __('Questions', 'Post type general name', 'textdomain'),
        'singular_name' => __('Question', 'Post type singular name', 'textdomain'));

        register_post_type(FRAGE_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => true,
            'show_in_menu' => FRAGE_SLUG,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Fragen Backup
        $cpt_labels = array('name' => __('Questions', 'Post type general name', 'textdomain'),
        'singular_name' => __('Question', 'Post type singular name', 'textdomain'));

        register_post_type(FRAGE_BACKUP_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Kontaktformulare
        $cpt_labels = array('name' => __('Contact forms', 'Post type general name', 'textdomain'),
        'singular_name' => __('Contact form', 'Post type singular name', 'textdomain'));

        register_post_type(KONTAKTFORMULAR_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => true,
            'show_in_menu' => KONTAKTFORMULAR_SLUG,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Kontaktformular Backup
        $cpt_labels = array('name' => __('Contact forms', 'Post type general name', 'textdomain'),
        'singular_name' => __('Contact form', 'Post type singular name', 'textdomain'));

        register_post_type(KONTAKTFORMULAR_BACKUP_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Formulare
        $cpt_labels = array('name' => __('Forms', 'Post type general name', 'textdomain'),
        'singular_name' => __('Form', 'Post type singular name', 'textdomain'));

        register_post_type(FORMULAR_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => true,
            'show_in_menu' => FORMULAR_SLUG,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Formulare Backup
        $cpt_labels = array('name' => __('Forms', 'Post type general name', 'textdomain'),
        'singular_name' => __('Form', 'Post type singular name', 'textdomain'));

        register_post_type(FORMULAR_BACKUP_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Terminevents
        $cpt_labels = array('name' => __('Appointment events', 'Post type general name', 'textdomain'),
        'singular_name' => __('Appointment events', 'Post type singular name', 'textdomain'));

        register_post_type(TERMINEVENT_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => true,
            'show_in_menu' => TERMINEVENT_SLUG,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Requests
        $cpt_labels = array('name' => __('Requests', 'Post type general name', 'textdomain'),
        'singular_name' => __('Requests', 'Post type singular name', 'textdomain'));

        register_post_type(REQUEST_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));
        register_post_type(REQUEST_POST_TYPE_, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));

        // Requests
        $cpt_labels = array('name' => __('Appointment', 'Post type general name', 'textdomain'),
        'singular_name' => __('Appointment', 'Post type singular name', 'textdomain'));

        register_post_type(TERMIN_POST_TYPE, array(
            'labels' => $cpt_labels,
            'public' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'has_archive' => false,
            'publicly_queryable' => false,
            'query_var' => false,
        ));
    }

    public function af2_add_menus() {
        $slug = get_option('af2_license_stat') == 'Die Domain ist aktiviert!' ? MAIN_MENU_SLUG : LIZENZ_SLUG;

        // Adding the Main Admin Menu Page
        add_menu_page(__('Funnelforms', 'af2_multilanguage'), __('Funnelforms', 'af2_multilanguage'), 'manage_options', $slug, '', AF2_MENU_ICON_URL, 26);

        // Adding the watchable submenu pages
        if($slug == MAIN_MENU_SLUG) {
            add_submenu_page(MAIN_MENU_SLUG, __('Dashboard', 'af2_multilanguage'), __('Dashboard', 'af2_multilanguage'), 'manage_options', MAIN_MENU_SLUG, array($this->menu_object_dashboard, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('First steps', 'af2_multilanguage'), __('First steps', 'af2_multilanguage'), 'manage_options', CHECKLIST_SLUG, array($this->menu_object_checklist, 'get_content') );
            add_submenu_page(MAIN_MENU_SLUG, __('Leads', 'af2_multilanguage'), __('Leads', 'af2_multilanguage'), 'manage_options', LEADS_SLUG, array($this->menu_object_leads, 'get_content'));
            add_submenu_page(LEADS_SLUG, __('Lead Details', 'af2_multilanguage'), __('Lead Details', 'af2_multilanguage'), 'manage_options', LEADS_DETAILS_SLUG, array($this->menu_object_leads_details, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Questions', 'af2_multilanguage'), __('Questions', 'af2_multilanguage'), 'manage_options', FRAGE_SLUG, array($this->menu_object_fragen, 'get_content'));
            add_submenu_page(FRAGE_SLUG, __('Question editor', 'af2_multilanguage'), __('Question editor', 'af2_multilanguage'), 'manage_options', FRAGENBUILDER_SLUG, array($this->menu_object_fragenbuilder, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Contact forms', 'af2_multilanguage'), __('Contact forms', 'af2_multilanguage'), 'manage_options', KONTAKTFORMULAR_SLUG, array($this->menu_object_kontaktformulare, 'get_content'));
            add_submenu_page(KONTAKTFORMULAR_SLUG, __('Contact form editor', 'af2_multilanguage'), __('Contact form editor', 'af2_multilanguage'), 'manage_options', KONTAKTFORMULARBUILDER_SLUG, array($this->menu_object_kontaktformularbuilder, 'get_content'));
            add_submenu_page(KONTAKTFORMULAR_SLUG, __('Contact form editor', 'af2_multilanguage'), __('Contact form editor', 'af2_multilanguage'), 'manage_options', KONTAKTFORMULARBUILDER_SETTINGS_SLUG, array($this->menu_object_kontaktformularbuilder_settings, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Forms', 'af2_multilanguage'), __('Forms', 'af2_multilanguage'), 'manage_options', FORMULAR_SLUG, array($this->menu_object_formulare, 'get_content'));
            add_submenu_page(FORMULAR_SLUG, __('Form editor', 'af2_multilanguage'), __('Form editor', 'af2_multilanguage'), 'manage_options', FORMULARBUILDER_SLUG, array($this->menu_object_formularbuilder, 'get_content'));
            add_submenu_page(FORMULAR_SLUG, __('Form editor', 'af2_multilanguage'), __('Form editor', 'af2_multilanguage'), 'manage_options', FORMULARBUILDER_SETTINGS_SLUG, array($this->menu_object_formularbuilder_settings, 'get_content'));
            add_submenu_page(FORMULAR_SLUG, __('Form preview', 'af2_multilanguage'), __('Form preview', 'af2_multilanguage'), 'manage_options', FORMULARBUILDER_PREVIEW_SLUG, array($this->menu_object_formularbuilder_preview, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Appointments', 'af2_multilanguage'), __('Appointments', 'af2_multilanguage'), 'manage_options', TERMIN_SLUG, array($this->menu_object_termine, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Appointment events', 'af2_multilanguage'), __('Appointment events', 'af2_multilanguage'), 'manage_options', TERMINEVENT_SLUG, array($this->menu_object_terminevents, 'get_content'));
            add_submenu_page(TERMINEVENT_SLUG, __('Appointment event editor', 'af2_multilanguage'), __('Appointment event editor', 'af2_multilanguage'), 'manage_options', TERMINEVENTBUILDER_SLUG, array($this->menu_object_termineventbuilder, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Import & Export', 'af2_multilanguage'), __('Import & Export', 'af2_multilanguage'), 'manage_options', IMPORT_SLUG, array($this->menu_object_import, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Demo import', 'af2_multilanguage'), __('Demo import', 'af2_multilanguage'), 'manage_options', DEMOIMPORT_SLUG, array($this->menu_object_demoimport, 'get_content'));
            add_submenu_page(MAIN_MENU_SLUG, __('Integrations', 'af2_multilanguage'), __('Integrations', 'af2_multilanguage'), 'manage_options', INTEGRATIONEN_SLUG, array($this->menu_object_integrationen, 'get_content'));
        }

        // Adding the license page
        add_submenu_page(MAIN_MENU_SLUG, __('License & App', 'af2_multilanguage'), __('License & App', 'af2_multilanguage'), 'manage_options', LIZENZ_SLUG, array($this->menu_object_lizenz, 'get_content') );
        
        // External submenu pages
        add_submenu_page(MAIN_MENU_SLUG, 'Partnerprogramm', __('Affiliate program', 'af2_multilanguage'), 'manage_options', PARTNERPROGRAMM_SLUG, array($this, 'af2_external_redirect'));
        add_submenu_page(MAIN_MENU_SLUG, 'Help Center', __('Help center', 'af2_multilanguage'), 'manage_options', HELPCENTER_SLUG, array($this, 'af2_external_redirect'));
        add_submenu_page(MAIN_MENU_SLUG, 'Support', __('Support', 'af2_multilanguage'), 'manage_options', SUPPORT_SLUG, array($this, 'af2_external_redirect'));
    }

    public function af2_external_redirect() {
        $locale = get_locale();

        $partner = null;
        $help = null;
        $support = null;

        switch($locale) {
            case 'de_DE': {
                $partner = 'https://funnelforms.io/partnerprogramm/';
                $help = 'https://help.funnelforms.io/';
                $support = 'https://funnelforms.io/support/';
                break;
            }
            default: {
                $partner = 'https://en.funnelforms.io/affiliate-program';
                $help = 'https://help.funnelforms.io/en';
                $support = 'https://en.funnelforms.io/create-support-ticket';
                break;
            }
        }

        if (empty($_GET['page'])) {
            return;
        }

        if ('af2_partnerprogramm' === sanitize_key($_GET['page'])) {
            wp_redirect($partner);
            exit;
        }

        if ('af2_helpcenter' === sanitize_key($_GET['page'])) {
            wp_redirect($help);
            exit;
        }
        
        if ('af2_support' === sanitize_key($_GET['page'])) {
            wp_redirect($support);
            exit;
        }
    }

    public function af2_external_links_target(){
        ?>
            <script>
                jQuery(function(){
                    jQuery("a[href='admin.php?page=af2_partnerprogramm']").attr("target","__blank");
                    jQuery("a[href='admin.php?page=af2_helpcenter']").attr("target","__blank");
                    jQuery("a[href='admin.php?page=af2_support']").attr("target","__blank");
                })
            </script>
        <?php
    }

    public function menu_highlight(){

        global $parent_file, $submenu_file,  $plugin_page, $typenow;

        switch ($plugin_page){

            case 'af2_lead_details':
                $parent_file = 'af2_dashboard';
                $submenu_file = 'af2_leads';
                $plugin_page = 'af2_leads';
                break;
            case FRAGENBUILDER_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = FRAGE_SLUG;
                $plugin_page = FRAGE_SLUG;
                break;
            case LEADS_DETAILS_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = LEADS_SLUG;
                $plugin_page = LEADS_SLUG;
                break;
            case KONTAKTFORMULARBUILDER_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = KONTAKTFORMULAR_SLUG;
                $plugin_page = KONTAKTFORMULAR_SLUG;
                break;
            case KONTAKTFORMULARBUILDER_SETTINGS_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = KONTAKTFORMULAR_SLUG;
                $plugin_page = KONTAKTFORMULAR_SLUG;
                break;
            case FORMULARBUILDER_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = FORMULAR_SLUG;
                $plugin_page = FORMULAR_SLUG;
                break;
            case FORMULARBUILDER_SETTINGS_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = FORMULAR_SLUG;
                $plugin_page = FORMULAR_SLUG;
                break;
            case FORMULARBUILDER_PREVIEW_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = FORMULAR_SLUG;
                $plugin_page = FORMULAR_SLUG;
                break;
            case TERMINEVENTBUILDER_SLUG:
                $parent_file = MAIN_MENU_SLUG;
                $submenu_file = TERMINEVENT_SLUG;
                $plugin_page = TERMINEVENT_SLUG;
                break;

        }
    }

    public function af2_fold_admin_menu($classes){
        $current_screen = get_current_screen();
        if( $current_screen->base == 'admin_page_' . FRAGENBUILDER_SLUG
            || $current_screen->base == 'admin_page_' . KONTAKTFORMULARBUILDER_SLUG
            || $current_screen->base == 'admin_page_' . KONTAKTFORMULARBUILDER_SETTINGS_SLUG
            || $current_screen->base == 'admin_page_' . FORMULARBUILDER_SLUG
            || $current_screen->base == 'admin_page_' . FORMULARBUILDER_SETTINGS_SLUG
            || $current_screen->base == 'admin_page_' . FORMULARBUILDER_PREVIEW_SLUG
            || $current_screen->base == 'admin_page_' . TERMINEVENTBUILDER_SLUG
        ){
            $classes .= ' folded ';
        }
        return $classes;
    }
}

new Admin();
